/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCommonWizardPage;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCustomWizardPage;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ModuleDataCreationWizard
extends Wizard {
    private final ModuleDataCommonWizardPage commonPage;
    private ModuleDataCustomWizardPage customPage;
    private final IModelController model;
    private final String message;

    public ModuleDataCreationWizard(IModuleDataEditDialogProvider provider, String dataType, IModelController model, String message) {
        assert (provider != null) : "provider must not be null";
        assert (dataType != null) : "dataType must not be null";
        assert (model != null) : "model must not be null";
        this.commonPage = new ModuleDataCommonWizardPage(provider, dataType);
        this.customPage = new ModuleDataCustomWizardPage(model, dataType);
        this.model = model;
        this.message = message;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.commonPage);
        if (this.customPage != null) {
            this.addPage((IWizardPage)this.customPage);
            this.commonPage.addCategoryChangeListener(this.customPage, false);
        }
    }

    public boolean performFinish() {
        boolean exclusiveProjectLockIsConflicting;
        assert (this.commonPage != null);
        if (this.commonPage == null) {
            return true;
        }
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.model.getProjectUID());
        final boolean[] savedSuccessfully = new boolean[1];
        boolean bl = exclusiveProjectLockIsConflicting = !projectAgent.getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

            @Override
            public void run() {
                boolean commonPageSaved = ModuleDataCreationWizard.this.commonPage.performFinish();
                if (commonPageSaved) {
                    savedSuccessfully[0] = ModuleDataCreationWizard.this.customPage != null ? ModuleDataCreationWizard.this.customPage.performFinish() : true;
                }
            }
        });
        if (exclusiveProjectLockIsConflicting) {
            this.commonPage.setErrMsg(Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Message"));
            this.commonPage.setCommitable(true);
            return false;
        }
        return savedSuccessfully[0];
    }

    public boolean performCancel() {
        boolean success = true;
        if (this.customPage != null) {
            success &= this.customPage.performCancel();
        }
        return success &= this.commonPage.performCancel();
    }

    public boolean initialiseWizard(IModuleData[] items, IModuleData[] parents) {
        boolean successful = false;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.model.getProjectUID());
        EOLock conflictingLock = null;
        Throwable serverException = null;
        try {
            conflictingLock = projectAgent.getLockManager().anotherClientHasProjectLock();
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("CreationDialogues.ServerException" + serverException.getLocalizedMessage()));
        }
        if (conflictingLock != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("CreationDialogues.ExclusiveProjectLockMessage.Message"));
        } else {
            String moduleDataName = items[0].getModuleDataTypeDescriptionForFrame().getDisplayName();
            this.setWindowTitle(moduleDataName);
            this.commonPage.setItems(items, parents);
            this.commonPage.setDescription(this.message);
            this.commonPage.setTitle(moduleDataName);
            this.commonPage.setMessage(this.message);
            boolean hasCustomAttributes = false;
            IModuleUserDefinedAttributeTypesManager typesManager = this.model.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
            IModuleData[] iModuleDataArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleData item = iModuleDataArray[n2];
                String typeID = item.getTypeID();
                if (!typesManager.getAttributeTypesForModuleData(typeID).isEmpty()) {
                    hasCustomAttributes = true;
                    break;
                }
                ++n2;
            }
            if (hasCustomAttributes) {
                this.customPage.setItems(items, parents);
                this.customPage.setDescription(this.message);
                this.customPage.setTitle(moduleDataName);
                this.customPage.setMessage(this.message);
            } else {
                this.customPage = null;
            }
            successful = true;
        }
        return successful;
    }
}

