/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project.permissions;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPermissionMgr {
    private static final ILogger logger = Logger.getLogger(AbstractPermissionMgr.class);
    public static final String OPERATION_TYPE_CREATE = "Create";
    public static final String OPERATION_TYPE_MODIFY = "Modify";
    public static final String OPERATION_TYPE_DELETE = "Delete";
    public static final String OPERATION_TYPE_MODIFYALLATTRIBUTES = "ModifyAllAttributes";
    public static final String OPERATION_TYPE_LINKTOMODELELEMENT = "LinkToModelElement";
    public static final String OPERATION_TYPE_LINKTOMODULEDATAELELEMENT = "LinkToModuleDataElement";
    public static final String OPERATION_TYPE_MODIFYATTRIBUTE = "ModifyAttribute";
    private AbstractPermissionTemplateProvider permissionTemplateProvider;
    private IModuleProjectAgent projectAgent;
    private AbstractDataMgr dataMgr;
    private Map<String, Collection<String>> definedPermissionMap_operationsAffectedDataType_operationTypes;

    public void construct(PropertyChangesManager propertyChangesManager, AbstractPermissionTemplateProvider permissionTemplateProvider_, IModuleProjectAgent projectP, AbstractDataMgr dataMgrP) {
        this.permissionTemplateProvider = permissionTemplateProvider_;
        this.projectAgent = projectP;
        this.dataMgr = dataMgrP;
    }

    public void initialise() {
        this.createPermissionDefinitionMaps();
    }

    private void createPermissionDefinitionMaps() {
        this.definedPermissionMap_operationsAffectedDataType_operationTypes = new HashMap<String, Collection<String>>();
        for (ModulePermissionTemplate template : this.permissionTemplateProvider.getTemplates((IFrameProjectAgent)this.projectAgent)) {
            for (PermissionOperationDescription opDescription : template.getOperationDescriptions()) {
                if (this.definedPermissionMap_operationsAffectedDataType_operationTypes.get(opDescription.getOperationsAffectedDataType()) == null) {
                    this.definedPermissionMap_operationsAffectedDataType_operationTypes.put(opDescription.getOperationsAffectedDataType(), new HashSet());
                }
                this.definedPermissionMap_operationsAffectedDataType_operationTypes.get(opDescription.getOperationsAffectedDataType()).add(opDescription.getOperationType());
            }
        }
    }

    public final void showNoPermissionMsg(Shell shell) {
        assert (shell != null);
        MessageDialog mDialog = new MessageDialog(shell, Messages.getString("AbstractPermissionMgr.Title"), null, String.valueOf(Messages.getString("AbstractPermissionMgr.Msg1")) + Messages.getString("AbstractPermissionMgr.Msg2"), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }

    public final void addStandardPermissions(IPermissionOperand operand) {
        this.projectAgent.getPermissionModificationAgent().permissionOperandCreated(operand);
        try {
            this.projectAgent.getPermissionModificationAgent().commit();
        }
        catch (Throwable ta) {
            logger.error("ModuleLib.PermissionMgr.addStandardPermissions() - could not add standard permissions for operand:" + operand.getPermissionOperandType() + " - " + operand.getPermissionOperandDisplayName());
        }
    }

    public final void clearPermissions(IPermissionOperand operand) {
        assert (operand != null);
        this.projectAgent.getPermissionModificationAgent().permissionOperandRemoved(operand);
        try {
            this.projectAgent.getPermissionModificationAgent().commit();
        }
        catch (Throwable ta) {
            logger.error("ModuleLib.PermissionMgr.clearPermissions() - could not remove permissions for operand:" + operand.getPermissionOperandType() + " - " + operand.getPermissionOperandDisplayName(), ta);
        }
    }

    public final void clearPermissions(Collection<? extends IPermissionOperand> permissionOperands) {
        assert (permissionOperands != null);
        for (IPermissionOperand iPermissionOperand : permissionOperands) {
            this.projectAgent.getPermissionModificationAgent().permissionOperandRemoved(iPermissionOperand);
        }
        try {
            this.projectAgent.getPermissionModificationAgent().commit();
        }
        catch (Throwable throwable) {
            logger.error("ModuleLib.PermissionMgr.clearPermissions() - could not remove permissions.", throwable);
        }
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, IAttributeType type) {
        return this.mayEditAttribute(moduleData, parent, null, type);
    }

    public boolean mayEditAttribute(IModuleData moduleData, String attributeType) {
        return this.mayEditAttribute(moduleData, null, attributeType, null);
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, String attributeType) {
        return this.mayEditAttribute(moduleData, parent, attributeType, null);
    }

    private boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, String fixAttributeType, IAttributeType customAttributeType) {
        Collection<String> permissionsForItem = this.definedPermissionMap_operationsAffectedDataType_operationTypes.get(moduleData.getTypeID());
        String attributeTypeID = fixAttributeType != null ? fixAttributeType : customAttributeType.getAttributeTypeID().getUID();
        Collection<String> permissionsForAttribute = this.definedPermissionMap_operationsAffectedDataType_operationTypes.get(AbstractPermissionMgr.createOperationsAffectedItemIDForAttribute(moduleData.getTypeID(), attributeTypeID));
        boolean permissionDefined = permissionsForItem != null && permissionsForItem.contains(OPERATION_TYPE_MODIFYALLATTRIBUTES) || permissionsForAttribute != null && permissionsForAttribute.contains(OPERATION_TYPE_MODIFYATTRIBUTE);
        boolean permissionGranted = false;
        if (permissionDefined) {
            if (fixAttributeType != null) {
                permissionGranted = this.projectAgent.getModulePermissionChecker().hasAttributeModificationPermission(fixAttributeType, this.getParentOperandTree(moduleData, parent), (IModuleDataTypeDescriptionForFrame)moduleData.getModuleDataTypeDescriptionForFrame());
            } else if (customAttributeType != null) {
                permissionGranted = this.projectAgent.getModulePermissionChecker().hasAttributeModificationPermission(customAttributeType, this.getParentOperandTree(moduleData, parent), true);
            }
        }
        boolean mayEditAttribute = !permissionDefined || permissionGranted;
        return mayEditAttribute;
    }

    public IParentOperandTree getParentOperandTree(final IModuleData moduleData, final IModuleData parent) {
        return new IParentOperandTree(){
            private IPermissionOperandTreeContentProvider contentProvider;

            public IPermissionOperand getBaseOperand() {
                this.contentProvider = AbstractPermissionMgr.this.permissionTemplateProvider.getTreeContentProvider(AbstractPermissionMgr.this.projectAgent);
                if (moduleData instanceof IPermissionOperand && AbstractPermissionMgr.this.dataMgr.itemExists(moduleData.getUID(), moduleData.getTypeID())) {
                    return (IPermissionOperand)moduleData;
                }
                IModuleData base = parent;
                while (base != null && !(base instanceof IPermissionOperand)) {
                    base = AbstractPermissionMgr.this.dataMgr.getModelController().getParent(base);
                }
                if (base != null) {
                    return (IPermissionOperand)base;
                }
                if (AbstractPermissionMgr.this.dataMgr.itemExists(moduleData.getUID(), moduleData.getTypeID())) {
                    base = moduleData;
                    while (base != null && !(base instanceof IPermissionOperand)) {
                        base = AbstractPermissionMgr.this.dataMgr.getModelController().getParent(base);
                    }
                    if (base != null) {
                        return (IPermissionOperand)base;
                    }
                }
                if (parent == null) {
                    return this.contentProvider.getTreeRootNode();
                }
                return null;
            }

            public IPermissionOperand getParent(IPermissionOperand childOperand) {
                return this.contentProvider.getParent(childOperand);
            }
        };
    }

    @Deprecated
    protected boolean mayEditItemStructurally(IModuleData moduleData) {
        Collection<String> permissionsForItem = this.definedPermissionMap_operationsAffectedDataType_operationTypes.get(moduleData.getTypeID());
        if (permissionsForItem == null || !permissionsForItem.contains(OPERATION_TYPE_MODIFY)) {
            return true;
        }
        IParentOperandTree operandTree = this.getParentOperandTree(moduleData, null);
        IPermissionOperand permissionParent = operandTree.getBaseOperand();
        if (moduleData.equals(permissionParent)) {
            permissionParent = operandTree.getParent(permissionParent);
        }
        if (permissionParent instanceof IModuleData) {
            return this.mayEditItemStructurally(moduleData, (IModuleData)permissionParent);
        }
        return this.mayEditItemStructurally(moduleData, null);
    }

    public abstract boolean mayEditItemStructurally(IModuleData var1, IModuleData var2);

    public abstract boolean mayCreateChildren(IModuleData var1, String var2);

    public abstract boolean mayDeleteItem(IModuleData var1);

    public final boolean mayLinkItemToPlanElement(IModuleData item) {
        return this.mayLinkItemToPlanElement(item.getTypeID(), item);
    }

    public abstract boolean mayLinkItemToPlanElement(String var1, IModuleData var2);

    protected final AbstractDataMgr getDataMgr() {
        return this.dataMgr;
    }

    protected final IModuleProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public static String createOperationsAffectedItemIDForAttribute(String cockpitTypeID, String attributeID) {
        return String.valueOf(cockpitTypeID) + "--" + attributeID;
    }

    public static String createFIXME(String ... p) {
        StringBuilder sb = new StringBuilder("FIXME");
        String[] stringArray = p;
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append("--");
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    public void projectClosed() {
    }

    public boolean mayLinkItem(IModuleData item, String relationLinkTypeID, int relationContributionIndex) {
        assert (false);
        return this.mayEditItemStructurally(item, this.dataMgr.getParent(item));
    }
}

