/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.modules.IModuleLockManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LockAccess {
    private final ILockManager lockManager;
    private final LockResult lockResult;
    private Runnable operationOnRelease;
    private final boolean hasLock;
    private final boolean isExclusiveProjectLockConflicting;

    public LockAccess(ILockManager lockManager, LockResult lockResult) {
        this(lockManager, lockResult, null);
    }

    public LockAccess(ILockManager lockManager, LockResult lockResult, Runnable operationOnRelease) {
        assert (lockResult != null);
        assert (lockManager != null);
        this.lockResult = lockResult;
        this.lockManager = lockManager;
        this.operationOnRelease = operationOnRelease;
        this.hasLock = lockResult.wasSuccessful();
        this.isExclusiveProjectLockConflicting = this.hasLock ? false : lockResult.isExclusiveProjectLockConflicting();
    }

    public boolean hasLock() {
        return this.hasLock;
    }

    public boolean isExclusiveProjectLockConflicting() {
        return this.isExclusiveProjectLockConflicting;
    }

    public void releaseLocks() {
        Collection newLocks = this.lockResult.getNewlyAddedLocks();
        if (newLocks != null && !newLocks.isEmpty()) {
            this.lockManager.releaseLocks(newLocks);
        }
        if (this.operationOnRelease != null) {
            this.operationOnRelease.run();
        }
    }

    public void releaseAllLocks() {
        ArrayList allLocks = new ArrayList();
        allLocks.addAll(this.lockResult.getNewlyAddedLocks());
        allLocks.addAll(this.lockResult.getLocksClientAlreadyHave());
        if (allLocks.size() > 0) {
            this.lockManager.releaseLocks(allLocks);
        }
        if (this.operationOnRelease != null) {
            this.operationOnRelease.run();
        }
    }

    public Collection<EOLock> getConflictingLocks() {
        return this.lockResult.getConflictingLocks();
    }

    public void addOperationOnRelease(final Runnable newOperation) {
        assert (newOperation != null);
        if (this.operationOnRelease == null) {
            this.operationOnRelease = newOperation;
        } else {
            final Runnable currentOperation = this.operationOnRelease;
            this.operationOnRelease = new Runnable(){

                @Override
                public void run() {
                    currentOperation.run();
                    newOperation.run();
                }
            };
        }
    }

    public static LockAccess getEmptyAffirmativeLock(IModuleLockManager lockManager) {
        return new LockAccess((ILockManager)lockManager, new LockResult(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null));
    }
}

