/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.modules.IModuleLockManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractLockManager {
    private static final ILogger logger = Logger.getLogger(AbstractLockManager.class);
    private static final String MOV_LOCK_ITEM_UID = "mov";
    public static final int ID_TAIL_LENGTH = 252;
    private IModuleLockManager lockManager;
    private IModelController modelCtrl;
    private String projectUID;

    public void construct(IModuleLockManager p_lockManager, IModelController modelController, String p_projectUID) {
        this.lockManager = p_lockManager;
        this.modelCtrl = modelController;
        this.projectUID = p_projectUID;
    }

    public LockAccess acquireInsertLock(ICockpitProjectData data) {
        return this.acquireInsertLock(data, true);
    }

    public LockAccess acquireInsertLock(ICockpitProjectData parent, boolean showErrorMessage) {
        if (parent == null) {
            return LockAccess.getEmptyAffirmativeLock(this.lockManager);
        }
        if (this.modelCtrl.isNew(parent)) {
            return LockAccess.getEmptyAffirmativeLock(this.lockManager);
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "add", parent.getUID(), parent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(addLock);
        EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", parent.getUID(), parent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeCheckedList.add(delLock);
        for (ICockpitProjectData ascendant : this.getParents(parent)) {
            delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", ascendant.getUID(), ascendant.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(delLock);
        }
        return this.internalAcquireLock(parent, toBeCheckedList, toBeSetList, showErrorMessage);
    }

    public LockAccess acquireMoveLockBeforeMoving(ICockpitProjectData data, String dataTypeID) {
        return this.acquireMoveLockBeforeMoving(data, dataTypeID, true);
    }

    public LockAccess acquireMoveLockBeforeMoving(ICockpitProjectData data, String moduleID, boolean showErrorMessage) {
        long currentTimeMillis = System.currentTimeMillis();
        assert (data != null) : "data must not be null";
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        EOLock movLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "move", MOV_LOCK_ITEM_UID, moduleID, null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(movLock);
        toBeCheckedList.add(movLock);
        EOLock modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "modify", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(modLock);
        toBeCheckedList.add(modLock);
        for (ICockpitProjectData parent : this.getParents(data)) {
            EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", parent.getUID(), parent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(delLock);
        }
        EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeCheckedList.add(delLock);
        return this.internalAcquireLock(data, toBeCheckedList, toBeSetList, showErrorMessage);
    }

    public LockAccess acquireMoveLock(ICockpitProjectData newParent) {
        return this.acquireMoveLock(newParent, true);
    }

    public LockAccess acquireMoveLock(ICockpitProjectData newParent, boolean showErrorMessage) {
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "add", newParent.getUID(), newParent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(addLock);
        ArrayList<ICockpitProjectData> parents = new ArrayList<ICockpitProjectData>();
        parents.add(newParent);
        parents.addAll(this.getParents(newParent));
        for (ICockpitProjectData element : parents) {
            EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", element.getUID(), element.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(delLock);
        }
        return this.internalAcquireLock(newParent, toBeCheckedList, toBeSetList, showErrorMessage);
    }

    public LockAccess acquireEditLock(ICockpitProjectData data) {
        return this.acquireEditLock(data, true);
    }

    public LockAccess acquireEditLock(ICockpitProjectData data, boolean showErrorMessage) {
        if (this.modelCtrl.isNew(data)) {
            return LockAccess.getEmptyAffirmativeLock(this.lockManager);
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        EOLock modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "modify", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(modLock);
        toBeCheckedList.add(modLock);
        EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeCheckedList.add(delLock);
        for (ICockpitProjectData parent : this.getParents(data)) {
            delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", parent.getUID(), parent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(delLock);
        }
        return this.internalAcquireLock(data, toBeCheckedList, toBeSetList, showErrorMessage);
    }

    public LockAccess acquireRemoveLock(ICockpitProjectData data) {
        return this.acquireRemoveLock(data, true);
    }

    public LockAccess acquireRemoveLock(ICockpitProjectData data, boolean showErrorMessage) {
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(delLock);
        EOLock modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "modify", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeSetList.add(modLock);
        EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "add", data.getUID(), data.getTypeID(), null, null, new Timestamp(currentTimeMillis));
        toBeCheckedList.add(addLock);
        toBeCheckedList.add(modLock);
        toBeCheckedList.add(delLock);
        for (ICockpitProjectData child : this.getChildren(data)) {
            modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "modify", child.getUID(), child.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(modLock);
            addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "add", child.getUID(), child.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(addLock);
        }
        for (ICockpitProjectData parent : this.getParents(data)) {
            delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectUID, "delete", parent.getUID(), parent.getTypeID(), null, null, new Timestamp(currentTimeMillis));
            toBeCheckedList.add(delLock);
        }
        return this.internalAcquireLock(data, toBeCheckedList, toBeSetList, showErrorMessage);
    }

    public LockAccess acquireUniqueIDLock(String id, String cockpitTypeID) {
        String lockedItemUID = this.getLockedItemUIDForUniqueIDLock(id);
        String lockedItemTypeID = this.getLockedItemTypeIDForUniqueIDLock(cockpitTypeID);
        EOLock lock = new EOLock(UUIDGenerator.getUniqueID(), this.getProjectUID(), "uniqueID", lockedItemUID, lockedItemTypeID, null, null, new Timestamp(System.currentTimeMillis()));
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        toBeCheckedList.add(lock);
        toBeSetList.add(lock);
        LockAccess la = new LockAccess((ILockManager)this.getLockManager(), this.getLockManager().atomicCheckAndSetLocks(toBeCheckedList, toBeSetList, false));
        return la;
    }

    private String getLockedItemUIDForUniqueIDLock(String id) {
        return id.substring(Math.max(0, id.length() - 252));
    }

    private String getLockedItemTypeIDForUniqueIDLock(String cockpitTypeID) {
        return String.valueOf(cockpitTypeID) + "-ID";
    }

    public LockAccess acquireUniqueNameLock(String name, String cockpitTypeID, String parentUID) {
        EOLock lock = new EOLock(UUIDGenerator.getUniqueID(), this.getProjectUID(), "uniqueName", name, String.valueOf(cockpitTypeID) + "-Name-" + (parentUID != null ? parentUID : "root"), null, null, new Timestamp(System.currentTimeMillis()));
        ArrayList<EOLock> toBeSetList = new ArrayList<EOLock>();
        ArrayList<EOLock> toBeCheckedList = new ArrayList<EOLock>();
        toBeCheckedList.add(lock);
        toBeSetList.add(lock);
        LockAccess la = new LockAccess((ILockManager)this.getLockManager(), this.getLockManager().atomicCheckAndSetLocks(toBeCheckedList, toBeSetList, false));
        return la;
    }

    private LockAccess internalAcquireLock(ICockpitProjectData item, List<EOLock> toBeCheckedList, List<EOLock> toBeSetList, boolean showErrorMessage) {
        LockResult lockResult = this.lockManager.atomicCheckAndSetLocks(toBeCheckedList, toBeSetList, showErrorMessage);
        if (!lockResult.wasSuccessful()) {
            return new LockAccess((ILockManager)this.lockManager, lockResult);
        }
        if (this.itemExists(item)) {
            return new LockAccess((ILockManager)this.lockManager, lockResult);
        }
        Collection addedLocks = lockResult.getNewlyAddedLocks();
        this.lockManager.releaseLocks(addedLocks);
        if (showErrorMessage) {
            MessageDialog errorDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("AbstractLockMgr.ItemDeletedByAsynchronousUpdate.Title"), null, Messages.getString("AbstractLockMgr.ItemDeletedByAsynchronousUpdate.Message"), 2, new String[]{Messages.getString("AbstractLockMgr.ItemDeletedByAsynchronousUpdate.ButtonOk")}, 0);
            errorDialog.open();
        }
        return new LockAccess((ILockManager)this.lockManager, new LockResult(false, lockResult.getConflictingLocks(), Collections.emptyList(), Collections.emptyList(), lockResult.getPossibleServerException()));
    }

    public void releaseUniqueIdLock(String cockpitTypeId, String id) {
        String lockedItemUID = this.getLockedItemUIDForUniqueIDLock(id);
        String lockedItemTypeID = this.getLockedItemTypeIDForUniqueIDLock(cockpitTypeId);
        Collection locksToRelease = this.lockManager.findClientLocksByLockData("uniqueID", lockedItemTypeID, lockedItemUID);
        if (locksToRelease != null) {
            this.lockManager.releaseLocks(locksToRelease);
        } else {
            logger.warn("Lock to be released not found.");
        }
    }

    protected abstract Collection<ICockpitProjectData> getParents(ICockpitProjectData var1);

    protected abstract Collection<ICockpitProjectData> getChildren(ICockpitProjectData var1);

    protected abstract ICockpitProjectData getParent(ICockpitProjectData var1);

    protected abstract boolean itemExists(ICockpitProjectData var1);

    protected IModuleLockManager getLockManager() {
        return this.lockManager;
    }

    protected String getProjectUID() {
        return this.projectUID;
    }

    protected void setProjectUID(String projectUID) {
        this.projectUID = projectUID;
    }
}

