/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule2;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModuleFactory;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ExportDataProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModelController;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.ModulePlatformAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ServerProxy;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.shared.messages.MessageDataFactory;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractModuleFactory
implements IFMCAModuleFactory {
    protected IClientDataFactory clientDataFactory;
    private AbstractEncodableObjectFactory eoFactory;
    private ProjectMgr projectMgr;

    public AbstractModuleFactory(IClientDataFactory clientDataFactory, ProjectMgr projectMgr) {
        this.construct(clientDataFactory, projectMgr);
    }

    public AbstractModuleFactory() {
    }

    public void construct(IClientDataFactory clientDataFactory_, ProjectMgr projectMgr_) {
        assert (clientDataFactory_ != null);
        assert (projectMgr_ != null);
        this.clientDataFactory = clientDataFactory_;
        this.eoFactory = MessageDataFactory.getInstance();
        this.projectMgr = projectMgr_;
    }

    public IFMCAModule2 getNewModule(IFrameProjectAgent project) {
        ServerProxy serverProxy = this.createServerProxy();
        ModuleFacade moduleFacade = this.createModuleFacade();
        ModelController modelCtrl = this.createModelController();
        ProjectionMgr projectionMgr = this.createProjectionMgr();
        LinkMgr linkMgr = this.createLinkMgr();
        PropertyChangesManager propertyChangesManager = this.createPropertyChangesManager();
        ExportDataProvider exportDataProvider = this.createExportDataProvider();
        IDataFacade dataFacade = this.createDataFacade();
        AbstractDataMgr dataMgr = this.createDataMgr();
        AbstractPermissionMgr permissionMgr = this.createPermissionMgr();
        AbstractPermissionTemplateProvider permissionTemplateProvider = this.getPermissionTemplateProvider();
        ModuleLockManager lockMgr = this.createLockMgr();
        ILinkTypeHelper linkTypeHelper = this.createLinkTypeHelper();
        IUIDataTypesHelper uiDataTypesHelper = this.createUIDataTypesHelper();
        ModulePlatformAccess platformAccessAgent = this.createPlatformAccessAgent();
        if (exportDataProvider != null) {
            exportDataProvider.construct(this.clientDataFactory, (IModuleProjectAgent)project, dataMgr);
        }
        Object additionalAgents = this.createAdditionalProjectAgents(dataMgr, linkMgr, (IProjectAgent)project, lockMgr, permissionMgr, dataFacade);
        serverProxy.construct((IModuleProjectAgent)project);
        LinkedList<ILinkedDataAccessFacade> LOLinkedDataAccessFacades = new LinkedList<ILinkedDataAccessFacade>();
        LinkedList<ILinkedDataAccessFacade> MDLinkedDataAccessFacades = new LinkedList<ILinkedDataAccessFacade>();
        AbstractModuleFactory.getLinkedDataAccessFacades(LOLinkedDataAccessFacades, MDLinkedDataAccessFacades, linkTypeHelper, dataMgr);
        linkMgr.construct(project, project.getModuleLinkManager(), this.getModuleID(), dataMgr);
        dataMgr.construct(project.getProjectUID(), project, modelCtrl, permissionMgr, lockMgr, projectionMgr, linkMgr, propertyChangesManager, moduleFacade, this.clientDataFactory, this.eoFactory);
        Collection<IPlatformAdapterModule> platformAdapterModulesCollection = this.getPlatformAdapterModules(project, dataMgr, linkMgr);
        moduleFacade.construct(project, projectionMgr, permissionTemplateProvider, exportDataProvider, linkMgr, LOLinkedDataAccessFacades, MDLinkedDataAccessFacades, AbstractModuleFactory.getLinkTypes(linkTypeHelper), dataFacade, dataMgr, platformAdapterModulesCollection, serverProxy);
        propertyChangesManager.construct(project.getPropertyChangesProviderManager(), project.getPropertyChangesListenerManager());
        permissionMgr.construct(propertyChangesManager, permissionTemplateProvider, (IModuleProjectAgent)project, dataMgr);
        modelCtrl.construct(dataMgr, permissionMgr, lockMgr, projectionMgr, linkMgr, propertyChangesManager, dataFacade, project.getProjectUID(), (IModuleProjectAgent)project, this.clientDataFactory, linkTypeHelper, uiDataTypesHelper, platformAccessAgent);
        lockMgr.construct(project.getModuleLockManager(), modelCtrl, project.getProjectUID());
        if (projectionMgr != null) {
            projectionMgr.construct((IModuleProjectAgent)project, dataMgr, linkMgr);
        }
        if (dataFacade != null) {
            dataFacade.construct(dataMgr, modelCtrl, this.clientDataFactory);
        }
        platformAccessAgent.construct((IModuleProjectAgent)project);
        CrossModuleLinkManager.getInstance(project.getProjectUID()).registerDataTypesForModule(dataMgr.getDataTypes(), this.getModuleIDForPlatform(), dataMgr, (AbstractDataFacade)dataFacade, this.getLicenseTypeProvider());
        this.connectAdditionalProjectAgents(modelCtrl, additionalAgents);
        this.projectMgr.storeModelController(project.getProjectUID(), modelCtrl);
        return moduleFacade;
    }

    protected abstract Object createAdditionalProjectAgents(AbstractDataMgr var1, LinkMgr var2, IProjectAgent var3, ModuleLockManager var4, AbstractPermissionMgr var5, IDataFacade var6);

    protected abstract void connectAdditionalProjectAgents(IModelController var1, Object var2);

    protected ServerProxy createServerProxy() {
        return new ServerProxy();
    }

    protected ModuleFacade createModuleFacade() {
        return new ModuleFacade();
    }

    protected abstract ModelController createModelController();

    protected abstract ProjectionMgr createProjectionMgr();

    protected abstract IDataFacade createDataFacade();

    protected LinkMgr createLinkMgr() {
        return new LinkMgr();
    }

    protected PropertyChangesManager createPropertyChangesManager() {
        return new PropertyChangesManager();
    }

    protected abstract AbstractDataMgr createDataMgr();

    protected abstract AbstractPermissionMgr createPermissionMgr();

    protected abstract AbstractPermissionTemplateProvider getPermissionTemplateProvider();

    protected abstract ModuleLockManager createLockMgr();

    protected abstract ExportDataProvider createExportDataProvider();

    protected abstract ILinkTypeHelper createLinkTypeHelper();

    protected abstract IUIDataTypesHelper createUIDataTypesHelper();

    protected abstract ModulePlatformAccess createPlatformAccessAgent();

    private static final Collection<ILinkType> getLinkTypes(ILinkTypeHelper linkTypeHelper) {
        return linkTypeHelper.getAllLinkTypes();
    }

    private static final void getLinkedDataAccessFacades(Collection<ILinkedDataAccessFacade> LOLinkedDataAccessFacades, Collection<ILinkedDataAccessFacade> MDLinkedDataAccessFacades, ILinkTypeHelper linkTypeHelper, AbstractDataMgr dataManager) {
        linkTypeHelper.getAllLinkedDataAccessFacades(LOLinkedDataAccessFacades, MDLinkedDataAccessFacades, dataManager);
    }

    public abstract String getModuleIDForPlatform();

    protected abstract Collection<IPlatformAdapterModule> getPlatformAdapterModules(IFrameProjectAgent var1, AbstractDataMgr var2, LinkMgr var3);

    protected abstract ILicenseTypeProvider getLicenseTypeProvider();
}

