/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.issuemodule1migrator.core.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOAbstractModuleData_V0;
import com.arcway.cockpit.issuemodule1migrator.core.messages.IISMMessage;
import com.arcway.cockpit.issuemodule1migrator.core.messages.Messages;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;

public class EOIssue
extends EOAbstractModuleData_V0
implements IISMMessage {
    public static final String TYPE_ID = "com.arcway.ism.issue";
    public static final short PRIO_LOW = 10;
    public static final short PRIO_MED = 20;
    public static final short PRIO_HIGH = 30;
    public static final short[] PRIORITIES = new short[]{10, 20, 30};
    public static final short STATUS_OPEN = 10;
    public static final short STATUS_ASSIGNED = 20;
    public static final short STATUS_IN_PROGRESS = 30;
    public static final short STATUS_CLARIFIED = 40;
    public static final short STATUS_REOPENED = 50;
    public static final short STATUS_DEPRECATED = 60;
    public static final short[] STATES = new short[]{10, 20, 30, 40, 50, 60};
    public static final String XML_NAME = "ac1.ism.issue";
    public static final String XML_ATTR_TITLE = "title";
    public static final String XML_ATTR_TEXT = "text";
    public static final String XML_ATTR_INITIATOR_ID = "initiatorId";
    public static final String XML_ATTR_INITIATOR_NAME = "initiatorName";
    public static final String XML_ATTR_OWNER_ID = "ownerId";
    public static final String XML_ATTR_OWNER_NAME = "ownerName";
    public static final String XML_ATTR_STATUS = "status";
    public static final String XML_ATTR_DUE_DATE = "due";
    public static final String XML_ATTR_DATE_CREATION = "dateCreation";
    public static final String XML_ATTR_DATE_MODIFICATION = "dateModification";
    public static final String XML_ATTR_PRIORITY = "priority";
    private String title;
    private String text;
    private String initiatorId;
    private String initiatorName;
    private String ownerId;
    private String ownerName;
    private short status;
    private Timestamp dateCreation;
    private Timestamp dateModification;
    private Date dueDate;
    private short priority;

    public EOIssue() {
        super(XML_NAME);
    }

    public EOIssue(String title, String text, String initiatorId, String initiatorName, String ownerId, String ownerName, short status, Timestamp dateCreation, Timestamp dateModification, Date dueDate, short priority) {
        this();
        this.title = title;
        this.text = text;
        this.initiatorId = initiatorId;
        this.initiatorName = initiatorName;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.status = status;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.dueDate = dueDate;
        this.priority = priority;
    }

    public EOIssue(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        this.appendAttrToXML(writeContext, XML_ATTR_TITLE, this.title);
        this.appendAttrToXML(writeContext, XML_ATTR_TEXT, this.text);
        this.appendAttrToXML(writeContext, XML_ATTR_INITIATOR_ID, this.initiatorId);
        this.appendAttrToXML(writeContext, XML_ATTR_INITIATOR_NAME, this.initiatorName);
        this.appendAttrToXML(writeContext, XML_ATTR_OWNER_ID, this.ownerId);
        this.appendAttrToXML(writeContext, XML_ATTR_OWNER_NAME, this.ownerName);
        this.appendAttrToXML(writeContext, XML_ATTR_STATUS, this.status);
        this.appendAttrToXML(writeContext, XML_ATTR_DUE_DATE, this.dueDate);
        this.appendAttrToXML(writeContext, XML_ATTR_DATE_CREATION, this.dateCreation);
        this.appendAttrToXML(writeContext, XML_ATTR_DATE_MODIFICATION, this.dateModification);
        this.appendAttrToXML(writeContext, XML_ATTR_PRIORITY, this.priority);
    }

    protected boolean hasChildren() {
        return false;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(XML_ATTR_TITLE)) {
            this.title = value;
        } else if (name.equals(XML_ATTR_TEXT)) {
            this.text = value;
        } else if (name.equals(XML_ATTR_INITIATOR_ID)) {
            this.initiatorId = value;
        } else if (name.equals(XML_ATTR_INITIATOR_NAME)) {
            this.initiatorName = value;
        } else if (name.equals(XML_ATTR_OWNER_ID)) {
            this.ownerId = value;
        } else if (name.equals(XML_ATTR_OWNER_NAME)) {
            this.ownerName = value;
        } else if (name.equals(XML_ATTR_STATUS)) {
            this.status = this.toShort(value);
        } else if (name.equals(XML_ATTR_DUE_DATE)) {
            this.dueDate = this.toDate(value);
        } else if (name.equals(XML_ATTR_DATE_CREATION)) {
            this.dateCreation = this.toTimestamp(value);
        } else if (name.equals(XML_ATTR_DATE_MODIFICATION)) {
            this.dateModification = this.toTimestamp(value);
        } else if (name.equals(XML_ATTR_PRIORITY)) {
            this.priority = this.toShort(value);
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) {
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public Timestamp getDateCreation() {
        return this.dateCreation;
    }

    @Override
    public Timestamp getDateModification() {
        return this.dateModification;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public short getPriority() {
        return this.priority;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short status) {
        boolean allowed = false;
        int i = 0;
        while (i < STATES.length && !allowed) {
            if (STATES[i] == status) {
                allowed = true;
            }
            ++i;
        }
        assert (allowed);
        this.status = status;
    }

    @Override
    public void setDateCreation(Timestamp timestamp) {
        assert (timestamp != null);
        this.dateCreation = timestamp;
    }

    @Override
    public void setDateModification(Timestamp timestamp) {
        assert (timestamp != null);
        this.dateModification = timestamp;
    }

    public void setInitiatorId(String string) {
        this.initiatorId = string;
    }

    public void setInitiatorName(String string) {
        this.initiatorName = string;
    }

    public void setOwnerId(String string) {
        this.ownerId = string;
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public void setPriority(short priority) {
        boolean allowed = false;
        int i = 0;
        while (i < PRIORITIES.length && !allowed) {
            if (PRIORITIES[i] == priority) {
                allowed = true;
            }
            ++i;
        }
        assert (allowed);
        this.priority = priority;
    }

    @Override
    public void setText(String string) {
        assert (string != null);
        this.text = string;
    }

    public void setTitle(String string) {
        assert (string != null);
        this.title = string;
    }

    public void takeAttributes(EOIssue source) {
        this.initiatorId = source.initiatorId;
        this.initiatorName = source.initiatorName;
        this.dateCreation = source.dateCreation;
        this.dateModification = source.dateCreation;
        this.ownerId = source.ownerId;
        this.ownerName = source.ownerName;
        this.priority = source.priority;
        this.status = source.status;
        this.text = source.text;
        this.title = source.title;
        this.dueDate = source.dueDate;
    }

    public EOIssue getCopy() {
        EOIssue copy = new EOIssue();
        copy.takeAttributes(this);
        copy.setUid(this.getUID());
        copy.setProjectUID(this.getProjectUID());
        return copy;
    }

    public String getStatusString(Locale locale) {
        return EOIssue.getStatusString(this.status, locale);
    }

    public static String getStatusString(short status, Locale locale) {
        int i = 0;
        while (i < STATES.length) {
            if (status == STATES[i]) {
                return EOIssue.getSTATUS_NAMES(locale)[i];
            }
            ++i;
        }
        return null;
    }

    public String getPriorityString(Locale locale) {
        return EOIssue.getPriorityString(this.priority, locale);
    }

    public static String getPriorityString(short priority, Locale locale) {
        int i = 0;
        while (i < PRIORITIES.length) {
            if (priority == PRIORITIES[i]) {
                return EOIssue.getPRIORITY_NAMES(locale)[i];
            }
            ++i;
        }
        return null;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
    }

    public boolean isBehindSchedule(Date now) {
        return this.getDueDate() != null && this.getDueDate().before(now) && this.getStatus() != 40 && this.getStatus() != 60;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof EOIssue) {
            EOIssue arg = (EOIssue)arg0;
            boolean equals = this.getUID().equals(arg.getUID()) && this.getProjectUID().equals(arg.getProjectUID());
            return equals;
        }
        return false;
    }

    public int hashCode() {
        String key = String.valueOf(this.getUID()) + this.getProjectUID();
        return key.hashCode();
    }

    public String getTypeID() {
        return TYPE_ID;
    }

    public static final boolean haveEqualAttributes(EOIssue issue1, EOIssue issue2) {
        boolean equal = StringUtil.equals((String)issue1.getInitiatorId(), (String)issue2.getInitiatorId()) && StringUtil.equals((String)issue1.getInitiatorName(), (String)issue2.getInitiatorName()) && StringUtil.equals((String)issue1.getOwnerId(), (String)issue2.getOwnerId()) && StringUtil.equals((String)issue1.getOwnerName(), (String)issue2.getOwnerName()) && StringUtil.equals((String)issue1.getProjectUID(), (String)issue2.getProjectUID()) && StringUtil.equals((String)issue1.getText(), (String)issue2.getText()) && StringUtil.equals((String)issue1.getTitle(), (String)issue2.getTitle()) && issue1.getPriority() == issue2.getPriority() && issue1.getStatus() == issue2.getStatus();
        return equal;
    }

    public static String getPRIO_LOW_NAME(Locale locale) {
        return Messages.getString("EOIssue.PrioLow", locale);
    }

    public static String getPRIO_MED_NAME(Locale locale) {
        return Messages.getString("EOIssue.PrioMed", locale);
    }

    public static String getPRIO_HIGH_NAME(Locale locale) {
        return Messages.getString("EOIssue.PrioHigh", locale);
    }

    public static String[] getPRIORITY_NAMES(Locale locale) {
        return new String[]{EOIssue.getPRIO_LOW_NAME(locale), EOIssue.getPRIO_MED_NAME(locale), EOIssue.getPRIO_HIGH_NAME(locale)};
    }

    public static String getSTATUS_OPEN_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatOpen", locale);
    }

    public static String getSTATUS_ASSIGNED_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatAss", locale);
    }

    public static String getSTATUS_IN_PROGRESS_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatProgr", locale);
    }

    public static String getSTATUS_CLARIFIED_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatClos", locale);
    }

    public static String getSTATUS_REOPENED_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatReop", locale);
    }

    public static String getSTATUS_DEPRECATED_NAME(Locale locale) {
        return Messages.getString("EOIssue.StatDepr", locale);
    }

    public static String[] getSTATUS_NAMES(Locale locale) {
        return new String[]{EOIssue.getSTATUS_OPEN_NAME(locale), EOIssue.getSTATUS_ASSIGNED_NAME(locale), EOIssue.getSTATUS_IN_PROGRESS_NAME(locale), EOIssue.getSTATUS_CLARIFIED_NAME(locale), EOIssue.getSTATUS_REOPENED_NAME(locale), EOIssue.getSTATUS_DEPRECATED_NAME(locale)};
    }
}

