/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.menu.actions;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataEditionSelectionDialogue;
import com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataRevision;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.compare.ITypedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionShowHistory
extends Action {
    private static final String BUNDLE_NAME = "com.arcway.cockpit.modulelib2.client.gui.actions.ShowHistory";
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private IModuleData selectedItem;

    public ActionShowHistory(Shell activeShell, String moduleID, IModuleData selectedItem) {
        this.activeShell = activeShell;
        String projectUID = selectedItem.getProjectUID();
        this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(moduleID).getModelController(projectUID);
        this.selectedItem = selectedItem;
    }

    public void run() {
        if (this.selectedItem != null) {
            final List versions = this.modelCtrl.getVersionsOfItem(this.selectedItem);
            this.selectedItem = this.modelCtrl.getItem(this.selectedItem.getTypeID(), this.selectedItem.getUID());
            if (this.selectedItem == null) {
                MessageDialog.openWarning((Shell)this.activeShell, (String)Messages.getString((String)"ActionDelegateShowVersions.ItemDeletedTitle"), (String)Messages.getString((String)"ActionDelegateShowVersions.ItemDeletedText"));
                return;
            }
            this.modelCtrl.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    ResourceBundle bundle = ArcwayStandardResourceBundleLoader.getBundle((String)ActionShowHistory.BUNDLE_NAME, (Locale)Locale.getDefault(), ActionShowHistory.class);
                    ModuleDataEditionSelectionDialogue dialog = new ModuleDataEditionSelectionDialogue(ActionShowHistory.this.activeShell, bundle);
                    dialog.setCompareMode(true);
                    dialog.setHideIdenticalEntries(true);
                    dialog.selectEdition(ActionShowHistory.this.getRevisionObjectForCurrentItem(ActionShowHistory.this.selectedItem), ActionShowHistory.this.getRevisionObjectsForVersions(versions), (Object)"Root");
                }
            });
        }
    }

    private ITypedElement[] getRevisionObjectsForVersions(Collection<? extends IModuleData> itemVersions) {
        ArrayList<ModuleDataRevision> revisionObjects = new ArrayList<ModuleDataRevision>(itemVersions.size());
        for (IModuleData iModuleData : itemVersions) {
            revisionObjects.add(new ModuleDataRevision(iModuleData, this.modelCtrl));
        }
        return revisionObjects.toArray(new ITypedElement[itemVersions.size()]);
    }

    private ITypedElement getRevisionObjectForCurrentItem(IModuleData item) {
        return new ModuleDataRevision(item, this.modelCtrl);
    }
}

