/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.licensetypes;

import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.HierarchicalClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.AbstractClientFunctionLicenseTypeGM;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClientFunctionLicenseTypeGM
extends AbstractClientFunctionLicenseTypeGM {
    private static final String KEY_SUFFIX = "";
    private static Map<String, ClientFunctionLicenseTypeGM> instances = new HashMap<String, ClientFunctionLicenseTypeGM>();

    public ClientFunctionLicenseTypeGM(String moduleID) {
        super(moduleID);
    }

    public ClientFunctionLicenseTypeGM() {
    }

    @Override
    protected final String getKeySuffix() {
        return KEY_SUFFIX;
    }

    @Override
    protected Map<IClientProductLicenseType, Object> getProductLicenseSettings(Collection<String> licenseOptions) {
        HashMap<IClientProductLicenseType, Object> settings = new HashMap<IClientProductLicenseType, Object>();
        if (licenseOptions.contains("editable-in-reader")) {
            settings.put(ClientProductLicenseTypes.READER_LICENSE_CS, Boolean.TRUE);
            settings.put(ClientProductLicenseTypes.READER_LICENSE_SA, Boolean.TRUE);
        }
        if (licenseOptions.contains("usable-in-personal-architect")) {
            settings.put(ClientProductLicenseTypes.DESIGNER_LICENSE, Boolean.TRUE);
            if (licenseOptions.contains("editable-in-reader")) {
                settings.put(ClientProductLicenseTypes.DESIGNER_READER_LICENSE, Boolean.TRUE);
            }
        }
        return settings;
    }

    @Override
    protected Map<IClientModuleLicenseType, Object> getModuleLicenseSettings(Collection<String> licenseOptions) {
        return Collections.singletonMap(ClientProductLicenseTypes.getModuleLicenseTypeForModuleID((String)this.getModuleID()), Boolean.TRUE);
    }

    public static HierarchicalClientFunctionLicenseType getInstance(String moduleID) {
        ClientFunctionLicenseTypeGM instance = instances.get(moduleID);
        if (instance == null) {
            instance = new ClientFunctionLicenseTypeGM(moduleID);
            instances.put(moduleID, instance);
        }
        return instance;
    }
}

