/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExportDataProvider
extends com.arcway.cockpit.modulelib2.client.core.project.ExportDataProvider {
    private final Set<String> linkedAttributeObjectTypeIDs = new HashSet<String>();

    public ExportDataProvider(ModuleSpecification moduleSpecification) {
        for (ObjectType objectType : moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
            for (LinkedModuleDataAttribute attribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                this.linkedAttributeObjectTypeIDs.add(ClientDataFactory_TypesHelper.getDataTypeID(moduleSpecification.getModuleID(), attribute.getObjectTypeID()));
            }
        }
    }

    protected Collection<? extends IModuleData> checkItemsBeforeExport(Collection<? extends IModuleData> items, String dataTypeUID) {
        return items;
    }

    protected IModuleData checkItemBeforeImport(IModuleData item, Map<Object, Object> replacementMap, boolean generateNewUIDs) {
        String itemTypeID = item.getTypeID();
        if (this.linkedAttributeObjectTypeIDs.contains(itemTypeID)) {
            for (IModuleData oldItem : this.modelManager.getAllItems(itemTypeID)) {
                if (!oldItem.isIsomorphic(item)) continue;
                replacementMap.put(item, oldItem);
                return null;
            }
        }
        IModuleData effectiveItem = generateNewUIDs ? ExportDataProvider.copyItemAndReplaceUid((IModuleData)item, (boolean)true) : item;
        replacementMap.put(item, effectiveItem);
        return effectiveItem;
    }
}

