/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.GenericModuleDataLabelProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationLabelHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.description.NaturalOrderDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class DataManager
extends AbstractDataMgr {
    private String moduleID;
    private ModuleDataSpecification moduleDataSpecification;
    private GMLinkTypeHelper_Shared linkTypeHelper;
    private Set<String> dataTypeIds;
    private Set<String> dataTypesWithIDAttribute;
    private SetMap<String, String> map_naturalOrderTypeID_realTypeIDs;
    private Set<String> rootDataTypeIds;
    private SetMap<String, String> map_dataTypeID_parentDataTypeIDs;
    private Set<String> attributeLinkTypeIDs;
    private SetMap<String, String> map_attributeDataTypeID_linkTypeIDs;
    private IDataLabelProvider2<String> dataLabelProvider;

    public void setModuleDataSpecification(String moduleID, ModuleDataSpecification moduleDataSpecification) {
        this.moduleID = moduleID;
        this.moduleDataSpecification = moduleDataSpecification;
        this.linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        this.retrieveDataTypeLists();
    }

    private void retrieveDataTypeLists() {
        this.dataTypeIds = new HashSet<String>(this.moduleDataSpecification.getObjectTypeList().size());
        this.dataTypesWithIDAttribute = new HashSet<String>(this.moduleDataSpecification.getObjectTypeList().size());
        this.rootDataTypeIds = new HashSet<String>();
        this.map_dataTypeID_parentDataTypeIDs = new SetMap();
        this.map_attributeDataTypeID_linkTypeIDs = new SetMap();
        this.attributeLinkTypeIDs = new HashSet<String>();
        this.map_naturalOrderTypeID_realTypeIDs = new SetMap();
        for (ObjectType objectType : this.moduleDataSpecification.getObjectTypeList()) {
            String objectCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID());
            this.dataTypeIds.add(objectCockpitTypeID);
            if (!objectType.getAttributeListOfType(IDAttribute.class).isEmpty()) {
                this.dataTypesWithIDAttribute.add(objectCockpitTypeID);
            }
            if (objectType.getParentTypeList().size() != 1 || !objectType.getParentType(0).getParentObjectTypeID().equals("noparent")) {
                this.map_naturalOrderTypeID_realTypeIDs.add((Object)NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeDescriptionForFrame(this.moduleID, objectType.getTypeRank()).getCockpitDataTypeID(), (Object)objectCockpitTypeID);
            }
            for (ParentType parentType : objectType.getParentTypeList()) {
                if (parentType.getParentObjectTypeID().equals("hierarchyroot")) {
                    this.rootDataTypeIds.add(objectCockpitTypeID);
                    continue;
                }
                if (parentType.getParentObjectTypeID().equals("noparent")) continue;
                this.map_dataTypeID_parentDataTypeIDs.add((Object)objectCockpitTypeID, (Object)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, parentType.getParentObjectTypeID()));
            }
            for (LinkedModuleDataAttribute attribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                String linkTypeID = this.linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), attribute.getAttributeID());
                this.attributeLinkTypeIDs.add(linkTypeID);
                this.map_attributeDataTypeID_linkTypeIDs.add((Object)objectCockpitTypeID, (Object)linkTypeID);
            }
        }
    }

    public Collection<IModuleData> getChildren(IModuleData item) {
        if (item == null) {
            return this.getAllRootItems();
        }
        String itemTypeID = item.getTypeID();
        HashSet<IModuleData> children = new HashSet<IModuleData>();
        for (String childDataTypeID : this.map_dataTypeID_parentDataTypeIDs.keySet()) {
            if (!this.map_dataTypeID_parentDataTypeIDs.get((Object)childDataTypeID).contains(itemTypeID)) continue;
            children.addAll(this.getLinkMgr().getModuleData(item, this.linkTypeHelper.getHierarchyLinkTypeID(itemTypeID, childDataTypeID)));
        }
        return children;
    }

    public IModuleData getParent(IModuleData item) {
        String itemTypeID = item.getTypeID();
        for (String parentDataTypeID : this.map_dataTypeID_parentDataTypeIDs.get((Object)itemTypeID)) {
            Collection parentCollection;
            if (parentDataTypeID.equals("hierarchyroot") || parentDataTypeID.equals("noparent") || (parentCollection = this.getLinkMgr().getLinkableObjects(item.getUID(), this.linkTypeHelper.getHierarchyLinkTypeID(parentDataTypeID, itemTypeID))).isEmpty()) continue;
            return (IModuleData)parentCollection.iterator().next();
        }
        return null;
    }

    public IModuleData getItem(String dataTypeUID, String itemUID) {
        if (this.dataTypeIds.contains(dataTypeUID)) {
            return (IModuleData)super.getItem((Object)dataTypeUID, (Object)itemUID);
        }
        Set realTypes = this.map_naturalOrderTypeID_realTypeIDs.get((Object)dataTypeUID);
        for (String realType : realTypes) {
            IModuleData item = (IModuleData)super.getItem((Object)realType, (Object)itemUID);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Collection<IModuleData> getAllItems(String dataTypeUID) {
        if (this.dataTypeIds.contains(dataTypeUID)) {
            return super.getAllItems((Object)dataTypeUID);
        }
        LinkedList<IModuleData> allItems = new LinkedList<IModuleData>();
        Set realTypes = this.map_naturalOrderTypeID_realTypeIDs.get((Object)dataTypeUID);
        for (String realType : realTypes) {
            allItems.addAll(super.getAllItems((Object)realType));
        }
        return allItems;
    }

    public Collection<IModuleData> getChildren(IModuleData item, String typeID) {
        if (this.dataTypeIds.contains(typeID)) {
            return super.getChildren(item, typeID);
        }
        LinkedList<IModuleData> allChildren = new LinkedList<IModuleData>();
        Set realTypes = this.map_naturalOrderTypeID_realTypeIDs.get((Object)typeID);
        for (String realType : realTypes) {
            allChildren.addAll(super.getChildren(item, realType));
        }
        return allChildren;
    }

    public Collection<IModuleData> getAllRootItems() {
        HashSet<IModuleData> rootChildren = new HashSet<IModuleData>();
        for (String rootDataTypeID : this.rootDataTypeIds) {
            rootChildren.addAll(this.getRootItems(rootDataTypeID));
        }
        return rootChildren;
    }

    public Collection<IModuleData> getRootItems(String cockpitTypeID) {
        Collection<IModuleData> rootItemsOfType = this.getAllItems(cockpitTypeID);
        Set parentTypeIDs = this.map_dataTypeID_parentDataTypeIDs.get((Object)cockpitTypeID);
        Iterator<IModuleData> itemIterator = rootItemsOfType.iterator();
        block0: while (itemIterator.hasNext()) {
            IModuleData item = itemIterator.next();
            for (String parentCockpitTypeID : parentTypeIDs) {
                Collection parentCollection = this.getLinkMgr().getLinkableObjects(item.getUID(), this.linkTypeHelper.getHierarchyLinkTypeID(parentCockpitTypeID, cockpitTypeID));
                if (parentCollection.isEmpty()) continue;
                itemIterator.remove();
                continue block0;
            }
        }
        return rootItemsOfType;
    }

    public List<IModuleData> filterSelection(List<?> selection) {
        ArrayList<IModuleData> filteredSelection = new ArrayList<IModuleData>();
        for (Object selectedItem : selection) {
            GenericModuleData selectedModuleData;
            if (!(selectedItem instanceof GenericModuleData) || !this.dataTypeIds.contains((selectedModuleData = (GenericModuleData)((Object)selectedItem)).getTypeID())) continue;
            filteredSelection.add((IModuleData)selectedModuleData);
        }
        return filteredSelection;
    }

    public void callbackAsynchronousUpdateStarted() {
        super.callbackAsynchronousUpdateStarted();
        this.rememberLinksOfType(this.attributeLinkTypeIDs);
    }

    public void asynchronousUpdateHook_post_addedItems(String dataTypeId, Collection<IModuleData> addedItems) {
        if (this.map_attributeDataTypeID_linkTypeIDs.containsKey((Object)dataTypeId)) {
            Set relevantLinkTypeIDs = this.map_attributeDataTypeID_linkTypeIDs.get((Object)dataTypeId);
            this.mergeAttributeItemsOnAsynchronousUpdate(addedItems, dataTypeId, relevantLinkTypeIDs);
        }
    }

    public void asynchronousUpdateHook_post_modifiedItems(String dataTypeId, Collection<IModuleData> modifiedItems) {
    }

    public void asynchronousUpdateHook_pre_removedItems(String dataTypeId, Collection<IModuleData> removedItems) {
        if (this.map_attributeDataTypeID_linkTypeIDs.containsKey((Object)dataTypeId)) {
            Set relevantLinkTypeIDs = this.map_attributeDataTypeID_linkTypeIDs.get((Object)dataTypeId);
            this.restoreAttributeItemsOnAsynchronousUpdate(removedItems, relevantLinkTypeIDs);
        }
    }

    public IDataLabelProvider2<String> getDataLabelProvider2() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new GenericModuleDataLabelProvider(this.moduleID, this.moduleDataSpecification, this);
        }
        return this.dataLabelProvider;
    }

    public String getDisplayNameForData() {
        ModuleSpecification moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        return SpecificationLabelHelper.getLabel(moduleSpecification.getModuleDataName());
    }

    public Image getImageForData() {
        ModuleSpecification moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        return ResourceManager.getDefault().getImage(this.moduleID, moduleSpecification.getModuleIcon());
    }

    protected String getIDPrefix(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        if (parent != null) {
            for (String attributeID : parent.getTypeDescription().getChildrenIDFormatAttributeIDs()) {
                if (!parent.getTypeDescription().getChildCockpitTypeForIDFormatAttribute(attributeID).equals(dataTypeOfItemToBeCreated.getTypeID())) continue;
                ModuleDataAttributeBoolean overrideParent = (ModuleDataAttributeBoolean)parent.getAttribute(String.valueOf(attributeID) + "-overrideparentsettings");
                if (overrideParent.getValue()) {
                    ModuleDataAttributeBoolean useDefaultPrefix = (ModuleDataAttributeBoolean)parent.getAttribute(String.valueOf(attributeID) + "-usedefaultprefix");
                    if (useDefaultPrefix.getValue()) {
                        return dataTypeOfItemToBeCreated.getDefaultIDPrefix(this.getProjectLanguage());
                    }
                    ModuleDataAttributeString prefix = (ModuleDataAttributeString)parent.getAttribute(String.valueOf(attributeID) + "-prefix");
                    return prefix.getDisplayStringRepresentation();
                }
                return this.getIDPrefix(this.getParent(parent), dataTypeOfItemToBeCreated);
            }
            return this.getIDPrefix(this.getParent(parent), dataTypeOfItemToBeCreated);
        }
        return dataTypeOfItemToBeCreated.getDefaultIDPrefix(this.getProjectLanguage());
    }

    protected String getPrefixSeparator(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        return "_";
    }

    protected String getPattern(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        if (parent != null) {
            for (ChildrenIDFormatAttribute attribute : this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(parent.getTypeID())).getAttributeListOfType(ChildrenIDFormatAttribute.class)) {
                if (!ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, attribute.getChildObjectTypeID()).equals(dataTypeOfItemToBeCreated.getTypeID())) continue;
                ModuleDataAttributeBoolean overrideParent = (ModuleDataAttributeBoolean)parent.getAttribute(String.valueOf(attribute.getAttributeID()) + "-overrideparentsettings");
                if (overrideParent.getValue()) {
                    ModuleDataAttributeDiscrete pattern = (ModuleDataAttributeDiscrete)parent.getAttribute(String.valueOf(attribute.getAttributeID()) + "-pattern");
                    return pattern.getDisplayStringRepresentation();
                }
                return this.getPattern(this.getParent(parent), dataTypeOfItemToBeCreated);
            }
            return this.getPattern(this.getParent(parent), dataTypeOfItemToBeCreated);
        }
        return "000";
    }

    public IDataTypesHelper getDataTypesHelper() {
        return GMDataTypesHelper.getDefault(this.moduleID);
    }

    protected ILinkTypeHelper getLinkTypesHelper() {
        return GMLinkTypeHelper.getDefault(this.moduleID);
    }

    protected boolean isDataTypeWithID(String dataTypeID) {
        return this.dataTypesWithIDAttribute.contains(dataTypeID);
    }
}

