/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.cockpitadapter.locks;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.List;
import java.util.Map;

public class AbstractEOLinkLock
extends EOPlatformLock {
    private static final String XML_ATTRIBUTE_RELATIONTYPEID = "relationtypeid";
    private static final String XML_ATTRIBUTE_UID = "cockpitdatauid.";
    private IRepositoryRelationTypeID relationTypeID;
    private final IListRW_<IRepositoryRelationContributionRoleID> roleIDs = new ArrayList_();
    private final IListRW_<String> cockpitDataUIDs = new ArrayList_();

    public AbstractEOLinkLock(String xmlTag, String commitUID, IRepositoryRelationTypeID relationTypeID, IList_<IRepositoryRelationContributionRoleID> roleIDs, IList_<String> cockpitDataUIDs) {
        super(xmlTag, commitUID);
        Assert.checkArgumentBeeingNotNull((Object)relationTypeID);
        Assert.checkArgumentBeeingNotNull(roleIDs);
        Assert.checkArgumentBeeingNotNull(cockpitDataUIDs);
        this.relationTypeID = relationTypeID;
        this.roleIDs.addAll(roleIDs);
        this.cockpitDataUIDs.addAll(cockpitDataUIDs);
    }

    public AbstractEOLinkLock(String xmlTag, XMLContext xmlContext) {
        super(xmlTag, xmlContext);
    }

    AbstractEOLinkLock(String xmlTag, String commitUID, Map attributes) {
        super(xmlTag, commitUID, attributes);
    }

    public IRepositoryRelationTypeID getRelationTypeID() {
        return this.relationTypeID;
    }

    public IList_<IRepositoryRelationContributionRoleID> getRoleIDs() {
        return this.roleIDs;
    }

    public IList_<String> getCockpitDataUIDs() {
        return this.cockpitDataUIDs;
    }

    @Override
    protected boolean setAttributeFromXML(String name, final String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_RELATIONTYPEID)) {
            this.relationTypeID = new IRepositoryRelationTypeID(){

                public String toCanonicalString() {
                    return value;
                }
            };
            success = true;
        } else if (name.startsWith(XML_ATTRIBUTE_UID)) {
            String role = name.substring(XML_ATTRIBUTE_UID.length());
            String cockpitDataUID = value;
            int i = this.getRoleIndex(role);
            this.cockpitDataUIDs.add((Object)cockpitDataUID, i);
            success = true;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    private int getRoleIndex(final String role) {
        int roleIdx = -1;
        int i = 0;
        while (i < this.roleIDs.size()) {
            IRepositoryRelationContributionRoleID currentRoleID = (IRepositoryRelationContributionRoleID)this.roleIDs.get(i);
            String currentRole = currentRoleID.toCanonicalString();
            if (currentRole.equals(role)) {
                roleIdx = i;
            }
            ++i;
        }
        if (roleIdx == -1) {
            roleIdx = this.roleIDs.size();
            this.roleIDs.add((Object)new IRepositoryRelationContributionRoleID(){

                public String toCanonicalString() {
                    return role;
                }
            }, roleIdx);
        }
        return roleIdx;
    }

    @Override
    protected void appendAttributesToList(List attributes) {
        super.appendAttributesToList(attributes);
        attributes.add(new EOPlatformLock.KeyValue(XML_ATTRIBUTE_RELATIONTYPEID, this.relationTypeID.toCanonicalString()));
        int i = 0;
        while (i < this.roleIDs.size()) {
            String role = ((IRepositoryRelationContributionRoleID)this.roleIDs.get(i)).toCanonicalString();
            attributes.add(new EOPlatformLock.KeyValue(XML_ATTRIBUTE_UID + role, (String)this.cockpitDataUIDs.get(i)));
            ++i;
        }
    }
}

