/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;

public class EOLinkedItemDeletion
extends EOEncodableObject {
    private String linkedItemUID;
    private String linkedItemTypeID;
    private EOList<EOValue> LOLinkTypeIDs;
    private EOList<EOValue> MDLinkTypeIDs;
    private String projectUID;
    public static final String XML_NAME = "frame.loDeletion";
    public static final String ATTR_TAG_LINKEDITEM_UID = "linkedItemUID";
    public static final String ATTR_TAG_LINKEDITEM_TYPE_ID = "linkedItemTypeID";
    public static final String ATTR_TAG_LO_LINK_TYPES = "LOLinkTypes";
    public static final String ATTR_TAG_MD_LINK_TYPES = "MDLinkTypes";
    public static final String ATTR_TAG_PROJECT_UID = "projectUID";
    public static final String ROLE_LO_LINKTYPES = "LOLinkTypes";
    public static final String ROLE_MD_LINKTYPES = "MDLinkTypes";

    public EOLinkedItemDeletion(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.LOLinkTypeIDs = new EOList("LOLinkTypes");
        this.MDLinkTypeIDs = new EOList("MDLinkTypes");
    }

    public EOLinkedItemDeletion(String xmlName) {
        super(xmlName);
        this.LOLinkTypeIDs = new EOList("LOLinkTypes");
        this.MDLinkTypeIDs = new EOList("MDLinkTypes");
    }

    public EOLinkedItemDeletion(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
        this.LOLinkTypeIDs = new EOList("LOLinkTypes");
        this.MDLinkTypeIDs = new EOList("MDLinkTypes");
    }

    public EOLinkedItemDeletion() {
        super(XML_NAME);
        this.LOLinkTypeIDs = new EOList("LOLinkTypes");
        this.MDLinkTypeIDs = new EOList("MDLinkTypes");
    }

    public EOLinkedItemDeletion(String projectUID, String linkableObjectUID, String linkItemTypeID, Collection<String> LOLinkTypeIDs, Collection<String> MDLinkTypeIDs) {
        super(XML_NAME);
        assert (projectUID != null) : "projectUID must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (LOLinkTypeIDs != null) : "linkTypeIDs must not be null";
        assert (MDLinkTypeIDs != null) : "linkTypeIDs must not be null";
        this.projectUID = projectUID;
        this.linkedItemUID = linkableObjectUID;
        this.linkedItemTypeID = linkItemTypeID;
        this.LOLinkTypeIDs = new EOList("LOLinkTypes");
        this.addLOLinkTypeIDs(LOLinkTypeIDs);
        this.MDLinkTypeIDs = new EOList("MDLinkTypes");
        this.addMDLinkTypeIDs(MDLinkTypeIDs);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LINKEDITEM_UID, this.linkedItemUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LINKEDITEM_TYPE_ID, this.linkedItemTypeID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (ATTR_TAG_LINKEDITEM_UID.equals(name)) {
            this.linkedItemUID = value;
        } else if (ATTR_TAG_LINKEDITEM_TYPE_ID.equals(name)) {
            this.linkedItemTypeID = value;
        } else if (ATTR_TAG_PROJECT_UID.equals(name)) {
            this.projectUID = value;
        } else {
            return false;
        }
        return true;
    }

    protected boolean hasChildren() {
        return !this.LOLinkTypeIDs.isEmpty() && !this.MDLinkTypeIDs.isEmpty();
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.LOLinkTypeIDs.writeXMLBody(writeContext, depth);
        this.MDLinkTypeIDs.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            if ("LOLinkTypes".equals(list.getRole())) {
                this.LOLinkTypeIDs = list;
                return true;
            }
            if ("MDLinkTypes".equals(list.getRole())) {
                this.MDLinkTypeIDs = list;
                return true;
            }
        }
        return false;
    }

    public String getLinkedItemUID() {
        return this.linkedItemUID;
    }

    public String getLinkedItemTypeID() {
        return this.linkedItemTypeID;
    }

    public Collection<String> getLOLinkTypeIDs() {
        ArrayList<String> toReturn = new ArrayList<String>(this.LOLinkTypeIDs.size());
        for (EOValue eoValue : this.LOLinkTypeIDs) {
            toReturn.add(eoValue.getValue());
        }
        return toReturn;
    }

    public Collection<String> getMDLinkTypeIDs() {
        ArrayList<String> toReturn = new ArrayList<String>(this.MDLinkTypeIDs.size());
        for (EOValue eoValue : this.MDLinkTypeIDs) {
            toReturn.add(eoValue.getValue());
        }
        return toReturn;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void addLOLinkTypeIDs(Collection<String> linkTypeIDs) {
        assert (linkTypeIDs != null) : "linkTypeIDs must not be null";
        for (String linkTypeID : linkTypeIDs) {
            this.LOLinkTypeIDs.add((EncodableObjectBase)new EOValue(linkTypeID));
        }
    }

    public void addMDLinkTypeIDs(Collection<String> linkTypeIDs) {
        assert (linkTypeIDs != null) : "linkTypeIDs must not be null";
        for (String linkTypeID : linkTypeIDs) {
            this.MDLinkTypeIDs.add((EncodableObjectBase)new EOValue(linkTypeID));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EOLinkedItemDeletion)) {
            return false;
        }
        EOLinkedItemDeletion deletion = (EOLinkedItemDeletion)((Object)obj);
        return this == deletion || this.linkedItemUID.equals(deletion.getLinkedItemUID()) && this.projectUID.equals(deletion.getProjectUID());
    }

    public int hashCode() {
        return this.linkedItemUID.hashCode();
    }
}

