/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.stakeholder;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleConnectionAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.cockpit.frame.declaration.common.icons16x16.CommonIcons16x16;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.IRelation;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.clientadapter.interFace.IRelationContributionType;
import com.arcway.repository.clientadapter.interFace.IRelationContributionWithRelatedObject;
import com.arcway.repository.clientadapter.interFace.Label;
import com.arcway.repository.clientadapter.lib.Relation;
import com.arcway.repository.clientadapter.lib.RelationContribution;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.COTIDsStakeholder;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.COTIDsStakeholderRole;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.CRTIDsStakeholderStakeholderRole;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.BaseRepositoryRelationTypeID;
import com.arcway.repository.lib.high.declaration.type.relationcontribution.RepositoryRelationContributionRoleID;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class LinkManagerAdpaterStakeholderStakeholderRole
implements ILinkManagerAdapter {
    private static final ILogger logger = Logger.getLogger(LinkManagerAdpaterStakeholderStakeholderRole.class);
    private final IFrameProjectAgent projectAgent;
    private final IRepositoryRelationTypeID repositoryRelationTypeID;
    private final IRepositoryRelationTypeID repositorySuperRelationTypeID;
    private final ILabel[] labels;
    private final IRelationContributionType[] relationContributionTypes = new IRelationContributionType[]{new IRelationContributionType(){

        @Override
        public CardinalityType getCardinality() {
            return CardinalityType.C0_n_NOT_CONFLICTING;
        }

        @Override
        public ILabel[] getLabels() {
            return Label.createLabels(Messages.class, "Stakeholder.RelationContribution.Stakeholder", CommonIcons16x16.STAKEHOLDER);
        }

        @Override
        public IRepositoryObjectTypeID getRelatedObjectTypeID() {
            return COTIDsStakeholder.OBJECT_TYPE_ID;
        }

        @Override
        public IRepositoryRelationContributionRoleID getRepositoryRelationContributionRoleID() {
            return CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_STAKEHOLDER;
        }
    }, new IRelationContributionType(){

        @Override
        public CardinalityType getCardinality() {
            return CardinalityType.C0_n_NOT_CONFLICTING;
        }

        @Override
        public ILabel[] getLabels() {
            return Label.createLabels(Messages.class, "Stakeholder.RelationContribution.StakeholderRole", CommonIcons16x16.STAKEHOLDER_ROLE);
        }

        @Override
        public IRepositoryObjectTypeID getRelatedObjectTypeID() {
            return COTIDsStakeholderRole.OBJECT_TYPE_ID;
        }

        @Override
        public IRepositoryRelationContributionRoleID getRepositoryRelationContributionRoleID() {
            return CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_ROLE;
        }
    }};

    public LinkManagerAdpaterStakeholderStakeholderRole(IFrameProjectAgent projectAgent) {
        this.repositoryRelationTypeID = CRTIDsStakeholderStakeholderRole.RELATION_TYPE_ID;
        this.repositorySuperRelationTypeID = BaseRepositoryRelationTypeID.RELATION_TYPE_ID;
        this.labels = new ILabel[0];
        this.projectAgent = projectAgent;
    }

    @Override
    public IRepositoryRelationTypeID getRepositoryRelationTypeID() {
        return this.repositoryRelationTypeID;
    }

    @Override
    public IRepositoryRelationTypeID getRepositorySuperRelationTypeID() {
        return this.repositorySuperRelationTypeID;
    }

    @Override
    public IRelationContributionType[] getRelationContributionTypes() {
        return this.relationContributionTypes;
    }

    @Override
    public ILabel[] getLabels() {
        return this.labels;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IRelation[] getRelations(IRelationContributionWithRelatedObject[] givenRelationContributions) {
        IRelation[] relations;
        StakeholderManager stakeholderManager = (StakeholderManager)this.projectAgent.getFrameStakeholderManager();
        RepositoryRelationContributionRoleID stakeholderRoleID = CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_ROLE;
        RepositoryRelationContributionRoleID stakeholderID = CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_STAKEHOLDER;
        int numberOfRC = givenRelationContributions.length;
        switch (numberOfRC) {
            case 0: {
                int index = 0;
                Collection<EORoleAndStakeholder> allRelations = stakeholderManager.getAllConnections();
                relations = new IRelation[allRelations.size()];
                for (IRoleAndStakeholder iRoleAndStakeholder : allRelations) {
                    RelationContribution stakeholderRC = new RelationContribution((IRepositoryRelationContributionRoleID)stakeholderID, iRoleAndStakeholder.getStakeholderUID());
                    RelationContribution relationContribution = new RelationContribution((IRepositoryRelationContributionRoleID)stakeholderRoleID, iRoleAndStakeholder.getRoleUID());
                    relations[index] = new Relation(new IRelationContributionWithRelatedObject[0], new IRelationContribution[]{stakeholderRC, relationContribution});
                    ++index;
                }
                break;
            }
            case 1: {
                Collection<Object> relatedItems = new ArrayList();
                RepositoryRelationContributionRoleID targetRepositoryRoleID = null;
                IRelationContributionWithRelatedObject relContribution = givenRelationContributions[0];
                if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relContribution.getRepositoryRelationContributionRoleID(), (Object)stakeholderID)) {
                    IStakeholder iStakeholder = stakeholderManager.getStakeholderByUID(relContribution.getCockpitDataUID());
                    relatedItems = stakeholderManager.getRolesOfStakeholder(iStakeholder);
                    targetRepositoryRoleID = stakeholderRoleID;
                } else if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relContribution.getRepositoryRelationContributionRoleID(), (Object)stakeholderRoleID)) {
                    IStakeholderRole iStakeholderRole = stakeholderManager.getRoleByUID(relContribution.getCockpitDataUID());
                    relatedItems = stakeholderManager.getStakeholdersOfRole(iStakeholderRole);
                    targetRepositoryRoleID = stakeholderID;
                }
                assert (targetRepositoryRoleID != null);
                relations = new IRelation[relatedItems.size()];
                boolean bl = false;
                for (ICockpitProjectData iCockpitProjectData : relatedItems) {
                    void var10_22;
                    relations[var10_22] = new Relation(new IRelationContributionWithRelatedObject[]{relContribution}, new IRelationContribution[]{new RelationContribution((IRepositoryRelationContributionRoleID)targetRepositoryRoleID, iCockpitProjectData.getUID())});
                    ++var10_22;
                }
                break;
            }
            case 2: {
                IRelationContribution stakeholderRC = null;
                IRelationContributionWithRelatedObject stakeholderRoleRC = null;
                int i = 0;
                while (i < numberOfRC) {
                    if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)givenRelationContributions[i].getRepositoryRelationContributionRoleID(), (Object)CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_STAKEHOLDER)) {
                        stakeholderRC = givenRelationContributions[i];
                    } else {
                        stakeholderRoleRC = givenRelationContributions[i];
                    }
                    ++i;
                }
                assert (stakeholderRC != null);
                assert (stakeholderRoleRC != null);
                IStakeholder stakeholder = stakeholderManager.getStakeholderByUID(stakeholderRC.getCockpitDataUID());
                Collection<IStakeholderRole> collection = stakeholderManager.getRolesOfStakeholder(stakeholder);
                IStakeholderRole stakeholderRole = stakeholderManager.getRoleByUID(stakeholderRoleRC.getCockpitDataUID());
                relations = new IRelation[]{};
                if (!collection.contains(stakeholderRole)) break;
                relations = new IRelation[]{new Relation(new IRelationContributionWithRelatedObject[]{stakeholderRC, stakeholderRoleRC}, new IRelationContribution[0])};
                break;
            }
            default: {
                throw new IllegalArgumentException("This relation can only have two relation contributions.");
            }
        }
        return relations;
    }

    @Override
    public void createLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        StakeholderManager stakeholderManager = (StakeholderManager)this.projectAgent.getFrameStakeholderManager();
        HashMap cockpitData_map = this.getCockpitDataForRelationContributions(relationContributions);
        IStakeholderRole stakeholderRole = (IStakeholderRole)cockpitData_map.get(COTIDsStakeholderRole.OBJECT_TYPE_ID);
        IStakeholder stakeholder = (IStakeholder)cockpitData_map.get(COTIDsStakeholder.OBJECT_TYPE_ID);
        IStakeholderRoleConnectionAddID addID = stakeholderManager.requestStakeholderRoleConnectionAddPermission(stakeholder, stakeholderRole);
        try {
            stakeholderManager.addStakeholderRoleConnection(addID);
        }
        catch (EXNoPermission e) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("StakeholerStakeholderRoleConnection.NoPermissionToChange")});
        }
    }

    @Override
    public void deleteLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        StakeholderManager stakeholderManager = (StakeholderManager)this.projectAgent.getFrameStakeholderManager();
        HashMap cockpitData_map = this.getCockpitDataForRelationContributions(relationContributions);
        IStakeholderRole stakeholderRole = (IStakeholderRole)cockpitData_map.get(COTIDsStakeholderRole.OBJECT_TYPE_ID);
        IStakeholder stakeholder = (IStakeholder)cockpitData_map.get(COTIDsStakeholder.OBJECT_TYPE_ID);
        if (stakeholder != null && stakeholderRole != null) {
            try {
                LockRequest lockRequest = new LockRequest(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
                LockResult lockResult = this.projectAgent.getFrameLockManager().setLock(lockRequest, true);
                if (!lockResult.wasSuccessful()) {
                    Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
                    throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
                }
                stakeholderManager.deleteStakeholderRoleConnection(stakeholder, stakeholderRole);
            }
            catch (ServerNotAvailableException e) {
                logger.error("Cannot get lock for create stakeholder-role lock (ServerNotAvailableException).", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("Cannot get lock for create stakeholder-role lock (UnknownServerException).", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("Cannot get lock for create stakeholder-role lock (LoginCanceledException).", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("Cannot get lock for create stakeholder-role lock (EXServerException).", (Throwable)e);
            }
            catch (EXNoLock e) {
                logger.error("Not able to set needed locks", (Throwable)e);
            }
            catch (EXNoPermission e) {
                throw new EXCockpitPermissionDenied(new String[]{Messages.getString("StakeholerStakeholderRoleConnection.NoPermissionToChange")});
            }
        } else {
            logger.error("stakeholder - stakeholderRole relation could not be deleted");
        }
    }

    private HashMap getCockpitDataForRelationContributions(IRelationContribution[] relationContributions) {
        StakeholderManager stakeholderManager = (StakeholderManager)this.projectAgent.getFrameStakeholderManager();
        IStakeholderRole stakeholderRole = null;
        IStakeholder stakeholder = null;
        HashMap<RepositoryObjectTypeID, Object> cockpitData_map = new HashMap<RepositoryObjectTypeID, Object>();
        IRelationContribution[] iRelationContributionArray = relationContributions;
        int n = relationContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IRelationContribution element = iRelationContributionArray[n2];
            if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)element.getRepositoryRelationContributionRoleID(), (Object)CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_ROLE)) {
                stakeholderRole = stakeholderManager.getRoleByUID(element.getCockpitDataUID());
                cockpitData_map.put(COTIDsStakeholderRole.OBJECT_TYPE_ID, stakeholderRole);
            } else if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)element.getRepositoryRelationContributionRoleID(), (Object)CRTIDsStakeholderStakeholderRole.RELATION_CONTRIBUTION_ROLE_ID_STAKEHOLDER)) {
                stakeholder = stakeholderManager.getStakeholderByUID(element.getCockpitDataUID());
                cockpitData_map.put(COTIDsStakeholder.OBJECT_TYPE_ID, stakeholder);
            } else {
                throw new RuntimeException("unsupported relation - more than two relation contributions (stakeholder - stakeholderRole)");
            }
            ++n2;
        }
        return cockpitData_map;
    }

    @Override
    public boolean isCreatableAndDeletableGenerically() {
        return true;
    }

    @Override
    public void checkPermissionForCreateOrDeleteLink(IRelationContributionForPermissionCheck[] relationContributions) throws EXCockpitPermissionDenied {
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            String[] userHints = new String[]{Messages.getString("StakeholerStakeholderRoleConnection.NoPermissionToChange")};
            throw new EXCockpitPermissionDenied(userHints);
        }
    }

    @Override
    public ILock getLockForCreateOrDeleteLink(IRelationContribution[] relationContributions) throws EXCockpitLockDenied {
        LockResult lockResult;
        try {
            LockRequest lockRequest = new LockRequest(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            lockResult = this.projectAgent.getFrameLockManager().setLock(lockRequest, true);
        }
        catch (ServerNotAvailableException e) {
            logger.error("Cannot get lock for create delete stakeholder-role lock (ServerNotAvailableException).", (Throwable)e);
            throw new RuntimeException();
        }
        catch (UnknownServerException e) {
            logger.error("Cannot get lock for create delete stakeholder-role lock (UnknownServerException).", (Throwable)e);
            throw new RuntimeException();
        }
        catch (LoginCanceledException e) {
            logger.error("Cannot get lock for create delete stakeholder-role lock (LoginCanceledException).", (Throwable)e);
            throw new RuntimeException();
        }
        catch (EXServerException e) {
            logger.error("Cannot get lock for create delete stakeholder-role lock (EXServerException).", (Throwable)e);
            throw new RuntimeException();
        }
        return this.getILock(lockResult);
    }

    private ILock getILock(final LockResult lockResult) throws EXCockpitLockDenied {
        if (!lockResult.wasSuccessful()) {
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        ILock iLock = new ILock(){

            @Override
            public void release() {
                Collection<EOLock> allLocks = lockResult.getAllRequestedLocks();
                LinkManagerAdpaterStakeholderStakeholderRole.this.projectAgent.getFrameLockManager().releaseLocks(allLocks);
            }
        };
        return iLock;
    }
}

