/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.implementation.adapter.CustomPropertyTypeID;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCockpitObjectIterator;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCockpitRelationContributionIterator;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCrossLinkRelation;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterProperty;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterRelationContribution;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.interFace.IRelation;
import com.arcway.repository.clientadapter.interFace.IRelationContributionWithRelatedObject;
import com.arcway.repository.clientadapter.lib.RelationContributionWithRelatedObject;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.implementation.lock.RepositoryAttributeSetLockSample;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PlatformAdapterAttributeSet
extends PlatformAdapterItem
implements IRepositoryAttributeSet {
    private final PlatformAdapterObject object;
    private final IRepositoryAttributeSetType attributeSetType;
    private final Map<IRepositoryPropertyType, PlatformAdapterProperty> allProperties;

    public PlatformAdapterAttributeSet(PlatformAdapterObject object, IRepositoryAttributeSetType attributeSetType) {
        super(object.getSnapshotImplementation());
        Assert.checkArgumentBeeingNotNull((Object)object);
        Assert.checkArgumentBeeingNotNull((Object)attributeSetType);
        this.object = object;
        this.attributeSetType = attributeSetType;
        ICollection_ propertyTypes = attributeSetType.getPropertyTypes();
        this.allProperties = new HashMap<IRepositoryPropertyType, PlatformAdapterProperty>(propertyTypes.size());
        for (IRepositoryPropertyType currentPropertyType : propertyTypes) {
            PlatformAdapterProperty property = new PlatformAdapterProperty(this, currentPropertyType);
            this.allProperties.put(currentPropertyType, property);
        }
    }

    public IRepositoryDeclarationItem getType() {
        return this.getAttributeSetType();
    }

    public IRepositoryAttributeSetType getAttributeSetType() {
        return this.attributeSetType;
    }

    PlatformAdapterObject getObjectImplementation() {
        return this.object;
    }

    ICockpitProjectData getCockpitData() {
        return this.getObjectImplementation().getCockpitData();
    }

    public IRepositoryObject getObject() throws EXNotReproducibleSnapshot {
        return this.getObjectImplementation();
    }

    public IRepositoryIterator_IRepositoryObject childObjectIterator(IRepositoryObjectType childObjectType) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        Collection<PlatformAdapterObject> childObjects = this.getChildObjects(childObjectType);
        return new PlatformAdapterCockpitObjectIterator(childObjects);
    }

    private Collection<PlatformAdapterObject> getChildObjects(IRepositoryObjectType childObjectType) {
        PlatformAdapterSnapshot snapshot = this.getSnapshotImplementation();
        ICollection_ childRepositoryConcreteObjectTypes = childObjectType.getAllInstanciableObjectTypesOfThisType();
        PlatformAdapterObject parentRepositoryObject = this.getObjectImplementation();
        ArrayList<PlatformAdapterObject> childObjects = new ArrayList<PlatformAdapterObject>();
        for (IRepositoryObjectType childRepositoryConcreteObjectType : childRepositoryConcreteObjectTypes) {
            ICockpitProjectData[] childCockpitDatas;
            IDataManagerAdapter childDataManagerAdapter = snapshot.getDataManagerAdapter(childRepositoryConcreteObjectType);
            ICockpitProjectData[] iCockpitProjectDataArray = childCockpitDatas = childDataManagerAdapter.getChildren(parentRepositoryObject.getCockpitData());
            int n = childCockpitDatas.length;
            int n2 = 0;
            while (n2 < n) {
                ICockpitProjectData childCockpitData = iCockpitProjectDataArray[n2];
                PlatformAdapterObject childRepositoryObject = snapshot.fetchObject(childCockpitData);
                childObjects.add(childRepositoryObject);
                ++n2;
            }
        }
        return childObjects;
    }

    private PlatformAdapterProperty getPropertyImplementation(IRepositoryPropertyType repositoryPropertyType) {
        PlatformAdapterProperty property = this.allProperties.get(repositoryPropertyType);
        Assert.checkArgumentBeeingNotNull((Object)property);
        return property;
    }

    public IRepositoryProperty getProperty(IRepositoryPropertyType repositoryPropertyType) throws EXNotReproducibleSnapshot {
        return this.getPropertyImplementation(repositoryPropertyType);
    }

    public IRepositoryIterator_ICrossLinkRepositoryRelationContribution relationContributionIterator(ICrossLinkRepositoryRelationContributionType wishedRelationContributionType) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        IRepositoryRelationContributionRoleID wishedRoleID = wishedRelationContributionType.getRepositoryRelationContributionRoleID();
        PlatformAdapterSnapshot snapshot = this.getSnapshotImplementation();
        ICrossLinkRepositoryRelationType superRelationType = wishedRelationContributionType.getRelatedRelationType();
        ICollection_ concreteRelationTypes = superRelationType.getAllInstanciableRelationTypesOfThisType();
        ArrayList<PlatformAdapterRelationContribution> relationContributionsToReturn = new ArrayList<PlatformAdapterRelationContribution>();
        for (ICrossLinkRepositoryRelationType concreteRelationType : concreteRelationTypes) {
            IRelation[] cockpitRelations;
            ILinkManagerAdapter linkManagerAdapter = snapshot.getLinkManagerAdapter(concreteRelationType);
            IRelationContributionWithRelatedObject[] givenRelationContributions = new IRelationContributionWithRelatedObject[]{new RelationContributionWithRelatedObject(wishedRoleID, this.getObjectImplementation())};
            IRelation[] iRelationArray = cockpitRelations = linkManagerAdapter.getRelations(givenRelationContributions);
            int n = cockpitRelations.length;
            int n2 = 0;
            while (n2 < n) {
                IRelation cockpitRelation = iRelationArray[n2];
                PlatformAdapterCrossLinkRelation adapterRelation = snapshot.fetchRelation(concreteRelationType, cockpitRelation);
                relationContributionsToReturn.add(adapterRelation.getRelationContributionImplementation(concreteRelationType.getRelationContributionType(wishedRoleID)));
                ++n2;
            }
        }
        PlatformAdapterCockpitRelationContributionIterator relationContributionIterator = new PlatformAdapterCockpitRelationContributionIterator(relationContributionsToReturn);
        return relationContributionIterator;
    }

    public IRepositoryPropertySetSample sample() throws EXNotReproducibleSnapshot {
        return new RepositoryPropertySetSample((IRepositoryAttributeSet)this);
    }

    public void modify(IRepositoryPropertySetSample newAttributeSetValue) throws EXPermissionDenied, EXLockDenied, EXNotReproducibleSnapshot {
        if (!IRepositoryAttributeSetTypeID.IS_EQUAL_ATTRIBUTE_SET_TYPE_ID_HASHER.isEqual((Object)this.attributeSetType.getRepositoryAttributeSetTypeID(), (Object)COTIDsCockpitData.ATTRIBUTE_SET_TYPE_ID_PROPERTIES)) {
            throw new EXPermissionDenied(new String[]{Messages.getString("AttributeSet.NoPermission")});
        }
        IRepositoryObjectType objectType = this.getObjectImplementation().getObjectType();
        IDataManagerAdapter dataManagerAdapter = this.getObjectImplementation().getDataManagerAdapter();
        IRepositoryPropertySetSample oldAttributeSetValue = this.sample();
        IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamplesOldData = PlatformAdapterAttributeSet.createAllPropertiesMap(oldAttributeSetValue);
        IProperty[] standardPropertiesOldData = PlatformAdapterAttributeSet.extractStandardProperties(this.getWorkstationImplementation(), objectType, oldAttributeSetValue, remainingPropertySamplesOldData);
        IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamplesNewData = PlatformAdapterAttributeSet.createAllPropertiesMap(newAttributeSetValue);
        IProperty[] standardPropertiesNewData = PlatformAdapterAttributeSet.extractStandardProperties(this.getWorkstationImplementation(), objectType, newAttributeSetValue, remainingPropertySamplesNewData);
        ArrayList<IProperty> standardPropertiesToModifyBackup = new ArrayList<IProperty>();
        Collection<IProperty> standardPropertiesToModify = this.getStandardPropertiesToModify(standardPropertiesNewData, standardPropertiesOldData, standardPropertiesToModifyBackup);
        ICockpitProjectData cockpitData = this.getCockpitData();
        try {
            dataManagerAdapter.modifyCockpitData(cockpitData, standardPropertiesToModify.toArray(new IProperty[standardPropertiesToModify.size()]));
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
        IMapRW_<IRepositoryPropertyTypeID, Object> customPropertiesToModify = this.getCustomPropertiesToModify(remainingPropertySamplesNewData, remainingPropertySamplesOldData);
        try {
            this.modifyCustomProperties(customPropertiesToModify);
        }
        catch (EXCockpitLockDenied e) {
            try {
                dataManagerAdapter.modifyCockpitData(cockpitData, standardPropertiesToModifyBackup.toArray(new IProperty[standardPropertiesToModifyBackup.size()]));
            }
            catch (EXCockpitLockDenied e1) {
                throw new RuntimeException(e1);
            }
            catch (EXCockpitPermissionDenied e1) {
                throw new RuntimeException(e1);
            }
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            try {
                dataManagerAdapter.modifyCockpitData(cockpitData, standardPropertiesToModifyBackup.toArray(new IProperty[standardPropertiesToModifyBackup.size()]));
            }
            catch (EXCockpitLockDenied e1) {
                throw new RuntimeException(e1);
            }
            catch (EXCockpitPermissionDenied e1) {
                throw new RuntimeException(e1);
            }
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
        Assert.checkArgument((boolean)remainingPropertySamplesNewData.isEmpty());
    }

    private Collection<IProperty> getStandardPropertiesToModify(IProperty[] standardPropertiesNewData, IProperty[] standardPropertiesOldData, Collection<IProperty> standardPropertiesToModifyBackup) {
        ArrayList<IProperty> standardPropertiesToModify = new ArrayList<IProperty>();
        IProperty[] iPropertyArray = standardPropertiesNewData;
        int n = standardPropertiesNewData.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty newProperty = iPropertyArray[n2];
            IRepositoryPropertyTypeID newPropertyType = newProperty.getPropertyTypeID();
            IProperty[] iPropertyArray2 = standardPropertiesOldData;
            int n3 = standardPropertiesOldData.length;
            int n4 = 0;
            while (n4 < n3) {
                IProperty oldProperty = iPropertyArray2[n4];
                IRepositoryPropertyTypeID oldPropertyType = oldProperty.getPropertyTypeID();
                if (IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)newPropertyType, (Object)oldPropertyType)) {
                    IRepositoryDataType dataTypeOfPropertyToCheck = newProperty.getValue().getDataType();
                    IRepositoryDataEqualComparator dataEqualComparator = dataTypeOfPropertyToCheck.getEqualComparator();
                    if (dataEqualComparator != null) {
                        if (!dataEqualComparator.isEqual(newProperty.getValue(), oldProperty.getValue())) {
                            standardPropertiesToModify.add(newProperty);
                            standardPropertiesToModifyBackup.add(oldProperty);
                        }
                    } else {
                        standardPropertiesToModify.add(newProperty);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return standardPropertiesToModify;
    }

    private IMapRW_<IRepositoryPropertyTypeID, Object> getCustomPropertiesToModify(IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamplesNewData, IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamplesOldData) {
        HashMap_ customPropertiesToModify = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        IIteratorRW_ iteratorRemainingPropSamplesNewData = remainingPropertySamplesNewData.iterator();
        while (iteratorRemainingPropSamplesNewData.hasNext()) {
            IEntry_ propertyTypeID2ObjectNew = (IEntry_)iteratorRemainingPropSamplesNewData.next();
            IRepositoryPropertyTypeID newPropertyTypeID = (IRepositoryPropertyTypeID)propertyTypeID2ObjectNew.getKey();
            if (!remainingPropertySamplesOldData.keySet().contains((Object)newPropertyTypeID)) continue;
            IEntry_ propertyTypeID2ObjectOld = remainingPropertySamplesOldData.getEntryByKey((Object)newPropertyTypeID);
            IRepositoryPropertySample oldPropertySample = (IRepositoryPropertySample)propertyTypeID2ObjectOld.getValue();
            IRepositoryPropertySample newPropertySample = (IRepositoryPropertySample)propertyTypeID2ObjectNew.getValue();
            IRepositoryDataType dataTypeOfPropertyToCheck = oldPropertySample.getValue().getDataType();
            IRepositoryDataEqualComparator dataEqualComparator = dataTypeOfPropertyToCheck.getEqualComparator();
            if (dataEqualComparator != null) {
                if (!dataEqualComparator.isEqual(newPropertySample.getValue(), oldPropertySample.getValue())) {
                    customPropertiesToModify.add((Object)propertyTypeID2ObjectNew);
                    iteratorRemainingPropSamplesNewData.remove();
                    continue;
                }
                iteratorRemainingPropSamplesNewData.remove();
                continue;
            }
            customPropertiesToModify.add((Object)propertyTypeID2ObjectNew);
            iteratorRemainingPropSamplesNewData.remove();
        }
        return customPropertiesToModify;
    }

    public static IMapRW_<IRepositoryPropertyTypeID, Object> createAllPropertiesMap(IRepositoryPropertySetSample propertiesAttributeSetSample) {
        HashMap_ remainingPropertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyTypeID propertyTypeID : propertiesAttributeSetSample.getPropertyTypeIDs()) {
            IRepositoryPropertySample propertySample = propertiesAttributeSetSample.getPropertySample(propertyTypeID);
            remainingPropertySamples.put((Object)propertyTypeID, (Object)propertySample);
        }
        return remainingPropertySamples;
    }

    public static IProperty[] extractStandardProperties(PlatformAdapterWorkstation workstationImplementation, IRepositoryObjectType objectType, IRepositoryPropertySetSample propertiesAttributeSetSample, IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamples) {
        IPropertyType[] standardPropertyTypes = workstationImplementation.getAllPropertyTypes(objectType);
        IProperty[] standardProperties = new IProperty[standardPropertyTypes.length];
        int i = 0;
        while (i < standardPropertyTypes.length) {
            IProperty newProperty;
            IPropertyType standardPropertyType = standardPropertyTypes[i];
            final IRepositoryPropertyTypeID propertyTypeID = standardPropertyType.getPropertyTypeID();
            IRepositoryPropertySample propertySample = (IRepositoryPropertySample)remainingPropertySamples.removeAsValue((Object)propertyTypeID);
            if (propertySample == null) {
                throw new IllegalArgumentException("missing property of type " + propertyTypeID.toCanonicalString());
            }
            final IRepositoryData value = propertiesAttributeSetSample.getPropertySample(propertyTypeID).getValue();
            standardProperties[i] = newProperty = new IProperty(){

                @Override
                public IRepositoryPropertyTypeID getPropertyTypeID() {
                    return propertyTypeID;
                }

                @Override
                public IRepositoryData getValue() {
                    return value;
                }
            };
            ++i;
        }
        return standardProperties;
    }

    public void modifyCustomProperties(IMapRW_<IRepositoryPropertyTypeID, Object> remainingPropertySamples) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        IAttributeOwnerRW attributeOwnerRW;
        if (!remainingPropertySamples.isEmpty() && (attributeOwnerRW = this.getWorkstationImplementation().findAttributeOwnerRW(this.getObjectImplementation())) != null) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
            IIteratorRW_ i = remainingPropertySamples.iterator();
            while (i.hasNext()) {
                IEntry_ iEntry_ = (IEntry_)i.next();
                IRepositoryPropertyTypeID propertyTypeID = (IRepositoryPropertyTypeID)iEntry_.getKey();
                IRepositoryPropertySample propertySample = (IRepositoryPropertySample)iEntry_.getValue();
                propertyTypeID = this.getAttributeSetType().getPropertyType(propertyTypeID).getRepositoryPropertyTypeID();
                if (!(propertyTypeID instanceof CustomPropertyTypeID)) continue;
                CustomPropertyTypeID customPropertyTypeID = (CustomPropertyTypeID)propertyTypeID;
                IAttributeTypeID cockpitAttributeTypeID = customPropertyTypeID.getAttributeTypeID();
                IAttributeType cockpitAttributeType = attributeOwnerRW.getAttributeType(cockpitAttributeTypeID);
                IRepositoryData repositoryData = propertySample.getValue();
                IAttributeTypeDataType cockpitAttributeTypeDataType = cockpitAttributeType.getDataType();
                IValueRange cockpitValueRange = cockpitAttributeType.getValueRange();
                Object cockpitValue = FrameDataConverter.convertRepositoryDataToCockpitAttribute(repositoryData, cockpitAttributeTypeDataType, cockpitValueRange);
                Attribute newAttribute = new Attribute(cockpitAttributeTypeID, cockpitValue);
                attributeOwnerRW.requestAttributeModificationPermission(newAttribute, transactionController);
                newAttributes.add(newAttribute);
                i.remove();
            }
            Collection<IModificationProblem> modProblems = transactionController.execute();
            if (modProblems.isEmpty()) {
                for (IAttribute iAttribute : newAttributes) {
                    try {
                        attributeOwnerRW.setAttribute(iAttribute);
                    }
                    catch (EXNoPermission e) {
                        throw new RuntimeException(e);
                    }
                    catch (EXNoLock e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                ModificationProblem.interpretateAsPlatformProblem(modProblems);
            }
        }
    }

    public IRepositoryPropertySetSample getSnapshotIDOfLastModification() {
        IRepositoryObjectTypeID objectTypeID = this.getObjectImplementation().getObjectType().getRepositoryObjectTypeID();
        String cockpitDataUID = this.getObjectImplementation().getCockpitDataUID();
        IRepositoryPropertySetSample objectID = this.getWorkstationImplementation().getObjectID(cockpitDataUID);
        IRepositoryPropertySetSample snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)this.getSnapshotImplementation().getSnapshotInformation(), (IRepositoryTypeManagerRO)this.getTypeManager());
        RepositoryAttributeSetLockSample attributeSetLockSample = new RepositoryAttributeSetLockSample(objectTypeID, this.attributeSetType.getRepositoryAttributeSetTypeID(), objectID, snapshotID);
        EOPlatformLock eoLock = this.getSnapshotImplementation().getWorkstationImplementation().createEOLock((AbstractRepositoryLockSample)attributeSetLockSample);
        String commitUID = this.getLockManager().getCommitUID(eoLock);
        return this.getWorkstationImplementation().getSnapshotID(commitUID);
    }
}

