/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.settings;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class ProjectSettingsCoDecForData {
    private static final String NULL = "null";

    public static void encodeIntoMemento(Object data, IDataType dataType, IArcwayMemento targetMemento) {
        Class type = dataType.getStructureType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            if (dataType.isNull(data)) {
                targetMemento.createChild(NULL);
            } else {
                IElementaryDataType elementaryDataType = (IElementaryDataType)dataType.getConcreteDataType();
                String valueAsString = elementaryDataType.getValueAsString(data);
                targetMemento.putTextData(valueAsString);
            }
        }
        if (IStructuredDataType.class.isAssignableFrom(type)) {
            if (dataType.isNull(data)) {
                targetMemento.putTextData(NULL);
            } else {
                IStructuredDataType structuredDataType = (IStructuredDataType)dataType.getConcreteDataType();
                IList_ propertyAndChildRoles = structuredDataType.getFlagAndPropertyAndChildRoles(data);
                for (IKey flagOrPropertyOrChildRole : propertyAndChildRoles) {
                    String flagOrPropertyOrChildRoleAsString = flagOrPropertyOrChildRole.toCanonicalString();
                    SubDataType subDataType = structuredDataType.getSubDataType(flagOrPropertyOrChildRole);
                    if (subDataType.isFlag()) {
                        targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                        continue;
                    }
                    if (subDataType.isProperty() || subDataType.isChild()) {
                        IDataType childDataType = structuredDataType.getDataTypeOfPropertyOrChildren(data, flagOrPropertyOrChildRole);
                        if (subDataType.isProperty()) {
                            Object property = structuredDataType.getProperty(data, flagOrPropertyOrChildRole);
                            IArcwayMemento propertyTargetMemento = targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                            ProjectSettingsCoDecForData.encodeIntoMemento(property, childDataType, propertyTargetMemento);
                            continue;
                        }
                        IList_ children = structuredDataType.getChildren(data, flagOrPropertyOrChildRole);
                        for (Object child : children) {
                            IArcwayMemento childTargetMemento = targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                            ProjectSettingsCoDecForData.encodeIntoMemento(child, childDataType, childTargetMemento);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public static Object decodeFromMemento(IArcwayMemento sourceMemento, IDataType dataType) throws Exception {
        Object data;
        Class type = dataType.getStructureType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)dataType.getConcreteDataType();
            data = ProjectSettingsCoDecForData.decodeElementaryDataFromMemento(sourceMemento, dataType, elementaryDataType);
        } else {
            IStructuredDataType structuredDataType = (IStructuredDataType)dataType.getConcreteDataType();
            data = ProjectSettingsCoDecForData.decodeStructuredDataFromMemento(sourceMemento, dataType, structuredDataType);
        }
        return data;
    }

    private static Object decodeElementaryDataFromMemento(IArcwayMemento sourceMemento, IDataType dataType, IElementaryDataType elementaryDataType) throws Exception {
        Object elementaryData;
        try {
            if (sourceMemento.getChild(NULL) != null) {
                elementaryData = dataType.createNullDataElement();
            } else {
                IElementaryDataFactory elementaryDataFactory = elementaryDataType.createDataFactory();
                String characters = sourceMemento.getTextData();
                elementaryDataFactory.setCharacters(characters);
                elementaryData = elementaryDataFactory.createDataElement();
            }
        }
        catch (EXDataCreationFailed e) {
            throw e.getCausingException();
        }
        return elementaryData;
    }

    private static Object decodeStructuredDataFromMemento(IArcwayMemento sourceMemento, IDataType dataType, IStructuredDataType structuredDataType) throws Exception {
        Object structuredData;
        try {
            if (StringUtil.equals((String)sourceMemento.getTextData(), (String)NULL)) {
                structuredData = dataType.createNullDataElement();
            } else {
                IStructuredDataFactory structuredDataFactory = structuredDataType.createDataFactory();
                ArrayList<String> childKeys_sorted = new ArrayList<String>();
                IArcwayMemento[] children = sourceMemento.getChildren();
                HashSet<String> childKeys = new HashSet<String>();
                IArcwayMemento[] iArcwayMementoArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IArcwayMemento child = iArcwayMementoArray[n2];
                    String type = child.getType();
                    if (!childKeys.contains(type)) {
                        childKeys.add(type);
                        childKeys_sorted.add(type);
                    }
                    ++n2;
                }
                for (String flagOrPropertyOrChildRoleAsString : childKeys_sorted) {
                    IArcwayMemento[] propertiesAndChildern;
                    Key flagOrPropertyOrChildRole = Key.getCanonicalKeyInstance((String)flagOrPropertyOrChildRoleAsString);
                    SubDataType subDataType = structuredDataType.getSubDataType((IKey)flagOrPropertyOrChildRole);
                    if (subDataType.isFlag()) {
                        if (sourceMemento.getChild(flagOrPropertyOrChildRoleAsString) == null) continue;
                        structuredDataFactory.setFlag((IKey)flagOrPropertyOrChildRole);
                        continue;
                    }
                    if (!subDataType.isProperty() && !subDataType.isChild()) continue;
                    IDataType dataTypeOfPropertyOrChildren = structuredDataFactory.getDataTypeOfPropertyOrChildren((IKey)flagOrPropertyOrChildRole);
                    IArcwayMemento[] iArcwayMementoArray2 = propertiesAndChildern = sourceMemento.getChildren(flagOrPropertyOrChildRoleAsString);
                    int n3 = propertiesAndChildern.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IArcwayMemento propertyOrChildMemento = iArcwayMementoArray2[n4];
                        Object propertyOrChild = ProjectSettingsCoDecForData.decodeFromMemento(propertyOrChildMemento, dataTypeOfPropertyOrChildren);
                        structuredDataFactory.addPropertyOrChild((IKey)flagOrPropertyOrChildRole, propertyOrChild);
                        ++n4;
                    }
                }
                structuredData = structuredDataFactory.createDataElement();
            }
        }
        catch (EXDataCreationFailed e) {
            throw e.getCausingException();
        }
        return structuredData;
    }
}

