/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version6;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOProject_V5;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version6.HistoricProjectDumpView_6_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version6.HistoricProjectFileView_6_;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MECategoryPermissionMigrator
implements ICockpitMigrator {
    public static final String KEY = "MECategoryPermissionMigrator";
    private static final String OPERATION_ID_MODIFY_ME_NAME = "modifyAttribute_frame.uniqueElement.displayName";
    private static final String OPERATION2_ID_MODIFY_ME_NAME = "com.arcway.cockpit.uniqueelement";
    private static final String OPERATION_ID_MODIFY_ALL_ME_ATTRIBUTES = "modifyAllAttributes";
    private static final String OPERATION2_ID_MODIFY_ALL_ME_ATTRIBUTES = "com.arcway.cockpit.uniqueelement";
    private static final String OPERATION_ID_MODIFYCATEGORY = "modify-category";
    private static final String DATA_TYPE_ID_MODELELEMENT = "com.arcway.cockpit.uniqueelement";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 6;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_6_ historicView = (HistoricProjectDumpView_6_)projectDump;
        try {
            for (EOProject_V5 project : historicView.getAllProjects()) {
                EOList<EOPermission> projectPermissions = historicView.readPermissions(project);
                MECategoryPermissionMigrator.migratePermissions(projectPermissions);
            }
        }
        catch (EXDecoderException eDE) {
            throw new MigrationFailedException(eDE);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    public void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_6_ historicView = (HistoricProjectFileView_6_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> projectPermissions = historicView.getDataList("permissions");
            MECategoryPermissionMigrator.migratePermissions(projectPermissions);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException(pfaE);
        }
    }

    private static void migratePermissions(Collection<EOPermission> projectPermissions) {
        ArrayList<EOPermission> permissionsToBeAdded = new ArrayList<EOPermission>();
        HashSet<String> permissionsThatHaveBeenConsidered = new HashSet<String>();
        for (EOPermission projectPermission : projectPermissions) {
            String ownerAndOperandKey;
            if ((!projectPermission.getOperation().equals(OPERATION_ID_MODIFY_ME_NAME) || !projectPermission.getOperation2().equals("com.arcway.cockpit.uniqueelement")) && (!projectPermission.getOperation().equals(OPERATION_ID_MODIFY_ALL_ME_ATTRIBUTES) || !projectPermission.getOperation2().equals("com.arcway.cockpit.uniqueelement")) || !permissionsThatHaveBeenConsidered.add(ownerAndOperandKey = String.valueOf(Integer.toString(projectPermission.getOwnerType())) + "\n" + projectPermission.getOwnerID() + "\n" + projectPermission.getOperandType() + "\n" + projectPermission.getOperandUID())) continue;
            EOPermission newMECategoryPermission = new EOPermission(projectPermission);
            newMECategoryPermission.setOperation(OPERATION_ID_MODIFYCATEGORY);
            newMECategoryPermission.setOperation2("com.arcway.cockpit.uniqueelement");
            permissionsToBeAdded.add(newMECategoryPermission);
        }
        projectPermissions.addAll(permissionsToBeAdded);
    }
}

