/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version5;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttribute_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOCommitCountAndCommitInformation_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOFileMetaInformation_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOProject_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.V5_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version5.HistoricProjectDumpView_5_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version5.HistoricProjectFileView_5_;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.util.Collections;
import java.util.List;

public class FileCreationDateMigrator
implements ICockpitMigrator {
    private static final ILogger LOGGER = Logger.getLogger(FileCreationDateMigrator.class);
    public static final String KEY = "FileCreationDateMigrator";
    private static final IEncodableObjectFactory eoFactory = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V5_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault()});
    public static final String ATTRHRID_LAST_EDIT_DATE = "lastEditDate";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 5;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return eoFactory;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_5_ historicView = (HistoricProjectDumpView_5_)projectDump;
            List<EOProject_V5> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V5 currentProject : projects) {
                    EOList<EOCommitCountAndCommitInformation_V5> commitInformationItems = historicView.readCommitInformationItems(currentProject);
                    EOList<EOFileMetaInformation_V5> fileMetaInformationItems = historicView.readFileMetaInformationItems(currentProject);
                    this.migrateFileMetaInformationItems(fileMetaInformationItems, commitInformationItems, 0L);
                    historicView.writeDataFile(currentProject, "metainformation.xml", "files", (EncodableObjectBase)fileMetaInformationItems);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    private void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_5_ historicView = (HistoricProjectFileView_5_)projectFile;
        try {
            EOProject_V5 project = historicView.getProjectMetaData_5();
            EOList<? extends EncodableObjectBase> fileMetaInformation = historicView.getDataList("fileMetaInformation");
            long projectModTime = 0L;
            for (EOAttribute_V5 attribute : project.getAttributes()) {
                if (!attribute.getAttributeTypeUID().getHumanreadableID().equals(ATTRHRID_LAST_EDIT_DATE)) continue;
                try {
                    projectModTime = Long.valueOf(((EOString)attribute.getValueAsEO()).getString());
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            if (projectModTime == 0L) {
                LOGGER.warn("Project does not have a mod time.");
                projectModTime = System.currentTimeMillis();
            }
            this.migrateFileMetaInformationItems(fileMetaInformation, null, projectModTime);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Can't access project file.", pfaE);
        }
    }

    private void migrateFileMetaInformationItems(EOList<EOFileMetaInformation_V5> fileMetaInformation, EOList<EOCommitCountAndCommitInformation_V5> commitInformationItems, long creationDate) {
        for (EOFileMetaInformation_V5 fileMetaInformationItem : fileMetaInformation) {
            if (fileMetaInformationItem.getCreationDate() != 0L) continue;
            long newCreationDate = -1L;
            if (commitInformationItems != null) {
                EOCommitCountAndCommitInformation_V5 commitInformation = (EOCommitCountAndCommitInformation_V5)commitInformationItems.get(fileMetaInformationItem.getCommitCount() - 1);
                newCreationDate = commitInformation.getCommitInformation().getCommitDate().getTime();
            } else {
                newCreationDate = creationDate;
            }
            fileMetaInformationItem.setCreationDate(newCreationDate);
        }
    }
}

