/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3.planmigrators;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.planmigrators.PlanMigratorsHelper_V0;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class PlanDataMigratorProjectDump
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.plandatamigratorprojectdump";
    private static final MultiplexEncodableObjectFactory EO_FACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault()});

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File plansDirectory = new File(projectDirectory, "plans");
                    if (!plansDirectory.exists()) continue;
                    EncodableObjectBase encodableObject = historicView.readDataFile(currentProject, "plans.xml", null, (IEncodableObjectFactory)EO_FACTORY);
                    if (encodableObject != null && encodableObject instanceof EOList) {
                        EOList eoPlans = (EOList)encodableObject;
                        for (Object o : eoPlans) {
                            if (o instanceof EOPlan_V0) {
                                EOPlan_V0 eoPlan = (EOPlan_V0)((Object)o);
                                File planDirectory = new File(plansDirectory, eoPlan.getUID());
                                if (planDirectory.exists()) {
                                    this.migratePlanData(planDirectory, eoPlan, historicView, projectDirectory);
                                    continue;
                                }
                                String message = "The plan directory of the plan '" + eoPlan.getUID() + "'could not be found.";
                                throw new MigrationFailedException(message);
                            }
                            String message = "The EOList of plans contains an element that is not of type EOPlan_V0: " + o.getClass().getName();
                            throw new MigrationFailedException(message);
                        }
                        historicView.writeDataFile(currentProject, "plans.xml", null, (EncodableObjectBase)eoPlans);
                        continue;
                    }
                    String message = "Plans file does not exits or contains an element not of type EOList";
                    throw new MigrationFailedException(message);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migratePlanData(File planDirectory, EOPlan_V0 eoPlan, HistoricProjectDumpView_3_ historicView, File projectDirectory) throws MigrationFailedException {
        block5: {
            try {
                EncodableObjectBase encodableObject = historicView.readDataFile(planDirectory, "history.xml", (IEncodableObjectFactory)EO_FACTORY);
                if (encodableObject != null && encodableObject instanceof EOList) {
                    EOList fileHistoryItems = (EOList)encodableObject;
                    EOFileHistoryItem_V0.sortFileHistoryItemListByVersionNumberOnly((List<EOFileHistoryItem_V0>)fileHistoryItems);
                    EOList sortedHistoryItems = fileHistoryItems;
                    File filesDirectory = new File(projectDirectory, "files");
                    FileHelper.ensureDirectoryExistance((File)filesDirectory);
                    File fileFilesDirectory = new File(filesDirectory, "file");
                    FileHelper.ensureDirectoryExistance((File)fileFilesDirectory);
                    File newPlanFileDirectory = new File(fileFilesDirectory, "versions_" + eoPlan.getUID());
                    FileHelper.ensureDirectoryExistance((File)newPlanFileDirectory);
                    for (EOFileHistoryItem_V0 fileHistoryItem : sortedHistoryItems) {
                        this.moveAndRenameVersionedPlanFile(planDirectory, fileHistoryItem, newPlanFileDirectory);
                        fileHistoryItem.setFileTypeID("file");
                    }
                    historicView.writeDataFile(newPlanFileDirectory, "versions1", (EncodableObjectBase)sortedHistoryItems);
                    FileHelper.deleteExistingFileOrDirectory((File)planDirectory);
                    this.migrateEOPlan(eoPlan, (EOList<EOFileHistoryItem_V0>)sortedHistoryItems);
                    break block5;
                }
                String message = "Plan versions file (planUID: " + eoPlan.getUID() + ") does not exits or contains an element not of type EOList.";
                throw new MigrationFailedException(message);
            }
            catch (JvmExternalResourceInteractionException e) {
                throw new MigrationFailedException(e);
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
        }
    }

    private void moveAndRenameVersionedPlanFile(File oldPlanFileDirectory, EOFileHistoryItem_V0 historyItem, File newPlanFileDirectory) throws JvmExternalResourceInteractionException {
        String versionNumber = Integer.toString(historyItem.getVersionNumber());
        File oldPlanFile = new File(oldPlanFileDirectory, String.valueOf(historyItem.getFileUID()) + "_v_" + versionNumber);
        File newPlanFile = new File(newPlanFileDirectory, versionNumber);
        FileHelper.moveFile((File)oldPlanFile, (File)newPlanFile);
    }

    private void migrateEOPlan(EOPlan_V0 eoPlan, EOList<EOFileHistoryItem_V0> sortedHistoryItems) {
        EOFileHistoryItem_V0 historyItemWithHighestVersion = (EOFileHistoryItem_V0)sortedHistoryItems.get(sortedHistoryItems.size() - 1);
        int highestVersionNumber = historyItemWithHighestVersion.getVersionNumber();
        String originalFileName = historyItemWithHighestVersion.getOriginalFileName();
        if (originalFileName == null || originalFileName.equals("")) {
            originalFileName = PlanMigratorsHelper_V0.createOriginalPlanFileName(eoPlan);
        }
        PlanMigratorsHelper_V0.migrateEOPlan(eoPlan, highestVersionNumber, originalFileName);
    }
}

