/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileVersionsInProjectFileMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(FileVersionsInProjectFileMigrator.class);
    public static final String KEY = "com.arcway.cockpit.frame.client.project.filemigrator.FileVersionMigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("LocalLinkMigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView dumpFile) {
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView dumpFile) {
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            HistoricProjectFileView_0_ projectFileView_3_ = (HistoricProjectFileView_0_)projectFile;
            for (File filesDirectory : projectFileView_3_.getAllDirectoriesWithFiles()) {
                File[] files = filesDirectory.listFiles();
                if (files == null) continue;
                HashMap<String, Tuple> fileIDs_2_highestFileVersion = new HashMap<String, Tuple>(files.length);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Tuple highestVersionNumber_with_File;
                    Integer highestVersionNumber;
                    Integer currentVersionNumber;
                    File file = fileArray[n2];
                    String currentFileID = de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)file.getName());
                    String fileExtension = de.plans.lib.util.FileHelper.getFileType((File)file);
                    try {
                        currentVersionNumber = Integer.valueOf(fileExtension);
                    }
                    catch (NumberFormatException e) {
                        currentVersionNumber = null;
                    }
                    if (currentVersionNumber != null && ((highestVersionNumber = (highestVersionNumber_with_File = (Tuple)fileIDs_2_highestFileVersion.get(currentFileID)) == null ? null : (Integer)highestVersionNumber_with_File.getT1()) == null || currentVersionNumber >= highestVersionNumber)) {
                        fileIDs_2_highestFileVersion.put(currentFileID, new Tuple((Object)currentVersionNumber, (Object)file));
                    }
                    ++n2;
                }
                for (Map.Entry fileID_2_highestFileVersion : fileIDs_2_highestFileVersion.entrySet()) {
                    String fileID = (String)fileID_2_highestFileVersion.getKey();
                    File targetFile = new File(filesDirectory, fileID);
                    if (targetFile.exists()) continue;
                    File sourceFile = (File)((Tuple)fileID_2_highestFileVersion.getValue()).getT2();
                    try {
                        FileHelper.ensureDirectoryExistance((File)targetFile.getParentFile());
                        FileHelper.moveFile((File)sourceFile, (File)targetFile);
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        logger.error("Can't migrate project file.", (Throwable)e);
                    }
                }
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can't migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }
}

