/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version5;

import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.stringtools.StringCanonicalizer;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.HashMap;

public class EOLink_V5
extends EOEncodableObject
implements ICockpitProjectData {
    private static final HashMap<String, String> canonicalStrings = new HashMap(30, 0.5f);
    public static final String TYPE_ID = EOLink_V5.defineCanonicalString("com.arcway.cockpit.frame.eolink");
    private boolean hashCodeCached = false;
    private int cachedHashCode = 0;
    private String linkableObjectUID;
    private String moduleDataUID;
    private String uID;
    private String moduleID;
    private String linkTypeID;
    private String projectUID;
    public static final String XML_NAME = EOLink_V5.defineCanonicalString("frame.link");
    public static final String ATTR_TAG_LINKABLE_OBJ_UID_OLD = EOLink_V5.defineCanonicalString("linkableObjectUID");
    public static final String ATTR_TAG_LINKABLE_OBJ_UID = EOLink_V5.defineCanonicalString("linkEndItemUID");
    public static final String ATTR_TAG_MODULE_DATA_UID_OLD = EOLink_V5.defineCanonicalString("moduleDataUID");
    public static final String ATTR_TAG_MODULE_DATA_UID = EOLink_V5.defineCanonicalString("linkStartItemUID");
    public static final String ATTR_TAG_MODULE_ID = EOLink_V5.defineCanonicalString("moduleID");
    public static final String ATTR_TAG_LINK_TYPE_ID = EOLink_V5.defineCanonicalString("linkTypeID");
    public static final String ATTR_TAG_UID = EOLink_V5.defineCanonicalString("UID");
    public static final String ATTR_TAG_PROJECT_UID = EOLink_V5.defineCanonicalString("projectUID");

    private static String defineCanonicalString(String s) {
        String cs = StringCanonicalizer.getInstance().getCanonicalString(s);
        canonicalStrings.put(cs, cs);
        return cs;
    }

    public EOLink_V5(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOLink_V5(String xmlName) {
        super(xmlName);
    }

    public EOLink_V5(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public EOLink_V5() {
        super(XML_NAME);
    }

    public EOLink_V5(EOLink_V5 link) {
        this();
        assert (link != null) : "link must not be null";
        this.linkableObjectUID = link.getLinkableObjectUID();
        this.moduleDataUID = link.getModuleDataUID();
        this.moduleID = link.getModuleID();
        this.linkTypeID = link.getLinkTypeID();
        this.projectUID = link.getProjectUID();
        this.uID = UUIDGenerator.getUniqueID();
    }

    public EOLink_V5(String projectUID, String linkableObjectUID, String moduleDataUID, String moduleID, String linkTypeID) {
        super(XML_NAME);
        assert (projectUID != null) : "projectUID must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (moduleDataUID != null) : "moduleDataUID must not be null";
        assert (moduleID != null) : "moduleID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        assert (linkTypeID.length() < 256);
        this.setLinkableObjectUID(linkableObjectUID);
        this.setModuleDataUID(moduleDataUID);
        this.setModuleID(moduleID);
        this.setLinkTypeID(linkTypeID);
        this.setProjectUID(projectUID);
        this.setUID(UUIDGenerator.getUniqueID());
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        assert (writeContext != null) : "outp must not be null";
        this.appendAttrToXML(writeContext, ATTR_TAG_LINKABLE_OBJ_UID, this.linkableObjectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_MODULE_DATA_UID, this.moduleDataUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_MODULE_ID, this.moduleID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LINK_TYPE_ID, this.linkTypeID);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.uID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        assert (value != null) : "value must not be null";
        String localName = name;
        int i = 0;
        while (i < 2) {
            if (ATTR_TAG_LINKABLE_OBJ_UID == localName || ATTR_TAG_LINKABLE_OBJ_UID_OLD == localName) {
                assert (!this.hashCodeCached);
                this.linkableObjectUID = value;
                return true;
            }
            if (ATTR_TAG_MODULE_DATA_UID == localName || ATTR_TAG_MODULE_DATA_UID_OLD == localName) {
                assert (!this.hashCodeCached);
                this.moduleDataUID = value;
                return true;
            }
            if (ATTR_TAG_MODULE_ID == localName) {
                this.moduleID = value;
                return true;
            }
            if (ATTR_TAG_LINK_TYPE_ID == localName) {
                assert (!this.hashCodeCached);
                this.linkTypeID = value;
                return true;
            }
            if (ATTR_TAG_PROJECT_UID == localName) {
                assert (!this.hashCodeCached);
                this.projectUID = value;
                return true;
            }
            if (ATTR_TAG_UID == localName) {
                this.uID = value;
                return true;
            }
            localName = canonicalStrings.get(localName);
            ++i;
        }
        return false;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getLinkableObjectUID() {
        return this.linkableObjectUID;
    }

    public String getModuleDataUID() {
        return this.moduleDataUID;
    }

    public void setLinkableObjectUID(String uid) {
        assert (uid != null) : "UID must not be null";
        assert (uid.length() < 33);
        assert (!this.hashCodeCached);
        this.linkableObjectUID = uid;
    }

    public void setModuleDataUID(String uid) {
        assert (uid != null) : "UID must not be null";
        assert (uid.length() < 33);
        assert (!this.hashCodeCached);
        this.moduleDataUID = uid;
    }

    public String getUID() {
        return this.uID;
    }

    public void setUID(String uID) {
        assert (uID != null) : "UID must not be null";
        this.uID = uID;
    }

    public String getLinkTypeID() {
        return this.linkTypeID;
    }

    @Deprecated
    public String getModuleID() {
        return this.moduleID;
    }

    public void setLinkTypeID(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        assert (linkTypeID.length() < 256);
        assert (!this.hashCodeCached);
        this.linkTypeID = linkTypeID;
    }

    public void setModuleID(String moduleID) {
        assert (moduleID != null) : "moduleID must not be null";
        assert (moduleID.length() < 256);
        this.moduleID = moduleID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EOLink_V5)) {
            return false;
        }
        EOLink_V5 link = (EOLink_V5)((Object)obj);
        return this == link || this.projectUID.equals(link.getProjectUID()) && this.linkTypeID.equals(link.getLinkTypeID()) && this.moduleDataUID.equals(link.getModuleDataUID()) && this.linkableObjectUID.equals(link.getLinkableObjectUID());
    }

    public int hashCode() {
        int calculatedHashCode;
        if (this.hashCodeCached) {
            return this.cachedHashCode;
        }
        assert (this.projectUID != null && this.linkTypeID != null && this.linkableObjectUID != null && this.moduleDataUID != null);
        this.cachedHashCode = calculatedHashCode = this.linkTypeID.hashCode() + 31 * this.linkableObjectUID.hashCode() + 961 * this.moduleDataUID.hashCode();
        this.hashCodeCached = true;
        return calculatedHashCode;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        assert (projectUID != null) : "projectUID must not be null";
        assert (projectUID.length() < 33);
        assert (!this.hashCodeCached);
        this.projectUID = projectUID;
    }

    public String toString() {
        return "\n----- Link: --------------\nUID: " + this.uID + "\nLink Type ID: " + this.linkTypeID + "\nLink Start (MD) - Item UID: " + this.moduleDataUID + "\nLink End (LO) - Item UID: " + this.linkableObjectUID + "\nProject UID: " + this.projectUID + "\n--------------------------";
    }

    public String getTypeID() {
        return TYPE_ID;
    }
}

