/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IReportJobParameter;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard_FilterConfigurationPage;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard_MainPage;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IDocGenWizardPage;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import com.arcway.cockpit.frame.client.project.docgenerator.reportinfo.ReportMetaInfo;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateReportWizard
extends Wizard {
    private static final ILogger logger = Logger.getLogger(CreateReportWizard.class);
    private final IDocGeneratorProjectAgent projectAgent;
    private final List<IFilterItemProvider> filterItemProviders;
    private final IReportTemplateRW preselectedItem;
    private final ReportJob reportJob;
    private CreateReportWizard_MainPage mainPage;
    private CreateReportWizard_FilterConfigurationPage filterPage;
    private List<IDocGenWizardPage> generatorSpecificPages;

    public CreateReportWizard(IDocGeneratorProjectAgent projectAgent, IReportTemplateRW preselectedItem, List<IFilterItemProvider> filterItemProviders, ReportJob reportJob) {
        this.setWindowTitle(Messages.getString("CreateReportWizard.0"));
        this.projectAgent = projectAgent;
        this.preselectedItem = preselectedItem;
        this.filterItemProviders = filterItemProviders;
        this.reportJob = reportJob;
    }

    public void addPages() {
        this.mainPage = new CreateReportWizard_MainPage(this.projectAgent, this.preselectedItem, this.reportJob);
        this.addPage((IWizardPage)this.mainPage);
        this.filterPage = new CreateReportWizard_FilterConfigurationPage(this.projectAgent, this.filterItemProviders);
        this.addPage((IWizardPage)this.filterPage);
        this.generatorSpecificPages = new ArrayList<IDocGenWizardPage>();
    }

    public IWizardPage getStartingPage() {
        if (this.mainPage.isToBeShown()) {
            return this.mainPage;
        }
        if (this.filterPage.isToBeShown()) {
            return this.filterPage;
        }
        return this.getFirstGeneratorSpecificPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.filterPage.isToBeShown()) {
                return this.filterPage;
            }
            return this.getFirstGeneratorSpecificPage();
        }
        if (page == this.filterPage) {
            return this.getFirstGeneratorSpecificPage();
        }
        return this.getNextGeneratorSpecificPage(page);
    }

    private IWizardPage getFirstGeneratorSpecificPage() {
        if (this.generatorSpecificPages != null && !this.generatorSpecificPages.isEmpty()) {
            IDocGenWizardPage nextPage = this.generatorSpecificPages.get(0);
            nextPage.aboutToBeShown();
            return nextPage;
        }
        return null;
    }

    private IWizardPage getNextGeneratorSpecificPage(IWizardPage currentPage) {
        int index = this.generatorSpecificPages.indexOf(currentPage);
        if (index >= 0 && index < this.generatorSpecificPages.size() - 1) {
            IDocGenWizardPage nextPage = this.generatorSpecificPages.get(index + 1);
            nextPage.aboutToBeShown();
            return nextPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.generatorSpecificPages.indexOf(page);
        if (index == 0) {
            if (this.filterPage.isToBeShown()) {
                return this.filterPage;
            }
            if (this.mainPage.isToBeShown()) {
                return this.mainPage;
            }
            return null;
        }
        if (index > 0 && index < this.generatorSpecificPages.size()) {
            return this.generatorSpecificPages.get(index - 1);
        }
        if (page == this.filterPage && this.mainPage.isToBeShown()) {
            return this.mainPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        for (IWizardPage iWizardPage : this.generatorSpecificPages) {
            if (iWizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public void setReportTemplate(IReportTemplate reportTemplate) {
        if (reportTemplate != null) {
            this.filterPage.setReportTemplateToBeUsed(reportTemplate);
        }
    }

    public void setReportType(IReportType reportType) {
        this.generatorSpecificPages.clear();
        this.updateAllowedFilters(reportType);
        if (reportType != null) {
            IFrameDocGenerator reportGenerator = this.projectAgent.getReportGeneratorForReportType(reportType.getID());
            List<IDocGenWizardPage> pages = reportGenerator.getDocGenWizardPages();
            for (IDocGenWizardPage page : pages) {
                page.setWizard((IWizard)this);
                page.init(this.reportJob);
                this.generatorSpecificPages.add(page);
            }
        }
    }

    private void updateAllowedFilters(IReportType reportType) {
        IReportTemplate reportTemplate = this.reportJob.getReportTemplate();
        Set<String> allowedFilterIDs = CreateReportWizard.calculateAllowedFilterIDs(reportType, reportTemplate);
        this.filterPage.setAllowedFilterIDs(allowedFilterIDs);
    }

    public static Set<String> calculateAllowedFilterIDs(IReportType reportType, IReportTemplate reportTemplate) {
        Set<String> allowedFilterIDs = reportTemplate != null && reportType != null ? reportType.getFilterIDs(reportTemplate) : Collections.singleton("--all--");
        return allowedFilterIDs;
    }

    public String getInfoMessageFromGeneratorSpecificPages() {
        String infoMessage = this.filterPage.getInfoMessage();
        if (infoMessage != null) {
            return infoMessage;
        }
        for (IDocGenWizardPage page : this.generatorSpecificPages) {
            infoMessage = page.getInfoMessage();
            if (infoMessage == null) continue;
            return infoMessage;
        }
        return null;
    }

    public boolean performFinish() {
        this.mainPage.writeSettingsToConfiguration();
        this.filterPage.writeSettingsToConfiguration();
        for (IDocGenWizardPage page : this.generatorSpecificPages) {
            page.writeSettingsToConfiguration();
        }
        this.reportJob.setFilterSettings(Collections.singletonMap(this.projectAgent.getProjectUID(), this.filterPage.getActiveFilterItemProviders()));
        ReportResultFileType reportFileType = this.reportJob.getReportFileType();
        if (reportFileType != ReportResultFileType.NO_OUTPUT) {
            boolean determinedOutputFile = false;
            IReportType reportType = this.reportJob.getReportType();
            if (reportType != null) {
                determinedOutputFile = reportType.hasDeterminedOutputFile();
            }
            if (!determinedOutputFile) {
                File directory;
                File outputFile = new File(this.reportJob.getReportFilename());
                if (outputFile.exists() && reportFileType == ReportResultFileType.FILE) {
                    String title = Messages.getString("CreateReportWizard.Overwrite");
                    String message = String.valueOf(Messages.getString("CreateReportWizard.QuestionPart1")) + "\"" + outputFile.getName() + "\"" + Messages.getString("CreateReportWizard.QuestionPart2");
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message)) {
                        return false;
                    }
                    try {
                        FileHelper.deleteExistingFileOrDirectory((File)outputFile);
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        logger.info("Unable to delete existing file.", (Throwable)e);
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreateReportWizard.OverwriteProblemTitle"), (String)NLS.bind((String)Messages.getString("CreateReportWizard.OverwriteProblemMessage"), (Object)outputFile.getPath()));
                        return false;
                    }
                }
                File file = directory = reportFileType == ReportResultFileType.DIRECTORY ? outputFile : outputFile.getParentFile();
                if (!directory.exists()) {
                    boolean createDirectory = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("CreateReportWizard.CreateDirectory.Title"), (String)NLS.bind((String)Messages.getString("CreateReportWizard.CreateDirectory.Question"), (Object)directory.getAbsolutePath()));
                    if (createDirectory) {
                        try {
                            FileHelper.ensureDirectoryExistance((File)directory);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            logger.info("Unable to create directory.", (Throwable)e);
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CreateReportWizard.Error.CantCreateDirectory.Title"), (String)NLS.bind((String)Messages.getString("CreateReportWizard.Error.CantCreateDirectory.Message"), (Object)directory.getAbsolutePath()));
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (reportFileType == ReportResultFileType.DIRECTORY && !CreateReportWizard.checkForEmptyTargetDirectory(this.getShell(), outputFile)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkForEmptyTargetDirectory(Shell shell, File outputDir) {
        boolean deleteExistingReport;
        ReportMetaInfo reportInfo = ReportMetaInfo.containsReport(outputDir);
        if (reportInfo != null && (deleteExistingReport = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString("CreateReportWizard.Error.DeleteOldReportInTargetDirectory.Title"), (String)NLS.bind((String)Messages.getString("CreateReportWizard.Error.DeleteOldReportInTargetDirectory.Message"), (Object[])new Object[]{reportInfo.getName(), reportInfo.getType(), reportInfo.getProjectName(), DateFormat.getDateTimeInstance().format(new Date(reportInfo.getCreationMillis()))})))) {
            ReportMetaInfo.deleteReport(reportInfo);
            if (!FileHelper.doesDirectoryContainEssentialFiles((File)outputDir, (boolean)true, (boolean)true)) {
                try {
                    FileHelper.deleteContentOfDirectory((File)outputDir);
                }
                catch (JvmExternalResourceInteractionException e1) {
                    logger.error("Problem while deleting empty directories and auxiliary files in Report directory - continuing.", (Throwable)e1);
                }
            }
        }
        if (FileHelper.doesDirectoryContainEssentialFiles((File)outputDir, (boolean)true, (boolean)true)) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("CreateReportWizard.Error.NonEmptyTargetDirectory.Title"), (String)Messages.getString("CreateReportWizard.Error.NonEmptyTargetDirectory.Message"));
            return false;
        }
        return true;
    }

    public List<IReportJobParameter> getGeneratorSpecificParameters() {
        if (this.generatorSpecificPages == null) {
            return Collections.emptyList();
        }
        ArrayList<IReportJobParameter> parameters = new ArrayList<IReportJobParameter>(this.generatorSpecificPages.size());
        for (IDocGenWizardPage page : this.generatorSpecificPages) {
            parameters.add(page.getParameter());
        }
        return parameters;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.mainPage.allPagesCreated();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageContainer, "com.arcway.cockpit.frame.client.docgenerator_index");
    }
}

