/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.plan;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.planimportexport.IExternalPlanImporterExporterControllerExtension;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentExtensionTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeNotSupported;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportPlanWizard
extends Wizard
implements IImportWizard {
    public static final String wizardID = "com.arcway.cockpit.frame.client.project.datainterchange.plan.ExportPlanWizard";
    private static final ILogger logger = Logger.getLogger(ExportPlanWizard.class);
    private static final String name = Messages.getString("ExportPlanWizard.0");
    private final Map<ISection, String> directoriesToExport;
    private final Map<ISection, String> notExportedDirectories;
    private final Map<IPlan, String> plansToExport;
    private final Map<IPlan, String> notExportedPlans;
    private String errorMsg;
    private final ISection exportedSection;
    private Collection<Object> exportElements;
    private ExportPlanPage page;
    private Set<Object> existingFiles = new HashSet<Object>();
    private final IFrameProjectAgent projectAgent;

    protected ExportPlanWizard(IFrameProjectAgent projectAgent, ISection section) {
        this.projectAgent = projectAgent;
        this.exportedSection = section;
        this.directoriesToExport = new HashMap<ISection, String>();
        this.notExportedDirectories = new HashMap<ISection, String>();
        this.plansToExport = new HashMap<IPlan, String>();
        this.notExportedPlans = new HashMap<IPlan, String>();
        Collection<IPlan> plans = this.getAllChildPlans(section);
        Collection<ISection> sections = this.getAllChildSections(section);
        this.init(plans, sections);
    }

    protected ExportPlanWizard(IFrameProjectAgent projectAgent, ISection section, IPlan plan) {
        this.projectAgent = projectAgent;
        this.exportedSection = section;
        this.directoriesToExport = new HashMap<ISection, String>();
        this.notExportedDirectories = new HashMap<ISection, String>();
        this.plansToExport = new HashMap<IPlan, String>();
        this.notExportedPlans = new HashMap<IPlan, String>();
        List<IPlan> plans = Collections.singletonList(plan);
        List<ISection> sections = Collections.singletonList(section);
        this.init(plans, sections);
    }

    public void addPages() {
        super.addPages();
        this.page = new ExportPlanPage();
        this.addPage((IWizardPage)this.page);
        IArcwayMemento wizardMemento = ExportPlanWizard.getOrCreateMementoChild(this.projectAgent.getFrameLocalSettings(), wizardID);
        IArcwayMemento pageMemento = ExportPlanWizard.getOrCreateMementoChild(wizardMemento, this.page.getPageId());
        this.page.readSettings(pageMemento);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final String path = this.page.getPathName();
        final int workUnits = this.plansToExport.size();
        this.errorMsg = null;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JFaceProgressMonitorToProgressDisplayAdapter progressDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                progressDisplay.beginQuantifiedTask(Messages.getString("DataInterchangeWizard.9", Locale.getDefault()), workUnits, false);
                try {
                    ExportPlanWizard.this.createPlanAndDirectory(path, (IProgressDisplay)progressDisplay, monitor);
                    IArcwayMemento wizardMemento = ExportPlanWizard.getOrCreateMementoChild(ExportPlanWizard.this.projectAgent.getFrameLocalSettings(), ExportPlanWizard.wizardID);
                    IArcwayMemento pageMemento = ExportPlanWizard.getOrCreateMementoChild(wizardMemento, ExportPlanWizard.this.page.getPageId());
                    ExportPlanWizard.this.page.saveSettings(pageMemento);
                }
                catch (InvocationTargetException e) {
                    ExportPlanWizard.this.errorMsg = e.getMessage();
                }
                progressDisplay.endTask();
            }
        };
        try {
            dialog.setOpenOnRun(true);
            dialog.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.errorMsg = e.getMessage();
            logger.error("could not copy plan", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.errorMsg = e.getMessage();
            logger.error("InterruptedException", (Throwable)e);
        }
        if (this.errorMsg != null) {
            MessageDialog mDialog = new MessageDialog(this.getShell(), Messages.getString("ExportPlanWizard.17"), null, this.errorMsg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return false;
        }
        return true;
    }

    private void addDirectoryToExportList(ISection section, String nameOfSection) {
        this.directoriesToExport.put(section, ExportPlanWizard.getLegalName(nameOfSection));
        if (this.notExportedDirectories.containsKey(section)) {
            this.notExportedDirectories.remove(section);
        }
    }

    private void removeDirectoryFromExportList(ISection section, String nameOfSection) {
        if (this.directoriesToExport.containsKey(section)) {
            this.notExportedDirectories.put(section, nameOfSection);
            this.directoriesToExport.remove(section);
        } else {
            this.notExportedDirectories.put(section, nameOfSection);
        }
    }

    private void addPlanToExportList(IPlan plan, String planName) {
        this.plansToExport.put(plan, ExportPlanWizard.getLegalName(planName));
        if (this.notExportedPlans.containsKey(plan)) {
            this.notExportedPlans.remove(plan);
        }
    }

    private void removePlanFromExportList(IPlan plan, String planName) {
        if (this.plansToExport.containsKey(plan)) {
            this.notExportedPlans.put(plan, planName);
            this.plansToExport.remove(plan);
        } else {
            this.notExportedPlans.put(plan, planName);
        }
    }

    private void createPlanAndDirectory(String exportedPath, IProgressDisplay progressDisplay, IProgressMonitor monitor) throws InvocationTargetException {
        boolean overWriteAll = false;
        boolean cancel = false;
        int workReported = 0;
        Iterator<IPlan> i = this.plansToExport.keySet().iterator();
        while (i.hasNext() && !cancel) {
            boolean success;
            IPlan object;
            IPlan plan = object = i.next();
            String fileName = this.getFileNameAndExtension(plan, this.plansToExport.get(plan));
            progressDisplay.reportQuantifiedProgress(workReported++, fileName);
            String pathName = this.getTargetPathName(exportedPath, this.exportedSection, this.projectAgent.getSectionManager().getParentSection(plan));
            File directory = new File(pathName);
            if (!directory.exists() && !(success = directory.mkdirs())) {
                logger.warn("didn't succeed in creating directory: " + directory.getAbsolutePath());
            }
            fileName = ExportPlanWizard.getRealFileName(pathName, fileName);
            ControllerExtensionContainer cec = new ControllerExtensionContainer();
            try {
                cec.setControllerExtension(this.projectAgent.getPlanImporterExporterManager().getExporter(plan, (IProgressDisplay)new JFaceProgressMonitorToProgressDisplayAdapter(monitor)));
            }
            catch (PlanAgentManager.EXPlanAgentLaunchException e) {
                cec.setErrorMessage(e.getLocalizedMessage());
                logger.error("could not copy plan", (Throwable)e);
                throw new InvocationTargetException(e);
            }
            catch (EXWriteAccessDeniedException e) {
                cec.setErrorMessage(e.getLocalizedMessage());
                logger.error("could not copy plan", (Throwable)e);
                throw new InvocationTargetException(e);
            }
            IExternalPlanImporterExporterControllerExtension ctrl = cec.getControllerExtension();
            File original = ctrl.getPlanFile();
            File copy = new File(fileName);
            try {
                try {
                    File dir;
                    boolean success2;
                    boolean doIt = false;
                    if (copy.exists() && !overWriteAll) {
                        MessageDialog mb = new MessageDialog(this.getShell(), Messages.getString("ExportPlanWizard.2"), null, String.valueOf(Messages.getString("ExportPlanWizard.3")) + copy.getName() + Messages.getString("ExportPlanWizard.4"), 4, new String[]{Messages.getString("ExportPlanWizard.5"), Messages.getString("ExportPlanWizard.6"), Messages.getString("ExportPlanWizard.7"), Messages.getString("ExportPlanWizard.8")}, 0);
                        mb.open();
                        int answer = mb.getReturnCode();
                        if (answer == 0) {
                            doIt = true;
                        } else if (answer == 1) {
                            overWriteAll = true;
                        } else if (answer == 3) {
                            cancel = true;
                        }
                    } else {
                        doIt = true;
                    }
                    if (!doIt && !overWriteAll) continue;
                    String targetDirName = copy.getParent();
                    if (targetDirName != null && !(success2 = (dir = new File(targetDirName)).mkdirs()) && !dir.exists()) {
                        logger.warn("didn't succeed in creating file: " + targetDirName);
                    }
                    if (copy.exists()) {
                        try {
                            FileHelper.deleteExistingFileOrDirectory((File)copy);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            logger.warn("didn't succeed in deleting file: " + copy.toString());
                        }
                    }
                    DataCopyHelper.copyFile((File)original, (File)copy);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.error("error while copying data", (Throwable)e);
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                if (cec.getControllerExtension() != null) {
                    cec.getControllerExtension().close();
                }
            }
        }
    }

    private Collection<IPlan> getAllDirectChildPlans(ISection section) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>();
        for (IPlan iPlan : this.projectAgent.getFrameSectionManager().getChildPlans(section)) {
            if (!this.isPlanExportable(iPlan)) continue;
            plans.add(iPlan);
        }
        return plans;
    }

    private Collection<IPlan> getAllChildPlans(ISection section) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>();
        plans.addAll(this.getAllDirectChildPlans(section));
        for (ISection iSection : this.projectAgent.getFrameSectionManager().getChildSections(section)) {
            plans.addAll(this.getAllChildPlans(iSection));
        }
        return plans;
    }

    private Collection<ISection> getAllDirectChildSections(ISection section) {
        ArrayList<ISection> sections = new ArrayList<ISection>();
        for (ISection iSection : this.projectAgent.getFrameSectionManager().getChildSections(section)) {
            if (this.projectAgent.getFrameSectionManager().getAllPlansUnderSection(iSection).isEmpty()) continue;
            sections.add(iSection);
        }
        return sections;
    }

    private Collection<ISection> getAllChildSections(ISection section) {
        ArrayList<ISection> sections = new ArrayList<ISection>();
        sections.addAll(this.getAllDirectChildSections(section));
        for (ISection iSection : this.projectAgent.getFrameSectionManager().getChildSections(section)) {
            sections.addAll(this.getAllChildSections(iSection));
        }
        return sections;
    }

    private static String getLegalName(String planOrDirName) {
        return FileHelper.convertStringToPortableFileName((String)planOrDirName);
    }

    public boolean isNameLegal(String elementName) {
        boolean ok = false;
        String legalName = ExportPlanWizard.getLegalName(elementName);
        if (legalName.equals(elementName)) {
            ok = true;
        }
        return ok;
    }

    private String getDirectoryName(ISection section) {
        String directoryName = ExportPlanWizard.getLegalName(section.getSectionName());
        if (this.directoriesToExport.containsKey(section)) {
            directoryName = this.directoriesToExport.get(section);
        } else if (this.notExportedDirectories.containsKey(section)) {
            directoryName = this.notExportedDirectories.get(section);
        }
        return directoryName;
    }

    private String getPlanName(IPlan plan) {
        String planName = ExportPlanWizard.getLegalName(plan.getPlanName());
        if (this.plansToExport.containsKey(plan)) {
            planName = this.plansToExport.get(plan);
        } else if (this.notExportedPlans.containsKey(plan)) {
            planName = this.notExportedPlans.get(plan);
        }
        return planName;
    }

    private String getFileNameAndExtension(IPlan planFile, String planName) {
        String fileExtension;
        String fileName = planName;
        if (fileName == null) {
            fileName = planFile.getPlanName();
            if (this.notExportedPlans.containsKey(planFile)) {
                fileName = this.notExportedPlans.get(planFile);
            }
            if (this.plansToExport.containsKey(planFile)) {
                fileName = this.plansToExport.get(planFile);
            }
        }
        if (!fileName.endsWith("." + (fileExtension = ExportPlanWizard.getFileExtension(planFile)))) {
            fileName = String.valueOf(fileName) + "." + fileExtension;
        }
        return fileName;
    }

    private static String getFileExtension(IPlan planFile) {
        String fileExtension = null;
        try {
            PlanTypeDescription td = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(planFile.getPlantypeUID());
            fileExtension = td.getFileExtension();
        }
        catch (EXPlanTypeUnknown ex) {
            fileExtension = "xml";
        }
        return fileExtension;
    }

    private static String getRealFileName(String pathName, String filename) {
        String resultingFilename = de.plans.lib.util.FileHelper.getFileName((String)filename).equals(filename) ? String.valueOf(pathName) + File.separator + filename : filename;
        return resultingFilename;
    }

    private String getTargetPathName(String rootPath, ISection exportSection, ISection section) {
        ISection currentSection = section;
        String newName = "";
        if (currentSection.equals(exportSection) || currentSection.equals(this.projectAgent.getSectionManager().getRootSection())) {
            return rootPath;
        }
        ISection parentSection = this.projectAgent.getSectionManager().getSection(currentSection.getParentUID());
        while (!currentSection.equals(exportSection)) {
            newName = String.valueOf(this.getDirectoryName(currentSection)) + File.separator + newName;
            currentSection = parentSection;
            if (parentSection.equals(this.projectAgent.getSectionManager().getRootSection())) break;
            parentSection = this.projectAgent.getSectionManager().getSection(currentSection.getParentUID());
        }
        return String.valueOf(rootPath) + File.separator + newName;
    }

    private void init(Collection<IPlan> plans, Collection<ISection> sections) {
        this.exportElements = new ArrayList<Object>();
        for (IPlan plan : plans) {
            if (!this.isPlanExportable(plan)) continue;
            this.exportElements.add(plan);
        }
        for (ISection section : sections) {
            this.exportElements.add(section);
        }
        this.addPages();
    }

    private boolean isPlanExportable(IPlan plan) {
        boolean ok = false;
        try {
            this.projectAgent.getPlanImporterExporterManager().checkPlanAgentAvailability(plan.getPlantypeUID());
            ok = true;
        }
        catch (EXPlanAgentTypeUnknown eXPlanAgentTypeUnknown) {
        }
        catch (EXPlanAgentExtensionTypeUnknown eXPlanAgentExtensionTypeUnknown) {
        }
        catch (EXPlanTypeNotSupported eXPlanTypeNotSupported) {
        }
        catch (EXPlanTypeUnknown eXPlanTypeUnknown) {
            // empty catch block
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean savePlanFile(IPlan plan, String destinationPath) {
        boolean ok = false;
        ControllerExtensionContainer cec = new ControllerExtensionContainer();
        try {
            cec.setControllerExtension(this.projectAgent.getPlanImporterExporterManager().getExporter(plan, IProgressDisplay.DUMMY));
        }
        catch (PlanAgentManager.EXPlanAgentLaunchException e) {
            cec.setErrorMessage(e.getLocalizedMessage());
            logger.error("Could not save plan to be exported.", (Throwable)e);
            assert (false);
            return false;
        }
        catch (EXWriteAccessDeniedException e) {
            cec.setErrorMessage(e.getLocalizedMessage());
            logger.error("Could not save plan to be exported.", (Throwable)e);
            assert (false);
            return false;
        }
        IExternalPlanImporterExporterControllerExtension ctrl = cec.getControllerExtension();
        File original = ctrl.getPlanFile();
        File copy = new File(destinationPath);
        try {
            try {
                copy.getCanonicalPath();
                DataCopyHelper.copyFile((File)original, (File)copy);
                if (copy.exists()) {
                    FileHelper.deleteExistingFileOrDirectory((File)copy);
                }
                ok = true;
                return ok;
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.warn("didn't succeed in copying or deleting file: " + copy.toString());
                ok = false;
                if (cec.getControllerExtension() == null) return ok;
                cec.getControllerExtension().close();
                return ok;
            }
            catch (IOException e) {
                ok = false;
                if (cec.getControllerExtension() == null) return ok;
                cec.getControllerExtension().close();
                return ok;
            }
        }
        finally {
            if (cec.getControllerExtension() != null) {
                cec.getControllerExtension().close();
            }
        }
    }

    private static IArcwayMemento getOrCreateMementoChild(IArcwayMemento memento, String child) {
        IArcwayMemento mementoChild = memento.getChild(child);
        if (mementoChild == null) {
            mementoChild = memento.createChild(child);
        }
        return mementoChild;
    }

    static /* synthetic */ ILogger access$20() {
        return logger;
    }

    static /* synthetic */ boolean access$21(ExportPlanWizard exportPlanWizard, IPlan iPlan, String string) {
        return exportPlanWizard.savePlanFile(iPlan, string);
    }

    private static class ControllerExtensionContainer {
        private IExternalPlanImporterExporterControllerExtension ctrl;
        private String errorMessage;

        private ControllerExtensionContainer() {
        }

        public IExternalPlanImporterExporterControllerExtension getControllerExtension() {
            return this.ctrl;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setControllerExtension(IExternalPlanImporterExporterControllerExtension ctrl) {
            this.ctrl = ctrl;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    private class ExportPlanPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener,
    ICheckStateListener,
    ISelectionChangedListener {
        public static final String pageId = "com.arcway.cockpit.frame.client.project.datainterchange.plan.ExportPlanWizard.ExportPlanPage";
        private UsableCheckboxTreeViewer treeViewer;
        private Text txtFileName;
        private Text txtPathName;
        private int oldNumberOfCheckedRootElements;
        private String previouslySelectedPath;
        private static final String SETTING_PREVIOUS_PATH = "previouslySelectedPath";

        ExportPlanPage() {
            super(name);
            this.oldNumberOfCheckedRootElements = 0;
        }

        public void createControl(Composite parent) {
            this.setTitle(Messages.getString("ExportPlanWizard.1"));
            this.setMessage(Messages.getString("ExportPlanWizard.11"));
            ExportPlanWizard.this.setWindowTitle(Messages.getString("ExportPlanWizard.17"));
            this.setImageDescriptor(Icons.getImageDescriptorForBigExportLogo());
            Composite base = new Composite(parent, 0);
            base.setLayoutData((Object)new GridData(1040));
            base.setLayout((Layout)new GridLayout(1, true));
            Composite upperBase = new Composite(base, 0);
            upperBase.setLayoutData((Object)new GridData(1808));
            upperBase.setLayout((Layout)new GridLayout(2, true));
            Composite leftBase = new Composite(upperBase, 0);
            leftBase.setLayoutData((Object)new GridData(1808));
            leftBase.setLayout((Layout)new GridLayout(1, false));
            this.createLeftGroup(leftBase);
            Composite rightBase = new Composite(upperBase, 0);
            rightBase.setLayoutData((Object)new GridData(1808));
            rightBase.setLayout((Layout)new GridLayout(1, false));
            this.createRightGroup(rightBase);
            Composite lowerBase = new Composite(base, 0);
            lowerBase.setLayoutData((Object)new GridData(768));
            lowerBase.setLayout((Layout)new GridLayout(1, true));
            this.createLowerGroup(lowerBase);
            this.setControl((Control)base);
            if (ExportPlanWizard.this.exportElements.size() == 2) {
                for (Object object : ExportPlanWizard.this.exportElements) {
                    if (!(object instanceof IPlan)) continue;
                    IPlan plan = (IPlan)object;
                    this.treeViewer.setAllChecked(true);
                    this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.treeViewer, (Object)plan, true));
                }
            }
            this.updatePageComplete();
        }

        public String getPathName() {
            return this.txtPathName.getText().trim();
        }

        private ISection getParentSection(ISection section) {
            ISection parentSection = null;
            parentSection = ExportPlanWizard.this.projectAgent.getSectionManager().getParentSection(section);
            if (parentSection == null || parentSection.equals(ExportPlanWizard.this.exportedSection)) {
                return section;
            }
            return this.getParentSection(parentSection);
        }

        private void checkExportValidity(Object element) {
            ISection parentSection = null;
            if (element instanceof IPlan) {
                parentSection = ExportPlanWizard.this.projectAgent.getSectionManager().getParentSection((IPlan)element);
                if (parentSection == null || parentSection.equals(ExportPlanWizard.this.exportedSection)) {
                    this.checkPlanExportValidity((IPlan)element);
                } else {
                    parentSection = this.getParentSection(parentSection);
                    this.checkDirectoryExportValidity(parentSection);
                }
            } else if (element instanceof ISection) {
                parentSection = this.getParentSection((ISection)element);
                this.checkDirectoryExportValidity(parentSection);
            }
            this.updatePageComplete();
        }

        private void checkPlanExportValidity(IPlan plan) {
            if (!this.isFileExportable(plan) || !this.isNameValid(plan)) {
                ExportPlanWizard.this.removePlanFromExportList(plan, plan.getPlanName());
            } else if (ExportPlanWizard.this.notExportedPlans.containsKey(plan)) {
                ExportPlanWizard.this.addPlanToExportList(plan, (String)ExportPlanWizard.this.notExportedPlans.get(plan));
                ExportPlanWizard.this.notExportedPlans.remove(plan);
            } else {
                ExportPlanWizard.this.addPlanToExportList(plan, ExportPlanWizard.this.getFileNameAndExtension(plan, null));
            }
        }

        private void checkDirectoryExportValidity(ISection directory) {
            if (this.treeViewer.getChecked((Object)directory)) {
                this.checkExistence(directory);
                if (!this.isNameValid(directory)) {
                    ExportPlanWizard.this.removeDirectoryFromExportList(directory, directory.getSectionName());
                } else {
                    if (ExportPlanWizard.this.notExportedDirectories.containsKey(directory)) {
                        ExportPlanWizard.this.addDirectoryToExportList(directory, (String)ExportPlanWizard.this.notExportedDirectories.get(directory));
                        ExportPlanWizard.this.notExportedDirectories.remove(directory);
                    } else if (!ExportPlanWizard.this.directoriesToExport.containsKey(directory)) {
                        ExportPlanWizard.this.addDirectoryToExportList(directory, directory.getSectionName());
                    }
                    for (ISection childSection : ExportPlanWizard.this.getAllDirectChildSections(directory)) {
                        this.checkDirectoryExportValidity(childSection);
                    }
                    for (IPlan childPlans : ExportPlanWizard.this.getAllDirectChildPlans(directory)) {
                        this.checkPlanExportValidity(childPlans);
                    }
                }
            }
        }

        private void checkOverallExportValidity() {
            ExportPlanWizard.this.existingFiles = new HashSet();
            ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(this.treeViewer.getCheckedElements()));
            for (Object e : checkedElements) {
                if (e instanceof IPlan) {
                    this.checkPlanExportValidity((IPlan)e);
                }
                if (!(e instanceof ISection)) continue;
                ISection planDirectory = (ISection)e;
                this.checkExistence(planDirectory);
                if (!this.isNameValid(e)) {
                    ExportPlanWizard.this.removeDirectoryFromExportList(planDirectory, planDirectory.getSectionName());
                    continue;
                }
                if (ExportPlanWizard.this.notExportedDirectories.containsKey(planDirectory)) {
                    ExportPlanWizard.this.addDirectoryToExportList(planDirectory, (String)ExportPlanWizard.this.notExportedDirectories.get(planDirectory));
                    ExportPlanWizard.this.notExportedDirectories.remove(planDirectory);
                    continue;
                }
                if (ExportPlanWizard.this.directoriesToExport.containsKey(planDirectory)) continue;
                ExportPlanWizard.this.addDirectoryToExportList(planDirectory, planDirectory.getSectionName());
            }
            this.updateMessageAndCleanMaps();
        }

        private void updateMessageAndCleanMaps() {
            for (IPlan plan : new ArrayList(ExportPlanWizard.this.notExportedPlans.keySet())) {
                if (this.treeViewer.getChecked((Object)plan)) continue;
                ExportPlanWizard.this.notExportedPlans.remove(plan);
            }
            for (ISection section : new ArrayList(ExportPlanWizard.this.notExportedDirectories.keySet())) {
                if (this.treeViewer.getChecked((Object)section)) continue;
                ExportPlanWizard.this.notExportedDirectories.remove(section);
            }
            ArrayList<Object> notExportedElements = new ArrayList<Object>();
            notExportedElements.addAll(ExportPlanWizard.this.notExportedPlans.keySet());
            notExportedElements.addAll(ExportPlanWizard.this.notExportedDirectories.keySet());
            if (!notExportedElements.isEmpty()) {
                this.reportExportErrorMessage(notExportedElements);
                this.markEntries(this.treeViewer.getTree().getItems(), notExportedElements);
            } else if (!ExportPlanWizard.this.existingFiles.isEmpty()) {
                this.reportExistingFilesMessage(ExportPlanWizard.this.existingFiles);
            } else {
                this.clearErrorMessage();
            }
            this.updatePageComplete();
        }

        private void choosePath() {
            FileChooserDialog dialog;
            File path;
            String startPath = this.getPathName();
            File startPathFile = null;
            if (startPath.length() > 0) {
                startPathFile = new File(startPath);
            }
            if ((path = (dialog = new FileChooserDialog(startPathFile, this.getShell())).openForLoad()) != null) {
                this.txtPathName.setText(path.getAbsolutePath());
                this.updatePageComplete();
            }
        }

        private void clearErrorMessage() {
            this.setMessage(Messages.getString("ExportPlanWizard.11"));
            this.markEntries(this.treeViewer.getTree().getItems(), new ArrayList<Object>());
        }

        private void createLeftGroup(Composite base) {
            Group leftSide = new Group(base, 0);
            leftSide.setLayoutData((Object)new GridData(1808));
            leftSide.setLayout((Layout)new GridLayout(1, false));
            leftSide.setText(Messages.getString("ExportPlanWizard.9"));
            GridData leftSideGroupGridData = new GridData(1808);
            leftSide.setLayoutData((Object)leftSideGroupGridData);
            leftSide.setLayout((Layout)new GridLayout(1, false));
            this.treeViewer = new UsableCheckboxTreeViewer((Composite)leftSide);
            this.treeViewer.activateSelectionContextMenu();
            this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
            ProjectTreeContentProvider cp = new ProjectTreeContentProvider(null);
            this.treeViewer.setContentProvider((IContentProvider)cp);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)cp);
            this.treeViewer.setInput((Object)ExportPlanWizard.this.exportedSection);
            this.treeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return ExportPlanWizard.this.exportElements.contains(element);
                }
            });
            this.treeViewer.expandAll();
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        }

        private void createLowerGroup(Composite base) {
            Group lowerSide = new Group(base, 0);
            lowerSide.setLayoutData((Object)new GridData(1808));
            lowerSide.setLayout((Layout)new GridLayout(2, false));
            lowerSide.setText(Messages.getString("ExportPlanWizard.10"));
            this.txtPathName = new Text((Composite)lowerSide, 2052);
            this.txtPathName.setEditable(false);
            this.txtPathName.setLayoutData((Object)new GridData(768));
            if (this.previouslySelectedPath != null && !ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled")) {
                this.txtPathName.setText(this.previouslySelectedPath);
            }
            Button btnSelectPath = new Button((Composite)lowerSide, 0);
            btnSelectPath.setImage(Icons.getImageForFileFolder());
            btnSelectPath.setToolTipText(Messages.getString("ExportPlanWizard.12"));
            btnSelectPath.addSelectionListener((SelectionListener)this);
        }

        private void createRightGroup(Composite base) {
            Group rightSide = new Group(base, 0);
            rightSide.setLayoutData((Object)new GridData(1808));
            rightSide.setLayout((Layout)new GridLayout(1, false));
            rightSide.setText(Messages.getString("ExportPlanWizard.13"));
            this.txtFileName = new Text((Composite)rightSide, 2052);
            this.txtFileName.setEnabled(false);
            this.txtFileName.setLayoutData((Object)new GridData(768));
            this.txtFileName.setText("");
            this.txtFileName.addModifyListener((ModifyListener)this);
        }

        private boolean checkExistence(ISection section) {
            boolean ok = false;
            String newPathName = ExportPlanWizard.this.page.getPathName();
            String pathName = ExportPlanWizard.this.getTargetPathName(newPathName, ExportPlanWizard.this.exportedSection, section);
            String diffString = pathName.substring(newPathName.length());
            String seperator = "\\\\|/";
            String[] sp = diffString.split(seperator);
            List<String> splittedString = Arrays.asList(sp);
            for (String str : splittedString) {
                File newDirectory;
                if (str.equals("")) continue;
                if (!newPathName.endsWith(File.separator)) {
                    newPathName = newPathName.concat(File.separator);
                }
                if ((newDirectory = new File(newPathName = String.valueOf(newPathName) + str)).exists()) {
                    ExportPlanWizard.this.existingFiles.add(section);
                    continue;
                }
                ExportPlanWizard.this.existingFiles.remove(section);
            }
            return ok;
        }

        private boolean isFileExportable(IPlan planFile) {
            boolean ok = false;
            String targetPathName = ExportPlanWizard.this.getTargetPathName(ExportPlanWizard.this.page.getPathName(), ExportPlanWizard.this.exportedSection, ExportPlanWizard.this.projectAgent.getSectionManager().getParentSection(planFile));
            String diffString = targetPathName.substring(ExportPlanWizard.this.page.getPathName().length());
            ok = this.noFileUnderSubDirectory(planFile, ExportPlanWizard.this.page.getPathName(), targetPathName, diffString);
            return ok;
        }

        private boolean isNameValid(Object element) {
            boolean ok;
            block5: {
                block6: {
                    ok = true;
                    if (!(element instanceof IPlan)) break block6;
                    IPlan plan = (IPlan)element;
                    String comparedName = ExportPlanWizard.this.getFileNameAndExtension(plan, null);
                    ISection parentSection = ExportPlanWizard.this.projectAgent.getSectionManager().getSection(plan.getSectionUID());
                    for (IPlan iPlan : ExportPlanWizard.this.projectAgent.getFrameSectionManager().getChildPlans(parentSection)) {
                        String planName;
                        if (plan == iPlan || !ExportPlanWizard.this.plansToExport.containsKey(iPlan) || !comparedName.equals(planName = (String)ExportPlanWizard.this.plansToExport.get(iPlan))) continue;
                        ok = false;
                        break;
                    }
                    for (ISection iSection : ExportPlanWizard.this.projectAgent.getFrameSectionManager().getChildSections(parentSection)) {
                        String sectionName;
                        if (!ExportPlanWizard.this.directoriesToExport.containsKey(iSection) || !comparedName.equals(sectionName = (String)ExportPlanWizard.this.directoriesToExport.get(iSection))) continue;
                        ok = false;
                        break block5;
                    }
                    break block5;
                }
                if (!(element instanceof ISection)) break block5;
                ISection section = (ISection)element;
                String comparedName = ExportPlanWizard.getLegalName(section.getSectionName());
                if (ExportPlanWizard.this.directoriesToExport.containsKey(section)) {
                    comparedName = (String)ExportPlanWizard.this.directoriesToExport.get(section);
                }
                ISection parentSection = ExportPlanWizard.this.projectAgent.getSectionManager().getSection(section.getParentUID());
                for (ISection iSection : ExportPlanWizard.this.projectAgent.getFrameSectionManager().getChildSections(parentSection)) {
                    String sectionName;
                    if (section == iSection || !ExportPlanWizard.this.directoriesToExport.containsKey(iSection) || !comparedName.equals(sectionName = (String)ExportPlanWizard.this.directoriesToExport.get(iSection))) continue;
                    ok = false;
                    return ok;
                }
                for (IPlan iPlan : ExportPlanWizard.this.projectAgent.getFrameSectionManager().getChildPlans(parentSection)) {
                    String planName;
                    if (!ExportPlanWizard.this.plansToExport.containsKey(iPlan) || !comparedName.equals(planName = (String)ExportPlanWizard.this.plansToExport.get(iPlan))) continue;
                    ok = false;
                    return ok;
                }
            }
            return ok;
        }

        private void markEntries(TreeItem[] items, Collection<Object> plansWithError) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (plansWithError.contains(item.getData())) {
                    item.setForeground(Display.getDefault().getSystemColor(3));
                } else {
                    item.setForeground(this.treeViewer.getTree().getForeground());
                }
                this.markEntries(item.getItems(), plansWithError);
                ++n2;
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean noFileUnderSubDirectory(IPlan planFile, String pathString, String targetFileString, String diffString) {
            seperator = "\\\\|/";
            splittedString = diffString.split(seperator);
            newPathName = pathString;
            var11_8 = splittedString;
            var10_9 = splittedString.length;
            var9_10 = 0;
            while (var9_10 < var10_9) {
                block15: {
                    str = var11_8[var9_10];
                    if (str.equals("")) break block15;
                    if (!newPathName.endsWith(File.separator)) {
                        newPathName = newPathName.concat(File.separator);
                    }
                    if ((newDirectory = new File(pName = String.valueOf(newPathName) + str)).exists()) ** GOTO lbl31
                    if (newDirectory.mkdirs()) {
                        newPathName = pName;
                    } else {
                        dirStr = targetFileString;
                        comparedStr = ExportPlanWizard.access$16(ExportPlanWizard.this).getPathName();
                        if (!comparedStr.endsWith(File.separator)) {
                            comparedStr = comparedStr.concat(File.separator);
                        }
                        while (dirStr.compareTo(comparedStr) > 0) {
                            directory = new File(dirStr);
                            if (directory.exists()) {
                                try {
                                    FileHelper.deleteExistingFileOrDirectory((File)directory);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    ExportPlanWizard.access$20().warn("Didn't succeed in deleting directory: " + directory.toString());
                                }
                            }
                            dirStr = dirStr.lastIndexOf(File.separator) >= 0 ? dirStr.substring(0, dirStr.lastIndexOf(File.separator)) : "";
                        }
                        return false;
lbl31:
                        // 1 sources

                        newPathName = pName;
                    }
                }
                ++var9_10;
            }
            fileString = targetFileString;
            fileString = fileString.endsWith(File.separator) != false ? String.valueOf(fileString) + ExportPlanWizard.access$7(ExportPlanWizard.this, planFile, null) : String.valueOf(fileString) + File.separator + ExportPlanWizard.access$7(ExportPlanWizard.this, planFile, null);
            file = new File(fileString);
            if (!file.exists()) {
                savedPlanFile = ExportPlanWizard.access$21(ExportPlanWizard.this, planFile, fileString);
                dirStr = targetFileString;
                comparedStr = ExportPlanWizard.access$16(ExportPlanWizard.this).getPathName();
                if (!comparedStr.endsWith(File.separator)) {
                    comparedStr = comparedStr.concat(File.separator);
                }
                while (dirStr.compareTo(comparedStr) > 0) {
                    directory = new File(dirStr);
                    if (directory.exists()) {
                        try {
                            FileHelper.deleteExistingFileOrDirectory((File)directory);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            ExportPlanWizard.access$20().warn("Didn't succeed in deleting directory: " + directory.toString());
                        }
                    }
                    dirStr = dirStr.lastIndexOf(File.separator) >= 0 ? dirStr.substring(0, dirStr.lastIndexOf(File.separator)) : "";
                }
                ExportPlanWizard.access$15(ExportPlanWizard.this).remove(planFile);
                return savedPlanFile;
            }
            ExportPlanWizard.access$15(ExportPlanWizard.this).add(planFile);
            return true;
        }

        private void reportExportErrorMessage(Collection<Object> reportedElements) {
            String notExportedElementsNames = "";
            String errorMessage = "";
            Iterator<Object> it = reportedElements.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof IPlan) {
                    IPlan plan = (IPlan)object;
                    notExportedElementsNames = String.valueOf(notExportedElementsNames) + plan.getPlanName();
                }
                if (object instanceof ISection) {
                    ISection section = (ISection)object;
                    notExportedElementsNames = String.valueOf(notExportedElementsNames) + section.getSectionName();
                }
                if (!it.hasNext()) continue;
                notExportedElementsNames = String.valueOf(notExportedElementsNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + NLS.bind((String)Messages.getString("ExportPlanWizard.nameNotValid", Locale.getDefault()), (Object)notExportedElementsNames);
            this.setMessage(errorMessage, 3);
        }

        private void reportExistingFilesMessage(Collection<Object> reportedElements) {
            String notExportedElementsNames = "";
            String errorMessage = "";
            Iterator<Object> it = reportedElements.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof IPlan) {
                    IPlan plan = (IPlan)object;
                    notExportedElementsNames = String.valueOf(notExportedElementsNames) + plan.getPlanName();
                }
                if (object instanceof ISection) {
                    ISection section = (ISection)object;
                    notExportedElementsNames = String.valueOf(notExportedElementsNames) + section.getSectionName();
                }
                if (!it.hasNext()) continue;
                notExportedElementsNames = String.valueOf(notExportedElementsNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + NLS.bind((String)Messages.getString("ExportPlanWizard.objectsExist", Locale.getDefault()), (Object)notExportedElementsNames);
            this.setMessage(errorMessage, 2);
        }

        public void modifyText(ModifyEvent e) {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            if (selection.size() == 1) {
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof IPlan) {
                    IPlan plan = (IPlan)selectedObject;
                    String fileName = this.txtFileName.getText().trim();
                    if (ExportPlanWizard.this.isNameLegal(fileName)) {
                        fileName = ExportPlanWizard.this.getFileNameAndExtension(plan, fileName);
                        ExportPlanWizard.this.addPlanToExportList(plan, fileName);
                        this.txtFileName.removeModifyListener((ModifyListener)this);
                        this.txtFileName.setText(fileName);
                        this.txtFileName.setSelection(fileName.lastIndexOf("."));
                        this.txtFileName.addModifyListener((ModifyListener)this);
                    } else {
                        String fileExtension = ExportPlanWizard.getFileExtension(plan);
                        if (!fileName.endsWith(fileExtension)) {
                            fileName = String.valueOf(fileName) + "." + fileExtension;
                        }
                        ExportPlanWizard.this.removePlanFromExportList(plan, fileName);
                    }
                }
                if (selectedObject instanceof ISection) {
                    Collection plans;
                    ISection section = (ISection)selectedObject;
                    String directoryName = this.txtFileName.getText().trim();
                    if (ExportPlanWizard.this.isNameLegal(directoryName)) {
                        ExportPlanWizard.this.addDirectoryToExportList(section, directoryName);
                        plans = ExportPlanWizard.this.getAllChildPlans(section);
                        for (IPlan plan : plans) {
                            ExportPlanWizard.this.addPlanToExportList(plan, plan.getPlanName());
                        }
                        Collection sections = ExportPlanWizard.this.getAllChildSections(section);
                        for (ISection childSection : sections) {
                            ExportPlanWizard.this.addDirectoryToExportList(childSection, childSection.getSectionName());
                        }
                    } else {
                        ExportPlanWizard.this.removeDirectoryFromExportList(section, directoryName);
                        plans = ExportPlanWizard.this.getAllChildPlans(section);
                        for (IPlan plan : plans) {
                            if (!ExportPlanWizard.this.plansToExport.containsKey(plan)) continue;
                            ExportPlanWizard.this.removePlanFromExportList(plan, (String)ExportPlanWizard.this.plansToExport.get(plan));
                        }
                        Collection sections = ExportPlanWizard.this.getAllChildSections(section);
                        for (Object childSection : sections) {
                            if (!ExportPlanWizard.this.directoriesToExport.containsKey(childSection)) continue;
                            ExportPlanWizard.this.removeDirectoryFromExportList((ISection)childSection, childSection.getSectionName());
                        }
                    }
                }
                this.checkExportValidity(selection.getFirstElement());
                this.updateMessageAndCleanMaps();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.choosePath();
            this.checkOverallExportValidity();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element;
            if (this.oldNumberOfCheckedRootElements == 0) {
                ArrayList children = new ArrayList();
                children.addAll(ExportPlanWizard.this.getAllDirectChildSections(ExportPlanWizard.this.exportedSection));
                if (children.size() < 2) {
                    children.addAll(ExportPlanWizard.this.getAllDirectChildPlans(ExportPlanWizard.this.exportedSection));
                }
                if (children.size() > 2 && this.treeViewer.getChecked(children.get(0)) && this.treeViewer.getChecked(children.get(1))) {
                    this.checkOverallExportValidity();
                    this.updateMessageAndCleanMaps();
                    this.treeViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
                    this.oldNumberOfCheckedRootElements = 1;
                    return;
                }
            }
            if ((element = event.getElement()) instanceof ISection) {
                ISection section = (ISection)element;
                if (event.getChecked()) {
                    ExportPlanWizard.this.addDirectoryToExportList(section, section.getSectionName());
                    Collection plans = ExportPlanWizard.this.getAllChildPlans(section);
                    for (IPlan plan : plans) {
                        ExportPlanWizard.this.addPlanToExportList(plan, ExportPlanWizard.this.getFileNameAndExtension(plan, null));
                    }
                    Collection sections = ExportPlanWizard.this.getAllChildSections(section);
                    for (ISection childSection : sections) {
                        ExportPlanWizard.this.addDirectoryToExportList(childSection, childSection.getSectionName());
                    }
                } else {
                    ExportPlanWizard.this.removeDirectoryFromExportList(section, section.getSectionName());
                    if (ExportPlanWizard.this.notExportedDirectories.containsKey(section)) {
                        ExportPlanWizard.this.notExportedDirectories.remove(section);
                    }
                    Collection plans = ExportPlanWizard.this.getAllChildPlans(section);
                    for (IPlan plan : plans) {
                        if (ExportPlanWizard.this.plansToExport.containsKey(plan)) {
                            ExportPlanWizard.this.removePlanFromExportList(plan, (String)ExportPlanWizard.this.plansToExport.get(plan));
                        }
                        if (!ExportPlanWizard.this.notExportedPlans.containsKey(plan)) continue;
                        ExportPlanWizard.this.notExportedPlans.remove(plan);
                    }
                    Collection sections = ExportPlanWizard.this.getAllChildSections(section);
                    for (Object childSection : sections) {
                        if (!ExportPlanWizard.this.directoriesToExport.containsKey(childSection)) continue;
                        ExportPlanWizard.this.removeDirectoryFromExportList((ISection)childSection, childSection.getSectionName());
                        if (!ExportPlanWizard.this.notExportedDirectories.containsKey(childSection)) continue;
                        ExportPlanWizard.this.notExportedDirectories.remove(childSection);
                    }
                }
            } else if (element instanceof IPlan) {
                IPlan plan = (IPlan)element;
                if (event.getChecked()) {
                    ExportPlanWizard.this.addPlanToExportList(plan, ExportPlanWizard.this.getFileNameAndExtension(plan, null));
                } else {
                    ExportPlanWizard.this.removePlanFromExportList(plan, plan.getPlanName());
                }
            }
            this.checkExportValidity(element);
            this.updateMessageAndCleanMaps();
            this.updatePageComplete();
            this.treeViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            if (selection.size() == 1) {
                this.txtFileName.removeModifyListener((ModifyListener)this);
                if (selection.getFirstElement() instanceof IPlan) {
                    IPlan plan = (IPlan)selection.getFirstElement();
                    if (this.treeViewer.getChecked((Object)plan)) {
                        this.txtFileName.setEnabled(true);
                        String fileName = ExportPlanWizard.this.getPlanName(plan);
                        if (ExportPlanWizard.this.notExportedPlans.containsKey(plan)) {
                            fileName = (String)ExportPlanWizard.this.notExportedPlans.get(plan);
                        }
                        if (!this.txtFileName.getText().equals(fileName)) {
                            this.txtFileName.setText(fileName);
                            this.txtFileName.setSelection(fileName.lastIndexOf("."));
                        }
                    } else {
                        this.txtFileName.setText(plan.getPlanName());
                        this.txtFileName.setEnabled(false);
                        if (ExportPlanWizard.this.notExportedPlans.containsKey(plan)) {
                            ExportPlanWizard.this.notExportedPlans.remove(plan);
                        }
                    }
                }
                if (selection.getFirstElement() instanceof ISection) {
                    ISection section = (ISection)selection.getFirstElement();
                    if (this.treeViewer.getChecked((Object)section)) {
                        this.txtFileName.setEnabled(true);
                        String directoryName = ExportPlanWizard.this.getDirectoryName(section);
                        if (ExportPlanWizard.this.notExportedDirectories.containsKey(section)) {
                            directoryName = (String)ExportPlanWizard.this.notExportedDirectories.get(section);
                        }
                        if (!this.txtFileName.getText().equals(directoryName)) {
                            this.txtFileName.setText(directoryName);
                        }
                    } else {
                        this.txtFileName.setText(section.getSectionName());
                        this.txtFileName.setEnabled(false);
                        if (ExportPlanWizard.this.notExportedDirectories.containsKey(section)) {
                            ExportPlanWizard.this.notExportedDirectories.remove(section);
                        }
                    }
                }
                this.txtFileName.addModifyListener((ModifyListener)this);
            } else {
                this.txtFileName.setEnabled(false);
            }
            if (this.treeViewer.getCheckedElements().length == 0) {
                this.oldNumberOfCheckedRootElements = 0;
                ExportPlanWizard.this.notExportedDirectories.clear();
                ExportPlanWizard.this.plansToExport.clear();
                ExportPlanWizard.this.notExportedPlans.clear();
                this.clearErrorMessage();
            }
            this.updatePageComplete();
        }

        public String getPageId() {
            return pageId;
        }

        private void updatePageComplete() {
            boolean isComplete = true;
            isComplete &= !ExportPlanWizard.this.plansToExport.isEmpty();
            File chosenDirectory = new File(this.txtPathName.getText());
            chosenDirectory.isAbsolute();
            this.setPageComplete(isComplete &= chosenDirectory.isAbsolute() && chosenDirectory.isDirectory());
        }

        private void readSettings(IArcwayMemento memento) {
            this.previouslySelectedPath = memento.getString(SETTING_PREVIOUS_PATH);
        }

        private void saveSettings(IArcwayMemento memento) {
            memento.putString(SETTING_PREVIOUS_PATH, this.getPathName());
        }
    }
}

