/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.PropertiesDialog;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeValueModifiedListener;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AttributeTypesComposite
implements IObjectTypeCategoryChangeListener {
    private static final ILogger logger = Logger.getLogger(AttributeTypesComposite.class);
    public static final Object ADDITIONALINFORMATION_FOR_UNMODIFIEDATTRIBUTE = new Object();
    private Composite base;
    private boolean createdOwnBase = true;
    private IAttributeOwner owner;
    private final Map<IAttributeTypeID, ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean>> attributeTypeID_control_map = new HashMap<IAttributeTypeID, ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean>>();
    private final Map<IAttributeType, Tuple<IAttribute, Object>> modifiedTypes = new HashMap<IAttributeType, Tuple<IAttribute, Object>>();
    private Composite parent;
    private boolean hasContents = false;
    private final Collection<IModificationProblem> initialModificationProblems = new ArrayList<IModificationProblem>();
    private final Collection<IAttributeType> attributeTypesToShow;
    private boolean isCreationDialogue;
    private ILocksAndPermissionsTransactionController transactionController;
    private IPropertiesDialog dialog;
    private IPropertiesListEntry caller;
    private final Map<IAttributeTypeID, IAttributeValueModifiedListener> modListeners = new HashMap<IAttributeTypeID, IAttributeValueModifiedListener>();
    private boolean isModified = false;
    private final Map<IAttributeType, IModificationProblem> modificationsInProgress = new HashMap<IAttributeType, IModificationProblem>();
    private Label noAttributesToShow;

    public AttributeTypesComposite(IAttributeOwner attributeOwner, Composite parent, boolean fixedAttributeTypes, boolean userDefinedAttributeTypes, boolean isCreationDialogue, IPropertiesDialog dialog, IPropertiesListEntry caller) {
        this.attributeTypesToShow = new ArrayList<IAttributeType>();
        for (IAttribute attribute : attributeOwner.getAllAttributes()) {
            IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
            if (!attributeType.isEditableByUser() || (!fixedAttributeTypes || attributeType.isUserDefined()) && (!userDefinedAttributeTypes || !attributeType.isUserDefined())) continue;
            this.attributeTypesToShow.add(attributeType);
        }
        this.init(attributeOwner, parent, isCreationDialogue, dialog, caller);
    }

    public AttributeTypesComposite(IAttributeOwner attributeOwner, Composite parent, Collection<IAttributeType> attributeTypesToShow, boolean isCreationDialogue, IPropertiesDialog dialog, IPropertiesListEntry caller) {
        this.attributeTypesToShow = attributeTypesToShow;
        this.init(attributeOwner, parent, isCreationDialogue, dialog, caller);
    }

    private void init(IAttributeOwner attributeOwner, Composite newParent, boolean isCreationDialogue_, IPropertiesDialog newDialog, IPropertiesListEntry newCaller) {
        assert (newCaller != null);
        this.parent = newParent;
        this.owner = attributeOwner;
        this.isCreationDialogue = isCreationDialogue_;
        this.caller = newCaller;
        this.dialog = newDialog;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID());
        this.transactionController = new LocksAndPermissionsTransactionController(projectAgent);
        for (IAttribute attribute : attributeOwner.getAllAttributes()) {
            try {
                IAttributeType type = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
                if (!this.attributeTypesToShow.contains(type)) continue;
                this.hasContents = true;
                break;
            }
            catch (ExInvalidAttributeType e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    public String getGroupName() {
        return Messages.getString("PropertyUserDefinedAttributes.custom_properties");
    }

    public void create(Object layoutData) {
        this.base = new Composite(this.parent, 0);
        this.base.setLayoutData(layoutData);
        this.base.setLayout((Layout)new GridLayout(2, false));
        this.createdOwnBase = true;
        this.create_internal();
    }

    public void create() {
        assert (this.parent.getLayout() instanceof GridLayout && ((GridLayout)this.parent.getLayout()).numColumns == 2) : "Parent layout does not fit requiertments. Need GridLayout with exactly two coloumns";
        this.base = this.parent;
        this.createdOwnBase = false;
        this.create_internal();
    }

    private void create_internal() {
        this.initialModificationProblems.clear();
        this.attributeTypeID_control_map.clear();
        boolean mayEdit = true;
        if (this.owner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW rw = (IAttributeOwnerRW)this.owner;
            IModificationProblem modProblem = rw.checkLocks();
            if (modProblem != null) {
                mayEdit = false;
                this.initialModificationProblems.add(modProblem);
            }
        } else if (this.owner instanceof IAttributeModificationManager) {
            IAttributeModificationManager mm = (IAttributeModificationManager)this.owner;
            IModificationProblem modificationProblem = mm.checkLocks();
            if (modificationProblem != null) {
                mayEdit = false;
                this.initialModificationProblems.add(modificationProblem);
            }
        } else {
            mayEdit = false;
        }
        ArrayList sortedAttributes = new ArrayList(this.owner.getAllAttributes());
        Collections.sort(sortedAttributes, new Comparator<IAttribute>(){

            @Override
            public int compare(IAttribute arg0, IAttribute arg1) {
                IAttributeType t0 = AttributeTypesComposite.this.owner.getAttributeType(arg0.getAttributeTypeID());
                IAttributeType t1 = AttributeTypesComposite.this.owner.getAttributeType(arg1.getAttributeTypeID());
                return t0.getSortCriterium().compareTo((Object)t1.getSortCriterium());
            }
        });
        for (IAttribute attribute : sortedAttributes) {
            try {
                Set problems;
                final IAttributeType type = this.owner.getAttributeType(attribute.getAttributeTypeID());
                if (!type.displayToUser() || !this.attributeTypesToShow.contains(type)) continue;
                Label label = new Label(this.base, 0);
                if (type.getDataType().getSWTVerticalFillHint() == 4) {
                    label.setLayoutData((Object)new GridData(-1, 128, false, false));
                } else {
                    label.setLayoutData((Object)new GridData());
                }
                label.setText(type.getDisplayName());
                IAttributeTypeDataType.ISWTControlForModification typeControl = type.getDataType().createSWTControlForModifying(this.base, Collections.singleton(new ISWTControlModifiedListener(){
                    private boolean currentModificationInProgressState = false;

                    public void modified(Object newValue, Object additionalInfo) {
                        AttributeTypesComposite.this.isModified = true;
                        AttributeTypesComposite.this.modify(type, newValue, additionalInfo);
                    }

                    public void setModificationInProgress(boolean newModificationInProgressState) {
                        if (this.currentModificationInProgressState == newModificationInProgressState) {
                            return;
                        }
                        boolean changed = false;
                        if (newModificationInProgressState) {
                            changed = AttributeTypesComposite.this.modificationsInProgress.put(type, AttributeTypesComposite.createModificationInProgressProblem(type)) == null;
                        } else {
                            boolean bl = changed = AttributeTypesComposite.this.modificationsInProgress.remove(type) != null;
                        }
                        if (changed) {
                            AttributeTypesComposite.this.getAndRefreshModifcationProblems();
                        }
                        this.currentModificationInProgressState = newModificationInProgressState;
                    }
                }), attribute.getAttributeValue(), type.getValueRange());
                assert (typeControl.getControl() != null && typeControl.getControl().getParent() == this.base) : "SWTControlForModification must be a direct child of its parent.";
                this.attributeTypeID_control_map.put(attribute.getAttributeTypeID(), (ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean>)new ThreeTuple((Object)label, (Object)typeControl, (Object)type.isUserDefined()));
                GridData gridData = new GridData();
                gridData.verticalAlignment = type.getDataType().getSWTVerticalFillHint();
                gridData.horizontalAlignment = 4;
                gridData.grabExcessHorizontalSpace = true;
                gridData.grabExcessVerticalSpace = gridData.verticalAlignment == 4;
                gridData.heightHint = type.getDataType().getSWTHeightHint();
                typeControl.getControl().setLayoutData((Object)gridData);
                if (this.owner instanceof IAttributeOwnerRW) {
                    IAttributeOwnerRW rw = (IAttributeOwnerRW)this.owner;
                    problems = this.isCreationDialogue ? Collections.emptySet() : rw.checkGeneralAttributeModificationPermission(type);
                    typeControl.getControl().setEnabled(mayEdit && problems.isEmpty());
                    this.initialModificationProblems.addAll(problems);
                    continue;
                }
                if (this.owner instanceof IAttributeModificationManager) {
                    IAttributeModificationManager mm = (IAttributeModificationManager)this.owner;
                    problems = this.isCreationDialogue ? Collections.emptySet() : mm.checkGeneralModificationPermissions(type);
                    typeControl.getControl().setEnabled(mayEdit && problems.isEmpty());
                    if (problems.isEmpty()) continue;
                    this.initialModificationProblems.addAll(problems);
                    continue;
                }
                typeControl.getControl().setEnabled(false);
            }
            catch (ExInvalidAttributeType e) {
                logger.error("could not find attribute type", (Throwable)e);
            }
            catch (ExInvalidDataType e) {
                logger.error("invalid data type", (Throwable)e);
            }
        }
        this.noAttributesToShow = new Label(this.base, 0);
        this.noAttributesToShow.setText(Messages.getString("AttributeTypesComposite.NoAttributesToShow"));
        this.noAttributesToShow.setAlignment(0x1000000);
        this.noAttributesToShow.setVisible(false);
        GridData gd = GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create();
        gd.exclude = true;
        this.noAttributesToShow.setLayoutData((Object)gd);
        if (this.owner.getCategoryID() != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.owner.getProjectUID());
            ObjectTypeCategory category = projectAgent.getObjectTypeCategoriesManager().getCategory(this.owner.getCategoryID());
            this.showAttributes(category.getAttributeList(), true);
        }
    }

    private Collection<IModificationProblem> modify(IAttributeType type, Object newValue, Object additionalInformation) {
        this.transactionController.clear();
        Attribute newAttribute = new Attribute(type.getAttributeTypeID(), newValue);
        this.modifiedTypes.put(type, (Tuple<IAttribute, Object>)new Tuple((Object)newAttribute, additionalInformation));
        this.checkValue(type, newAttribute, additionalInformation);
        return this.getAndRefreshModifcationProblems();
    }

    private Collection<IModificationProblem> getAndRefreshModifcationProblems() {
        Collection<IModificationProblem> modProblems = this.transactionController.checkConditions(false, false);
        modProblems.addAll(this.getModificationProblems(false));
        if (!modProblems.isEmpty()) {
            IModificationProblem modProblem = null;
            for (IModificationProblem mp : modProblems) {
                if (modProblem != null && mp.getSeverity() >= modProblem.getSeverity()) continue;
                modProblem = mp;
            }
            this.dialog.setMessage(String.valueOf(modProblem.getHumanReadableDescriptionOfConsequence()) + "\n" + modProblem.getHumanReadableDescriptionOfCause(), ModificationProblemsDialog.getMessageProviderLevel((int)modProblem.getSeverity()), this.caller);
            this.dialog.setIsCommitable(modProblem.getSeverity() != 2 && this.modificationsInProgress.isEmpty(), this.caller);
        } else {
            this.dialog.setMessage(null, 3, this.caller);
            this.dialog.setIsCommitable(true, this.caller);
        }
        this.dialog.setIsCancelable(this.modificationsInProgress.isEmpty(), this.caller);
        if (this.dialog instanceof PropertiesDialog) {
            ((PropertiesDialog)this.dialog).updateModificationProblems();
        }
        return modProblems;
    }

    private void checkValue(IAttributeType attributeType, IAttribute newAttribute, Object additionalInformation) {
        IAttributeValueModifiedListener modListener = this.modListeners.get(attributeType.getAttributeTypeID());
        if (modListener != null) {
            this.transactionController.addLockModificationProblems(modListener.modified(newAttribute.getAttributeValue(), additionalInformation));
        }
        if (this.owner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW rw = (IAttributeOwnerRW)this.owner;
            rw.requestAttributeModificationPermission(newAttribute, this.transactionController);
        }
    }

    public Collection<IModificationProblem> getModificationProblems(boolean withInitialProblems) {
        ArrayList<IModificationProblem> problems = withInitialProblems ? new ArrayList<IModificationProblem>(this.initialModificationProblems) : new ArrayList<IModificationProblem>();
        problems.addAll(this.modificationsInProgress.values());
        return problems;
    }

    public Collection<IAttribute> getNewAttributes() {
        ArrayList<IAttribute> newAttributes = new ArrayList<IAttribute>();
        for (Tuple<IAttribute, Object> attributeAndAdditionalInformation : this.modifiedTypes.values()) {
            newAttributes.add((IAttribute)attributeAndAdditionalInformation.getT1());
        }
        return newAttributes;
    }

    public Tuple<IAttribute, Object> getCurrentAttribute(IAttributeTypeID attributeTypeID) {
        IAttributeType attributeType = this.owner.getAttributeType(attributeTypeID);
        Tuple attributeAndAdditionalInfo = this.modifiedTypes.get(attributeType);
        if (attributeAndAdditionalInfo == null) {
            attributeAndAdditionalInfo = new Tuple((Object)this.owner.getAttribute(attributeTypeID), ADDITIONALINFORMATION_FOR_UNMODIFIEDATTRIBUTE);
        }
        return attributeAndAdditionalInfo;
    }

    public boolean isModified() {
        return this.isModified || !this.modificationsInProgress.isEmpty();
    }

    public void dispose() {
        if (this.createdOwnBase) {
            this.base.dispose();
        }
        for (ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean> control : this.attributeTypeID_control_map.values()) {
            ((Label)control.getComponent1()).dispose();
            ((IAttributeTypeDataType.ISWTControlForModification)control.getComponent2()).dispose();
        }
    }

    public Composite getComposite() {
        return this.base;
    }

    public boolean hasContents() {
        return this.hasContents;
    }

    public void addModificationListener(IAttributeTypeID attributeTypeID, IAttributeValueModifiedListener listener) {
        this.modListeners.put(attributeTypeID, listener);
    }

    public void setEnabled(IAttributeTypeID attributeTypeID, boolean enabled) {
        Control control = ((IAttributeTypeDataType.ISWTControlForModification)this.attributeTypeID_control_map.get(attributeTypeID).getComponent2()).getControl();
        control.setEnabled(enabled);
    }

    private void setHidden(IAttributeTypeID attributeTypeID, boolean hidden) {
        ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean> controls = this.attributeTypeID_control_map.get(attributeTypeID);
        Control control = (Control)controls.getComponent1();
        Object layoutData = control.getLayoutData();
        if (control.getVisible() == hidden) {
            assert (layoutData instanceof GridData) : "GridData expected";
            ((GridData)layoutData).exclude = hidden;
            control.setVisible(!hidden);
            control = ((IAttributeTypeDataType.ISWTControlForModification)controls.getComponent2()).getControl();
            layoutData = control.getLayoutData();
            assert (layoutData instanceof GridData) : "GridData expected";
            ((GridData)layoutData).exclude = hidden;
            control.setVisible(!hidden);
            if (hidden) {
                ((IAttributeTypeDataType.ISWTControlForModification)controls.getComponent2()).reset();
            }
        }
    }

    public void showAttributes(Set<IAttributeTypeID> attributesToShow, boolean customAttributesOnly) {
        boolean isAtLeastOneAttributeVisible = false;
        for (Map.Entry<IAttributeTypeID, ThreeTuple<Label, IAttributeTypeDataType.ISWTControlForModification, Boolean>> singleAttribute : this.attributeTypeID_control_map.entrySet()) {
            if (!customAttributesOnly || ((Boolean)singleAttribute.getValue().getComponent3()).booleanValue()) {
                this.setHidden(singleAttribute.getKey(), !attributesToShow.contains(singleAttribute.getKey()));
            }
            isAtLeastOneAttributeVisible |= ((Label)singleAttribute.getValue().getComponent1()).getVisible();
        }
        this.noAttributesToShow.setVisible(!isAtLeastOneAttributeVisible);
        ((GridData)this.noAttributesToShow.getLayoutData()).exclude = isAtLeastOneAttributeVisible;
        this.base.layout(true, true);
    }

    @Override
    public void categoryChanged(ObjectTypeCategory category) {
        if (category != null) {
            this.showAttributes(category.getAttributeList(), true);
        } else {
            this.showAttributes(this.attributeTypeID_control_map.keySet(), true);
        }
    }

    private static IModificationProblem createModificationInProgressProblem(final IAttributeType type) {
        return new IModificationProblem(){

            public int getSeverity() {
                return 3;
            }

            public String getHumanReadableDescriptionOfConsequence() {
                return Messages.getString("AttributeTypesComposite.DialogCannotBeClosed.Reason");
            }

            public String getHumanReadableDescriptionOfCause() {
                return NLS.bind((String)Messages.getString("AttributeTypesComposite.DialogCannotBeClosed.Cause"), (Object)type.getDisplayName());
            }
        };
    }
}

