/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipStorage;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTable;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UniqueElementRelationshipModificationMgr
extends UniqueElementRelationshipStorage {
    private final Map<String, UniqueElementRelationshipTable> planUIDToRelationships;
    private final IFrameProjectAgent projectAgent;

    public UniqueElementRelationshipModificationMgr(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.planUIDToRelationships = new HashMap<String, UniqueElementRelationshipTable>();
    }

    public void initialize() {
        for (IPlan iPlan : this.projectAgent.getFrameSectionManager().getPlans()) {
            String planUID = iPlan.getUID();
            this.loadUERelationshipsForPlan(planUID);
        }
    }

    public void loadUERelationshipsForPlan(String planUID) {
        EOList<EOUniqueElementRelationship> relationships = this.readUniqueElementRelationships(planUID);
        if (relationships != null) {
            this.setRelationshipsForPlan(planUID, (Collection<EOUniqueElementRelationship>)relationships);
        } else {
            this.removeRelationshipsForPlan(planUID);
        }
    }

    private EOList<EOUniqueElementRelationship> readUniqueElementRelationships(String planUID) {
        IXMLDataAccessor containmentFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.getFileKey_UniqueElementRelationships((String)planUID), (IEncodableObjectFactory)MessageDataFactory.getInstance());
        try {
            return (EOList)containmentFileAccessor.read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeUniqueElementRelationships(String planUID) {
        EOList dataToWrite = this.planUIDToRelationships.containsKey(planUID) ? new EOList(this.planUIDToRelationships.get(planUID).getAllRelationships()) : null;
        IXMLDataAccessor containmentFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.getFileKey_UniqueElementRelationships((String)planUID), (IEncodableObjectFactory)MessageDataFactory.getInstance());
        containmentFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)dataToWrite));
    }

    @Override
    protected Map<String, UniqueElementRelationshipTable> getRelationshipStore() {
        return this.planUIDToRelationships;
    }

    @Override
    public void cleanUp() {
        Iterator<String> iteratorPlanUIDs = this.planUIDToRelationships.keySet().iterator();
        while (iteratorPlanUIDs.hasNext()) {
            String planUID = iteratorPlanUIDs.next();
            iteratorPlanUIDs.remove();
            this.writeUniqueElementRelationships(planUID);
        }
        super.cleanUp();
    }
}

