/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTableData;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CyclicUERelationshipIdentifier {
    private final Set<Cycle> cycles = new HashSet<Cycle>();
    private final Set<Cycle> rootCycles = new HashSet<Cycle>();
    private final Map<String, Cycle> map_element_cycle = new HashMap<String, Cycle>();

    public CyclicUERelationshipIdentifier(UniqueElementRelationshipTableData ueRelTableData) {
        this.findAllCycles(ueRelTableData);
    }

    public boolean isInCycle(String elementUID) {
        return this.map_element_cycle.containsKey(elementUID);
    }

    public Cycle getCycle(String elementUID) {
        return this.map_element_cycle.get(elementUID);
    }

    public Set<Cycle> getRootCycles() {
        return Collections.unmodifiableSet(this.rootCycles);
    }

    public Cycle getCycle(Set<String> elements) {
        if (elements != null && !elements.isEmpty()) {
            Cycle cycle = this.map_element_cycle.get(elements.iterator().next());
            if (cycle != null && cycle.getAllElements().equals(elements)) {
                return cycle;
            }
            return null;
        }
        return null;
    }

    private void findAllCycles(UniqueElementRelationshipTableData ueRelTableData) {
        this.findAllCyclesRecursively(ueRelTableData, ueRelTableData);
    }

    private void findAllCyclesRecursively(UniqueElementRelationshipTableData truncatedUERelTableData, UniqueElementRelationshipTableData fullUERelTableData) {
        Set<String> allNextElements;
        Set<String> allPreviousElements = truncatedUERelTableData.getAllPreviousElementUIDs();
        HashSet<String> intersectionElements = new HashSet<String>(allPreviousElements);
        boolean previousElementFoundThatIsNotInNextElements = intersectionElements.retainAll(allNextElements = truncatedUERelTableData.getAllNextElementUIDs());
        if (previousElementFoundThatIsNotInNextElements || intersectionElements.size() != allNextElements.size()) {
            this.findAllCyclesRecursively(this.buildUpStructureToAnalyze(intersectionElements, truncatedUERelTableData.getRelationships()), fullUERelTableData);
        } else {
            this.doTarjanSearchForCycles(truncatedUERelTableData, fullUERelTableData);
        }
    }

    private UniqueElementRelationshipTableData buildUpStructureToAnalyze(HashSet<String> remainingElements, Set<EOUniqueElementRelationship> currentUERelationships) {
        UniqueElementRelationshipTableData ueRelTableData = new UniqueElementRelationshipTableData();
        for (EOUniqueElementRelationship eoRelationship : currentUERelationships) {
            if (!remainingElements.contains(eoRelationship.getUniqueElementUID1()) || !remainingElements.contains(eoRelationship.getUniqueElementUID2())) continue;
            ueRelTableData.addData(eoRelationship);
        }
        return ueRelTableData;
    }

    private void doTarjanSearchForCycles(UniqueElementRelationshipTableData truncatedUERelTableData, UniqueElementRelationshipTableData fullUERelTableData) {
        Set<String> allElements = truncatedUERelTableData.getAllNextElementUIDs();
        HashSet<String> searchedElements = new HashSet<String>();
        HashMap<String, Integer> map_element_globalIndex = new HashMap<String, Integer>();
        ObjectWrapper globalElementCounter = new ObjectWrapper(null);
        Stack<String> stack = new Stack<String>();
        HashSet<String> elementsOnStack = new HashSet<String>();
        for (String elementUID : allElements) {
            if (searchedElements.contains(elementUID)) continue;
            globalElementCounter.setWrappedObject((Object)0);
            map_element_globalIndex.clear();
            stack.clear();
            elementsOnStack.clear();
            this.doTarjanSearchStep(elementUID, searchedElements, (ObjectWrapper<Integer>)globalElementCounter, map_element_globalIndex, stack, elementsOnStack, truncatedUERelTableData, fullUERelTableData);
        }
    }

    private int doTarjanSearchStep(String elementUID, HashSet<String> searchedElements, ObjectWrapper<Integer> globalElementCounter, HashMap<String, Integer> map_element_globalIndex, Stack<String> stack, HashSet<String> elementsOnStack, UniqueElementRelationshipTableData truncatedUERelTableData, UniqueElementRelationshipTableData fullUERelTableData) {
        searchedElements.add(elementUID);
        int elementIndex = (Integer)globalElementCounter.getWrappedObject() + 1;
        Integer elementIndexAsInteger = elementIndex;
        globalElementCounter.setWrappedObject((Object)elementIndexAsInteger);
        map_element_globalIndex.put(elementUID, elementIndexAsInteger);
        int lowestIndexOfAnyReachableElement = elementIndex + 1;
        stack.push(elementUID);
        elementsOnStack.add(elementUID);
        for (String directNextElementUID : truncatedUERelTableData.getDirectNextElementUIDs(elementUID)) {
            if (!searchedElements.contains(directNextElementUID)) {
                int lowestIndexOfAnyReachableElementOfNextElement = this.doTarjanSearchStep(directNextElementUID, searchedElements, globalElementCounter, map_element_globalIndex, stack, elementsOnStack, truncatedUERelTableData, fullUERelTableData);
                lowestIndexOfAnyReachableElement = Math.min(lowestIndexOfAnyReachableElement, lowestIndexOfAnyReachableElementOfNextElement);
                continue;
            }
            if (!elementsOnStack.contains(directNextElementUID)) continue;
            lowestIndexOfAnyReachableElement = Math.min(lowestIndexOfAnyReachableElement, map_element_globalIndex.get(directNextElementUID));
        }
        if (lowestIndexOfAnyReachableElement == elementIndex) {
            Cycle cycle = new Cycle();
            this.cycles.add(cycle);
            String elementFromStack = null;
            do {
                elementFromStack = stack.pop();
                elementsOnStack.remove(elementFromStack);
                cycle.addElement(elementFromStack);
                this.map_element_cycle.put(elementFromStack, cycle);
            } while (!elementFromStack.equals(elementUID));
            cycle.findPossibleParents(fullUERelTableData);
            if (cycle.isRootCycle()) {
                this.rootCycles.add(cycle);
            }
        } else if (lowestIndexOfAnyReachableElement == elementIndex + 1) {
            stack.pop();
            elementsOnStack.remove(elementUID);
        }
        return Math.min(lowestIndexOfAnyReachableElement, elementIndex);
    }

    public static class Cycle {
        private final Set<String> elements;
        private final SetMap<String, String> map_entryPoint_parents = new SetMap();

        Cycle() {
            this.elements = new HashSet<String>();
        }

        void addElement(String element) {
            this.elements.add(element);
        }

        void findPossibleParents(UniqueElementRelationshipTableData relationshipTableData) {
            for (String element : this.elements) {
                HashSet<String> previousElements = new HashSet<String>(relationshipTableData.getDirectPreviousElementUIDs(element));
                previousElements.removeAll(this.elements);
                if (previousElements.isEmpty()) continue;
                this.map_entryPoint_parents.addAll((Object)element, previousElements);
            }
        }

        public boolean isPartOfCycle(String element) {
            return this.elements.contains(element);
        }

        public Set<String> getAllElements() {
            return Collections.unmodifiableSet(this.elements);
        }

        public boolean isRootCycle() {
            return this.map_entryPoint_parents.keySet().isEmpty();
        }

        public SetMap<String, String> getPossibleParents() {
            return this.map_entryPoint_parents;
        }

        public Set<String> getParentsForEntryPoint(String cycleEntryPoint) {
            return this.map_entryPoint_parents.get((Object)cycleEntryPoint);
        }
    }
}

