/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.detailsprovider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.OpenEditorAction;
import com.arcway.cockpit.frame.client.global.gui.actions.OpenProjectorAction;
import com.arcway.cockpit.frame.client.global.gui.views.details.CockpitProjectDataSelector;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsView;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementExpandableList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementExpandableListStateCache;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.CompareLabelIgnoreCaseCockpitProjectDataComparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.FrameDetailsProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.InfolinkDetailsProviderPlugin;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.frame.client.global.gui.views.dnd.ViewItemDragSourceListener;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkViewContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.Messages;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementRelationshipHelper;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.detailsprovider.ContainingPlansContentProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.projectoccurrences.IUniqueElementProjectOccurrence;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.projectoccurrences.UniqueElementProjectOccurrenceMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementHighlightRequest;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import com.arcway.lib.eclipse.gui.viewers.CachingLabelProvider;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class UniqueElementsDetailsProvider
extends FrameDetailsProvider {
    private static final ILogger logger = Logger.getLogger(UniqueElementsDetailsProvider.class);
    private final InfolinkDetailsProviderPlugin infolinkDetailsProviderPlugin = new InfolinkDetailsProviderPlugin();
    private LinkViewContentProvider infoLinkLabelAndContentProvider;
    private ModuleLinkViewContribution moduleLinkViewContribution;

    @Override
    protected void init(IWorkbenchPartSite site_, IMemento memento) {
        this.moduleLinkViewContribution = new ModuleLinkViewContribution(site_);
        this.infoLinkLabelAndContentProvider = new LinkViewContentProvider(this.moduleLinkViewContribution, false);
        this.infolinkDetailsProviderPlugin.setup(this.infoLinkLabelAndContentProvider, this.moduleLinkViewContribution);
    }

    @Override
    public String getID() {
        return "frame.detailsprovider.uniqueElementOccurence";
    }

    @Override
    protected List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof IUniqueElement);
        IUniqueElement item = (IUniqueElement)itemToShow;
        ViewItemDragSourceListener listener = new ViewItemDragSourceListener(UniqueElementsDetailsProvider.createSelectionProvider(itemToShow), 1);
        return Collections.singletonList(new DetailsElementTitle(null, new DetailsValueTitle(item.getElementName(), this.getTitleImage((ICockpitProjectData)item), listener)));
    }

    @Override
    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        String typeName;
        assert (itemToShow instanceof IUniqueElement);
        IUniqueElement item = (IUniqueElement)itemToShow;
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(9);
        try {
            IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(item.getElementTypeID());
            typeName = typeDescription.getConstructionElementTypeName(Locale.getDefault());
        }
        catch (EXConstructionElementTypeUnknown eCETU) {
            typeName = "-";
        }
        detailsElements.add(new DetailsElementMulti(null, UniqueElementAttributeTypesProvider.ATTRNAME_DESCRIPTION, new DetailsValueMulti(item.getDescription()), false));
        detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        detailsElements.add(new DetailsElementSingle(null, UniqueElementAttributeTypesProvider.ATTRNAME_ELEMENT_TYPE, new DetailsValueSingle(typeName)));
        return detailsElements;
    }

    @Override
    protected List<DetailsElement> getAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof IUniqueElement);
        IUniqueElement item = (IUniqueElement)itemToShow;
        CachingLabelProvider cachingInfoLinkLabelProvider = new CachingLabelProvider((ILabelProvider)this.infoLinkLabelAndContentProvider);
        CompareLabelIgnoreCaseCockpitProjectDataComparator ueLinkedDataComparator = new CompareLabelIgnoreCaseCockpitProjectDataComparator((ILabelProvider)cachingInfoLinkLabelProvider);
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(9);
        detailsElements.add(new DetailsElementContainingPlans(null, new DetailsValueContainingPlans(item), this.moduleLinkViewContribution));
        DetailsView containingDetailsView = this.getContainingDetailsView();
        this.infolinkDetailsProviderPlugin.addInfoLinkDetailsElement(containingDetailsView, itemToShow, cachingInfoLinkLabelProvider, ueLinkedDataComparator, detailsElements);
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(item.getProjectUID());
        IUniqueElementRelationshipProvider ueRelationshipProvider = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
        this.getModellElementRelationDetailsElements("UniqueElementsDetailProvider.Containment", item, detailsElements, ueRelationshipProvider, (ILabelProvider)cachingInfoLinkLabelProvider, ueLinkedDataComparator);
        ueRelationshipProvider = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getAccessRelationshipProvider();
        this.getModellElementRelationAccessDetailsElements(item, detailsElements, ueRelationshipProvider, ueLinkedDataComparator);
        ueRelationshipProvider = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getCausalityRelationshipProvider();
        this.getModellElementRelationDetailsElements("UniqueElementsDetailProvider.Causality", item, detailsElements, ueRelationshipProvider, (ILabelProvider)cachingInfoLinkLabelProvider, ueLinkedDataComparator);
        this.getModellElementOccurrencesInOpenProjects(item, detailsElements);
        return detailsElements;
    }

    private void getModellElementRelationDetailsElements(String key, IUniqueElement item, List<DetailsElement> detailsElements, IUniqueElementRelationshipProvider ueRelationshipProvider, ILabelProvider infoLinkLabelProvider, CompareLabelIgnoreCaseCockpitProjectDataComparator ueLinkedDataComparator) {
        ViewItemDragSourceListener listener;
        DetailsValueList valueList;
        Collection<IUniqueElement> nextElements = ueRelationshipProvider.getNextUniqueElements(item.getUID());
        Collection<IUniqueElement> previousElements = ueRelationshipProvider.getPreviousUniqueElements(item.getUID());
        if (!nextElements.isEmpty() || !previousElements.isEmpty()) {
            detailsElements.add(new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
        }
        if (!previousElements.isEmpty()) {
            valueList = new DetailsValueList();
            Collections.sort((List)previousElements, ueLinkedDataComparator);
            for (IUniqueElement previous : previousElements) {
                listener = new ViewItemDragSourceListener(UniqueElementsDetailsProvider.createSelectionProvider(previous), 1);
                valueList.addListElement(infoLinkLabelProvider.getText((Object)previous), infoLinkLabelProvider.getImage((Object)previous), new ListEntryParameter(new CockpitProjectDataSelector((ICockpitProjectData)previous, this.getContainingDetailsView()), null, listener));
            }
            detailsElements.add(new DetailsElementExpandableList(String.valueOf(key) + ".prev", NLS.bind((String)Messages.getString(String.valueOf(key) + ".prev"), (Object)new Integer(previousElements.size())), valueList));
        }
        if (!nextElements.isEmpty()) {
            valueList = new DetailsValueList();
            Collections.sort((List)nextElements, ueLinkedDataComparator);
            for (IUniqueElement next : nextElements) {
                listener = new ViewItemDragSourceListener(UniqueElementsDetailsProvider.createSelectionProvider(next), 1);
                valueList.addListElement(infoLinkLabelProvider.getText((Object)next), infoLinkLabelProvider.getImage((Object)next), new ListEntryParameter(new CockpitProjectDataSelector((ICockpitProjectData)next, this.getContainingDetailsView()), null, listener));
            }
            detailsElements.add(new DetailsElementExpandableList(String.valueOf(key) + ".next", NLS.bind((String)Messages.getString(String.valueOf(key) + ".next"), (Object)new Integer(nextElements.size())), valueList));
        }
    }

    private void getModellElementRelationAccessDetailsElements(IUniqueElement item, List<DetailsElement> detailsElements, IUniqueElementRelationshipProvider ueRelationshipProvider, Comparator<? super IUniqueElement> comparator) {
        try {
            ArrayList<DetailsElement> newDetailsElements = new ArrayList<DetailsElement>(6);
            IConstructionElementTypeDescription typeDescription = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForType(item.getElementTypeID());
            int activeOrPassiveItem = typeDescription.getActiveOrPassiveConstructionElementType();
            Tuple<List<IUniqueElement>, List<IUniqueElement>> predecessors = UniqueElementRelationshipHelper.getActiveAndPassivePredecessorElements(item.getUID(), null, ueRelationshipProvider);
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.activepredecessors", newDetailsElements, (List)predecessors.getT1(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.FunctionPrevFunction", "UniqueElementsDetailProvider.Access.FunctionPrevInfo");
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.passivepredecessors", newDetailsElements, (List)predecessors.getT2(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.InfoPrevFunction", "UniqueElementsDetailProvider.Access.InfoPrevInfo");
            Tuple<List<IUniqueElement>, List<IUniqueElement>> bidirectionallyRelatedItems = UniqueElementRelationshipHelper.getActiveAndPassiveBidirectionallyRelatedElements(item.getUID(), null, ueRelationshipProvider);
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.activebidirectionallyrelateditems", newDetailsElements, (List)bidirectionallyRelatedItems.getT1(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.FunctionFunction", "UniqueElementsDetailProvider.Access.InfoFunction");
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.passivebidirectionallyrelateditems", newDetailsElements, (List)bidirectionallyRelatedItems.getT2(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.FunctionInfo", "UniqueElementsDetailProvider.Access.InfoInfo");
            Tuple<List<IUniqueElement>, List<IUniqueElement>> successors = UniqueElementRelationshipHelper.getActiveAndPassiveSuccessorElements(item.getUID(), null, ueRelationshipProvider);
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.activesuccessors", newDetailsElements, (List)successors.getT1(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.FunctionNextFunction", "UniqueElementsDetailProvider.Access.InfoNextFunction");
            this.addDetailsElementListForAccessRelatedUEs("frame.uniqueelement.accessrelation.passivesuccessors", newDetailsElements, (List)successors.getT2(), comparator, activeOrPassiveItem, "UniqueElementsDetailProvider.Access.FunctionNextInfo", "UniqueElementsDetailProvider.Access.InfoNextInfo");
            if (!newDetailsElements.isEmpty()) {
                detailsElements.add(new DetailsElementSeparator("frame.uniqueelements.accessrelation.separator", 8, new DetailsValueSeparator()));
                detailsElements.addAll(newDetailsElements);
            }
        }
        catch (EXConstructionElementTypeUnknown eCETU) {
            logger.warn("Unique element with unknown type: " + item.getElementTypeID(), (Throwable)eCETU);
        }
    }

    private void getModellElementOccurrencesInOpenProjects(IUniqueElement item, List<DetailsElement> detailsElements) {
        String key1 = "UniqueElementsDetailProvider.OccurrencesInOpenProjects";
        String key2 = "UniqueElementsDetailProvider.OccurrencesInOpenProjects.linklabel";
        List<IUniqueElementProjectOccurrence> occurencesInOpenProjects = UniqueElementProjectOccurrenceMgr.findUniqueElementOccurrencesInOpenProjects(item.getElementName(), item.getElementTypeID(), item.getProjectUID());
        int count = occurencesInOpenProjects.size();
        if (count > 0) {
            DetailsValueList detailsValue = new DetailsValueList();
            for (IUniqueElementProjectOccurrence uniqueElementOccurrence : occurencesInOpenProjects) {
                detailsValue.addListElement(NLS.bind((String)Messages.getString(key2), (Object)uniqueElementOccurrence.getUniqueElement().getElementName(), (Object)uniqueElementOccurrence.getProjectName()), this.infoLinkLabelAndContentProvider.getImage(uniqueElementOccurrence.getUniqueElement()), new ListEntryParameter(new CockpitProjectDataSelector((ICockpitProjectData)uniqueElementOccurrence.getUniqueElement(), this.getContainingDetailsView()), null, null));
            }
            detailsElements.add(new DetailsElementExpandableList(key1, NLS.bind((String)Messages.getString(key1), (Object)new Integer(count)), detailsValue));
        }
    }

    private void addDetailsElementListForAccessRelatedUEs(String detailsElementID, Collection<DetailsElement> detailsElements, List<IUniqueElement> relatedUniqueElements, Comparator<? super IUniqueElement> ueComparator, int activeOrPassive, String labelForActiveCase, String labelForPassiveCase) {
        int count = relatedUniqueElements.size();
        if (count > 0) {
            DetailsValueList detailsValue = new DetailsValueList();
            Collections.sort(relatedUniqueElements, ueComparator);
            for (IUniqueElement relatedUniqueElement : relatedUniqueElements) {
                ViewItemDragSourceListener listener = new ViewItemDragSourceListener(UniqueElementsDetailsProvider.createSelectionProvider(relatedUniqueElement), 1);
                detailsValue.addListElement(this.infoLinkLabelAndContentProvider.getText(relatedUniqueElement), this.infoLinkLabelAndContentProvider.getImage(relatedUniqueElement), new ListEntryParameter(new CockpitProjectDataSelector((ICockpitProjectData)relatedUniqueElement, this.getContainingDetailsView()), null, listener));
            }
            String listLabel = "";
            if (activeOrPassive == 0) {
                listLabel = labelForActiveCase;
            } else if (activeOrPassive == 1) {
                listLabel = labelForPassiveCase;
            }
            detailsElements.add(new DetailsElementExpandableList(detailsElementID, NLS.bind((String)Messages.getString(listLabel), (Object)new Integer(count)), detailsValue));
        }
    }

    @Override
    public Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        LinkedList types = new LinkedList();
        types.addAll(super.getDataTypesThatTriggerRefresh());
        types.add(ISection.class);
        types.add(IPlan.class);
        types.add(IUniqueElementOccurrence.class);
        types.add(EOUniqueElementRelationship.class);
        return types;
    }

    @Override
    public Collection<Class<?>> getDataTypesToBeRegisteredForPropertyChangeEvents() {
        return Arrays.asList(IUniqueElementOccurrence.class, EOUniqueElementRelationship.class);
    }

    private static class DetailsElementContainingPlans
    extends DetailsElement
    implements IOpenListener {
        private static Map<String, Image> plansDecoratedWithRefiningDecore = new HashMap<String, Image>();
        private final ModuleLinkViewContribution moduleLinkViewContribution;
        private final DetailsValueContainingPlans detailsValue;
        private IWorkbenchPartSite site;
        private Composite base;
        private TreeViewer occurenceTreeViewer;
        private GridData occurenceListGridData;
        private IUniqueElement itemShown;
        private ExpandableComposite expandableBase;
        private Composite detailsField;
        private int numberOfPlans;

        public DetailsElementContainingPlans(String id, DetailsValueContainingPlans detailsValue, ModuleLinkViewContribution moduleLinkViewContribution) {
            super(id);
            this.detailsValue = detailsValue;
            this.moduleLinkViewContribution = moduleLinkViewContribution;
        }

        public Control createWidget(final Composite parent, IWorkbenchPartSite site_, final IDetailsResourceProvider resourceProvider) {
            this.site = site_;
            this.detailsField = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginTop = 4;
            layout.marginBottom = 4;
            layout.horizontalSpacing = 14;
            this.detailsField.setLayout((Layout)layout);
            this.detailsField.setBackground(parent.getDisplay().getSystemColor(1));
            this.numberOfPlans = this.detailsValue.getNumberOfPlans();
            if (this.numberOfPlans > 0) {
                this.expandableBase = new ExpandableComposite(this.detailsField, 16);
                GridData gridData = new GridData(4, 1, true, false);
                gridData.verticalSpan = 2;
                this.expandableBase.setLayoutData((Object)gridData);
                this.expandableBase.setBackground(parent.getDisplay().getSystemColor(1));
                layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.horizontalSpacing = 8;
                this.expandableBase.setLayout((Layout)layout);
                this.expandableBase.setText(NLS.bind((String)Messages.getString("UniqueElementsDetailProvider._is_shown_on_the_following_plans__4"), (Object)new Integer(this.numberOfPlans)));
                this.expandableBase.setFont(resourceProvider.getLabelFont());
                final DetailsElementExpandableListStateCache expandableStateCache = DetailsElementExpandableListStateCache.getExpandableListStateCache();
                this.expandableBase.setExpanded(expandableStateCache.isExpanded(this.getId()));
                this.expandableBase.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        if (e.getState()) {
                            expandableStateCache.addExpandedList(this.getId());
                        } else {
                            expandableStateCache.addCollapsedList(this.getId());
                        }
                        Point oldSize = parent.getSize();
                        Point newSize = parent.computeSize(oldSize.x, -1);
                        parent.setSize(newSize);
                        resourceProvider.resourceResized();
                    }
                });
                this.base = new Composite((Composite)this.expandableBase, 0);
                this.expandableBase.setClient((Control)this.base);
                gridData = new GridData(4, 1, true, false);
                this.base.setLayoutData((Object)gridData);
                this.base.setBackground(parent.getDisplay().getSystemColor(1));
                layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                this.base.setLayout((Layout)layout);
                String sublabel = Messages.getString("UniqueElementsDetailProvider.(double_click_to_open)__4");
                StyledText subLabelWidget = new StyledText(this.base, 72);
                subLabelWidget.setText(sublabel);
                subLabelWidget.setFont(resourceProvider.getValueFont());
                StyleRange styleRange = new StyleRange();
                styleRange.start = 0;
                styleRange.length = sublabel.length();
                styleRange.fontStyle = 0;
                subLabelWidget.setStyleRange(styleRange);
                this.occurenceTreeViewer = new TreeViewer(this.base, 0);
                this.occurenceTreeViewer.setUseHashlookup(true);
                this.occurenceListGridData = new GridData(1808);
                this.occurenceListGridData.minimumWidth = 150;
                this.occurenceTreeViewer.getTree().setLayoutData((Object)this.occurenceListGridData);
                this.occurenceTreeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
                this.occurenceTreeViewer.setAutoExpandLevel(-1);
                this.occurenceTreeViewer.addOpenListener((IOpenListener)this);
                final MenuManager contextMenuMgr = new MenuManager("UniqueElementsDetailsContextMenu");
                contextMenuMgr.setRemoveAllWhenShown(true);
                final OpenProjectorForUEAction openProjectorAction = new OpenProjectorForUEAction();
                final OpenEditorForUEAction openEditorAction = new OpenEditorForUEAction();
                contextMenuMgr.add((IContributionItem)new Separator("additions"));
                contextMenuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        if (this.selectionContainsOnlyPlans(occurenceTreeViewer.getSelection())) {
                            openProjectorAction.update();
                            contextMenuMgr.add((IAction)openProjectorAction);
                            openEditorAction.update();
                            contextMenuMgr.add((IAction)openEditorAction);
                        }
                    }
                });
                site_.registerContextMenu(contextMenuMgr, (ISelectionProvider)this.occurenceTreeViewer);
                Menu menu = contextMenuMgr.createContextMenu(this.occurenceTreeViewer.getControl());
                this.occurenceTreeViewer.getControl().setMenu(menu);
            } else {
                StyledText labelWidget = new StyledText(this.detailsField, 72);
                GridData gridData = new GridData(4, 1, true, false);
                gridData.verticalSpan = 2;
                labelWidget.setLayoutData((Object)gridData);
                labelWidget.setBackground(parent.getDisplay().getSystemColor(1));
                String label = Messages.getString("UniqueElementsDetailProvider._is_not_shown_on_plans");
                labelWidget.setText(label);
                labelWidget.setFont(resourceProvider.getValueFont());
                StyleRange styleRange = new StyleRange();
                styleRange.start = 0;
                styleRange.length = label.length();
                styleRange.fontStyle = 0;
                labelWidget.setStyleRange(styleRange);
            }
            return this.detailsField;
        }

        public void fillWidget(IDetailsResourceProvider resourceProvider) {
            if (this.numberOfPlans > 0) {
                if (this.detailsValue.getParameter() instanceof IUniqueElement) {
                    this.itemShown = (IUniqueElement)this.detailsValue.getParameter();
                    this.occurenceTreeViewer.setContentProvider((IContentProvider)new ContainingPlansContentProvider(this.itemShown));
                    DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new ProjectTreeContentProvider(this.moduleLinkViewContribution));
                    labelProvider.addLabelDecorator(new ILabelDecorator(){

                        public Image decorateImage(Image image, Object element) {
                            if (element instanceof IPlan) {
                                IPlan plan = (IPlan)element;
                                if (itemShown != null && ProjectMgr.getProjectMgr().getProjectAgent(itemShown.getProjectUID()).getUniqueElementRelationshipManager().isRefiningPlan(itemShown, plan)) {
                                    String plantypeUID = plan.getPlantypeUID();
                                    if (!plansDecoratedWithRefiningDecore.containsKey(plantypeUID)) {
                                        DecoratedImageDescriptor dd = new DecoratedImageDescriptor(image);
                                        ImageDescriptor refineSymbol = Icons.getImageDescriptorRefinementDecorator();
                                        dd.addDecorator(refineSymbol, 3);
                                        plansDecoratedWithRefiningDecore.put(plantypeUID, dd.createImage());
                                    }
                                    return (Image)plansDecoratedWithRefiningDecore.get(plantypeUID);
                                }
                            }
                            return image;
                        }

                        public String decorateText(String text, Object element) {
                            return text;
                        }

                        public void addListener(ILabelProviderListener listener) {
                        }

                        public void dispose() {
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return true;
                        }

                        public void removeListener(ILabelProviderListener listener) {
                        }
                    });
                    this.occurenceTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
                    this.occurenceTreeViewer.setInput((Object)ProjectMgr.getProjectMgr().getProjectAgent(this.itemShown.getProjectUID()));
                    int totalHeightOfListedItems = DetailsElementContainingPlans.getHeightOfItemsRecursivly(this.occurenceTreeViewer.getTree().getItems());
                    if (totalHeightOfListedItems > 0) {
                        this.occurenceListGridData.minimumHeight = totalHeightOfListedItems;
                        this.occurenceListGridData.heightHint = totalHeightOfListedItems;
                        this.occurenceListGridData.verticalIndent = 10;
                    } else {
                        this.occurenceListGridData.minimumHeight = 0;
                        this.occurenceListGridData.heightHint = 1;
                        this.occurenceListGridData.verticalIndent = 0;
                    }
                    this.occurenceTreeViewer.getControl().getParent().layout();
                } else {
                    this.itemShown = null;
                    this.occurenceTreeViewer.setInput(null);
                }
            }
        }

        private static int getHeightOfItemsRecursivly(TreeItem[] treeItems) {
            int height = 0;
            TreeItem[] treeItemArray = treeItems;
            int n = treeItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem currentItem = treeItemArray[n2];
                height += currentItem.getBounds((int)0).height + DetailsElementContainingPlans.getHeightOfItemsRecursivly(currentItem.getItems());
                ++n2;
            }
            return height;
        }

        public int getMinimumWidth() {
            return 300;
        }

        public void setHighlighted(boolean highlighted) {
            throw new UnsupportedOperationException();
        }

        public boolean showsEqualValues(DetailsElement detailsElement) {
            throw new UnsupportedOperationException();
        }

        public void open(OpenEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object obj = selection.getFirstElement();
            if (obj instanceof IPlan) {
                IPlan plan = (IPlan)obj;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.itemShown.getProjectUID());
                projectAgent.getPlanEditorManager().openSinglePlanEditorAndHighlightUniqueElement(this.site.getPage(), plan, this.itemShown);
            }
        }

        private boolean selectionContainsOnlyPlans(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                for (Object selectedItem : ((IStructuredSelection)selection).toList()) {
                    if (selectedItem instanceof IPlan) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private class OpenEditorForUEAction
        extends OpenEditorAction {
            OpenEditorForUEAction() {
                super((ISelectionProvider)DetailsElementContainingPlans.this.occurenceTreeViewer, DetailsElementContainingPlans.this.site.getPage());
            }

            @Override
            public void run() {
                super.run();
                UniqueElementHighlightRequest request = new UniqueElementHighlightRequest(DetailsElementContainingPlans.this.itemShown.getUID());
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(DetailsElementContainingPlans.this.itemShown.getProjectUID());
                projectAgent.highlightElements(DetailsElementContainingPlans.this.site.getWorkbenchWindow(), Collections.singletonList(request));
            }
        }

        private class OpenProjectorForUEAction
        extends OpenProjectorAction {
            OpenProjectorForUEAction() {
                super((ISelectionProvider)DetailsElementContainingPlans.this.occurenceTreeViewer, DetailsElementContainingPlans.this.site.getPage());
            }

            @Override
            public void run() {
                super.run();
                UniqueElementHighlightRequest request = new UniqueElementHighlightRequest(DetailsElementContainingPlans.this.itemShown.getUID());
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(DetailsElementContainingPlans.this.itemShown.getProjectUID());
                projectAgent.highlightElements(DetailsElementContainingPlans.this.site.getWorkbenchWindow(), Collections.singletonList(request));
            }
        }
    }

    private static class DetailsValueContainingPlans
    extends DetailsValue {
        private final IUniqueElement uniqueElement;

        public DetailsValueContainingPlans(IUniqueElement shownItem) {
            super(null, null, 0, 100, shownItem);
            this.uniqueElement = shownItem;
        }

        public int getNumberOfPlans() {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.uniqueElement.getProjectUID());
            OccurrenceList uniqueElementOccurrences = projectAgent.getFrameUniqueElementMgr().getUniqueElementOccurrences(this.uniqueElement.getUID());
            int numberOfPlans = uniqueElementOccurrences.getPlans().size();
            return numberOfPlans;
        }
    }
}

