/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UniqueElementServerCache {
    private final Map<String, UniqueElement> uniqueElementsByUID = new HashMap<String, UniqueElement>();
    private final Map<UniqueElementIdentifier, UniqueElement> uniqueElementsByTypeAndName = new HashMap<UniqueElementIdentifier, UniqueElement>();

    protected UniqueElementServerCache() {
    }

    protected void addUniqueElement(UniqueElement uniqueElement) {
        UniqueElementIdentifier uniqueElementIdentifier = uniqueElement.getUniqueElementIdentifier();
        assert (this.getUniqueElement(uniqueElement.getUID()) == null);
        assert (this.getUniqueElement(uniqueElementIdentifier) == null);
        this.uniqueElementsByUID.put(uniqueElement.getUID(), uniqueElement);
        this.uniqueElementsByTypeAndName.put(uniqueElementIdentifier, uniqueElement);
    }

    protected void replaceUniqueElement(UniqueElement uniqueElement) {
        this.deleteUniqueElement(uniqueElement.getUID());
        this.addUniqueElement(uniqueElement);
    }

    protected UniqueElement getUniqueElement(String uID) {
        return this.uniqueElementsByUID.get(uID);
    }

    protected UniqueElement getUniqueElement(UniqueElementIdentifier uniqueElementIdentifier) {
        return this.uniqueElementsByTypeAndName.get(uniqueElementIdentifier);
    }

    protected Collection<String> getAllUniqueElementUIDs() {
        return new ArrayList<String>(this.uniqueElementsByUID.keySet());
    }

    protected void deleteUniqueElement(String uID) {
        UniqueElement deletedUE = this.uniqueElementsByUID.remove(uID);
        assert (deletedUE != null);
        UniqueElementIdentifier key = deletedUE.getUniqueElementIdentifier();
        UniqueElement ueFromNameIndex = this.uniqueElementsByTypeAndName.get(key);
        if (ueFromNameIndex == deletedUE) {
            this.uniqueElementsByTypeAndName.remove(key);
        } else {
            Iterator<Map.Entry<UniqueElementIdentifier, UniqueElement>> itEntries = this.uniqueElementsByTypeAndName.entrySet().iterator();
            while (itEntries.hasNext()) {
                Map.Entry<UniqueElementIdentifier, UniqueElement> entry = itEntries.next();
                if (entry.getValue() != deletedUE) continue;
                itEntries.remove();
            }
        }
    }
}

