/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.PlanWithOccurrences;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementOccurrenceModificationFileEncodableObjectFactory;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UniqueElementOccurrenceModificationMgr {
    private final IFrameProjectAgent projectAgent;
    private final Map<String, PlanWithOccurrences> plansWithCreatedOccurrences = new HashMap<String, PlanWithOccurrences>();
    private final Map<String, PlanWithOccurrences> plansWithDeletedOccurrences = new HashMap<String, PlanWithOccurrences>();
    private final Map<String, List<LockResult>> temporaryLocksByOccurenceOperation = new HashMap<String, List<LockResult>>();

    public UniqueElementOccurrenceModificationMgr(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public void saveUniqueElementOccurrenceModifications(EOList<EOList<EOUniqueElementOccurrence>> uniqueElementOccurrenceModifications, String planUID) {
        UniqueElementOccurrenceModificationFileEncodableObjectFactory modFileEOFactory = new UniqueElementOccurrenceModificationFileEncodableObjectFactory();
        IXMLDataAccessor xmlFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.getFileKey_UniqueElementOccurrenceModifications((String)planUID), (IEncodableObjectFactory)modFileEOFactory);
        if (uniqueElementOccurrenceModifications == null || uniqueElementOccurrenceModifications.isEmpty()) {
            xmlFileAccessor.write(null);
        } else {
            xmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(uniqueElementOccurrenceModifications));
        }
        this.temporaryLocksByOccurenceOperation.remove(planUID);
    }

    public EOList<EOList<EOUniqueElementOccurrence>> readUniqueElementOccurrenceModifications(String planUID) {
        EOList mods;
        UniqueElementOccurrenceModificationFileEncodableObjectFactory modFileEOFactory = new UniqueElementOccurrenceModificationFileEncodableObjectFactory();
        IXMLDataAccessor xmlFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.getFileKey_UniqueElementOccurrenceModifications((String)planUID), (IEncodableObjectFactory)modFileEOFactory);
        try {
            mods = (EOList)xmlFileAccessor.read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (mods == null) {
            mods = new EOList();
        }
        return mods;
    }

    protected void addModifications(Collection<EOUniqueElementOccurrence> createdOccurrences, Collection<EOUniqueElementOccurrence> deletedOccurrences) {
        String occurrencePlanUID;
        PlanWithOccurrences pwo;
        if (createdOccurrences != null) {
            for (EOUniqueElementOccurrence occurrence : createdOccurrences) {
                pwo = this.plansWithCreatedOccurrences.get(occurrence.getPlanUID());
                if (pwo == null) {
                    occurrencePlanUID = occurrence.getPlanUID();
                    pwo = new PlanWithOccurrences(occurrencePlanUID);
                    this.plansWithCreatedOccurrences.put(occurrencePlanUID, pwo);
                }
                pwo.addOccurrence(occurrence);
            }
        }
        if (deletedOccurrences != null) {
            for (EOUniqueElementOccurrence occurrence : deletedOccurrences) {
                pwo = this.plansWithDeletedOccurrences.get(occurrence.getPlanUID());
                if (pwo == null) {
                    occurrencePlanUID = occurrence.getPlanUID();
                    pwo = new PlanWithOccurrences(occurrencePlanUID);
                    this.plansWithDeletedOccurrences.put(occurrencePlanUID, pwo);
                }
                pwo.addOccurrence(occurrence);
            }
        }
    }

    protected void removeModifications(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        this.plansWithCreatedOccurrences.remove(planUID);
        this.plansWithDeletedOccurrences.remove(planUID);
        ArrayList<EOLock> locksToBeReleased = new ArrayList<EOLock>();
        List<LockResult> lockResults = this.temporaryLocksByOccurenceOperation.get(planUID);
        if (lockResults != null) {
            for (LockResult lockResult : lockResults) {
                locksToBeReleased.addAll(lockResult.getAllRequestedLocks());
            }
            this.projectAgent.getLockManager().releaseLocks(locksToBeReleased);
        }
    }

    protected boolean isModified(String planUID) {
        return this.plansWithCreatedOccurrences.containsKey(planUID) || this.plansWithDeletedOccurrences.containsKey(planUID);
    }

    protected boolean isModified() {
        return !this.plansWithCreatedOccurrences.isEmpty() || !this.plansWithDeletedOccurrences.isEmpty();
    }

    protected EOUniqueElementOccurrence getUniqueElementOccurrence(String planUID, String planElementUID) {
        if (this.containsCreatedUniqueElementOccurrence(planUID, planElementUID)) {
            return this.getCreatedUniqueElementOccurrence(planUID, planElementUID);
        }
        return null;
    }

    protected Collection<EOUniqueElementOccurrence> getCreatedUniqueElementOccurrences() {
        ArrayList<EOUniqueElementOccurrence> createdOccurrences = new ArrayList<EOUniqueElementOccurrence>();
        for (PlanWithOccurrences pwo : this.plansWithCreatedOccurrences.values()) {
            createdOccurrences.addAll(pwo.getAllOccurrences());
        }
        return createdOccurrences;
    }

    protected Collection<EOUniqueElementOccurrence> getCreatedUniqueElementOccurrences(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        PlanWithOccurrences pwo = this.plansWithCreatedOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getAllOccurrences();
        }
        return Collections.emptyList();
    }

    protected Collection<EOUniqueElementOccurrence> getDeletedUniqueElementOccurrences() {
        ArrayList<EOUniqueElementOccurrence> occurrences = new ArrayList<EOUniqueElementOccurrence>();
        for (PlanWithOccurrences pwo : this.plansWithDeletedOccurrences.values()) {
            occurrences.addAll(pwo.getAllOccurrences());
        }
        return occurrences;
    }

    protected Collection<EOUniqueElementOccurrence> getDeletedUniqueElementOccurrences(String planUID) {
        PlanWithOccurrences pwo = this.plansWithDeletedOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getAllOccurrences();
        }
        return Collections.emptyList();
    }

    protected void addCreatedUniqueElementOccurrence(EOUniqueElementOccurrence uniqueElementOccurrence) {
        assert (uniqueElementOccurrence != null) : "uniqueElementOccurrence can't be null";
        String planUID = uniqueElementOccurrence.getPlanUID();
        PlanWithOccurrences pwo = this.plansWithCreatedOccurrences.get(planUID);
        if (pwo == null) {
            pwo = new PlanWithOccurrences(planUID);
            this.plansWithCreatedOccurrences.put(planUID, pwo);
        }
        pwo.addOccurrence(uniqueElementOccurrence);
    }

    protected EOUniqueElementOccurrence removeCreatedUniqueElementOccurrence(String planUID, String planElementUID) {
        EOUniqueElementOccurrence removedOccurence;
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        PlanWithOccurrences pwo = this.plansWithCreatedOccurrences.get(planUID);
        if (pwo != null) {
            removedOccurence = pwo.removeOccurrence(planElementUID);
            if (pwo.isEmpty()) {
                this.plansWithCreatedOccurrences.remove(planUID);
            }
        } else {
            removedOccurence = null;
        }
        return removedOccurence;
    }

    protected EOUniqueElementOccurrence getCreatedUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        PlanWithOccurrences pwo = this.plansWithCreatedOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getOccurrence(planElementUID);
        }
        return null;
    }

    protected boolean containsCreatedUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        return this.getCreatedUniqueElementOccurrence(planUID, planElementUID) != null;
    }

    protected void addDeletedUniqueElementOccurrence(EOUniqueElementOccurrence uniqueElementOccurrence) {
        assert (uniqueElementOccurrence != null) : "uniqueElementOccurrence can't be null";
        String planUID = uniqueElementOccurrence.getPlanUID();
        PlanWithOccurrences pwo = this.plansWithDeletedOccurrences.get(planUID);
        if (pwo == null) {
            pwo = new PlanWithOccurrences(planUID);
            this.plansWithDeletedOccurrences.put(planUID, pwo);
        }
        pwo.addOccurrence(uniqueElementOccurrence);
    }

    protected void removeDeletedUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        PlanWithOccurrences pwo = this.plansWithDeletedOccurrences.get(planUID);
        if (pwo != null) {
            pwo.removeOccurrence(planElementUID);
            if (pwo.isEmpty()) {
                this.plansWithDeletedOccurrences.remove(planUID);
            }
        }
    }

    protected EOUniqueElementOccurrence getDeletedUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        PlanWithOccurrences pwo = this.plansWithDeletedOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getOccurrence(planElementUID);
        }
        return null;
    }

    protected boolean containsDeletedUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null";
        assert (planElementUID != null) : "planElementUID can't be null";
        return this.getDeletedUniqueElementOccurrence(planUID, planElementUID) != null;
    }

    public void addTemporaryLockResult(String planUID, LockResult lockResult) {
        List<LockResult> lockResultList = this.temporaryLocksByOccurenceOperation.get(planUID);
        if (lockResultList != null) {
            lockResultList.add(lockResult);
        } else {
            lockResultList = new ArrayList<LockResult>();
            lockResultList.add(lockResult);
            this.temporaryLocksByOccurenceOperation.put(planUID, lockResultList);
        }
    }

    public void cleanUp() {
        HashSet<String> knownPlanUIDs = new HashSet<String>();
        knownPlanUIDs.addAll(this.plansWithCreatedOccurrences.keySet());
        knownPlanUIDs.addAll(this.plansWithDeletedOccurrences.keySet());
        for (String planUID : knownPlanUIDs) {
            this.saveUniqueElementOccurrenceModifications(null, planUID);
        }
        this.plansWithCreatedOccurrences.clear();
        this.plansWithDeletedOccurrences.clear();
        this.temporaryLocksByOccurenceOperation.clear();
    }
}

