/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.FrameDataAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;

public class ReportTemplateAttributeModificationManager
extends FrameDataAttributeModificationManager {
    public ReportTemplateAttributeModificationManager(IFrameProjectAgent projectAgent) {
        super(projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE), projectAgent);
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        ReportTemplateAttributeModificationManager.checkAttribute(newAttribute, transactionController);
        super.requestAttributeModificationPermission(newAttribute, transactionController);
    }

    public static void checkAttribute(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        FileID fd;
        if (newAttribute.getAttributeTypeID().equals(ReportTemplateAttributeTypesProvider.ATTRID_FILE) && (fd = (FileID)newAttribute.getAttributeValue()).equals(FileID.NO_FILE)) {
            ModificationProblem modProblem = new ModificationProblem(Messages.getString("ReportTemplateAttributeModificationManager.reporttemplate_must_be_specified"), Messages.getString("ReportTemplateAttributeModificationManager.cannot_set_properties"));
            transactionController.addLockModificationProblem(modProblem);
        }
    }
}

