/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameReportOutputTemplateManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.FrameDataAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportOutputtemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputtemplate;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputtemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReportOutputTemplatesManager
extends DataManager
implements IFrameReportOutputTemplateManager,
IProjectCloseListener {
    private ILOLinkAccessFacade linkFacade;

    private static IFrameDataFactory createDataFactory(final IFrameProjectAgent projectAgent) {
        return new IFrameDataFactory(){

            @Override
            public IFrameDataRW createFrameData(EOFrameData eo) {
                return new ReportOutputtemplate(eo, projectAgent, IAttributeModificationManager.DUMMY);
            }

            @Override
            public IFrameDataRW createFrameData(Collection<IAttribute> attributes) {
                return new ReportOutputtemplate(UUIDGenerator.getUniqueID(), attributes, IAttributeModificationManager.DUMMY, projectAgent);
            }

            @Override
            public void setAttributeModificationManager(IFrameDataRW frameData) {
                ReportOutputtemplate outputtemplate = (ReportOutputtemplate)frameData;
                FrameDataAttributeModificationManager modManager = ReportOutputTemplatesManager.createModificationManager(projectAgent);
                modManager.setFrameData(frameData);
                outputtemplate.setAttributeModificationManager(modManager);
            }

            @Override
            public void setAttributeModificationManager(IFrameDataRW frameData, IAttributeModificationManager modManager) {
                ReportOutputtemplate outputtemplate = (ReportOutputtemplate)frameData;
                outputtemplate.setAttributeModificationManager(modManager);
            }
        };
    }

    public ReportOutputTemplatesManager(IFrameProjectAgent projectAgent) {
        super(ProjectDirectoryLayout.FILEKEY_REPORTOUTPUTTEMPLATES, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE), ReportOutputTemplatesManager.createDataFactory(projectAgent), projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE), IReportOutputtemplateRW.class, projectAgent.getLinkManager(), Collections.singleton(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)));
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        super.initializeAfterPermissionsCheck(administrator, serverDataContainer);
        administrator.getFrameProjectAgent().addProjectCloseListener(this);
        this.linkFacade = this.getProjectAgent().getLinkManager().getLOLinkAccessFacade(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE);
    }

    @Override
    public void closeProject(IFrameProjectAgent pa) {
        this.linkFacade = null;
    }

    @Override
    public ILOLinkAccessFacade getReportOutputTemplateLinkFacade() {
        return this.linkFacade;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        List<ICockpitProjectData> linkedModuleData = this.linkFacade.getCrossLinkedModuleData(data.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("ReportOutputTemplatesManager.reporttemplate_is_linked"), Messages.getString("ReportOutputTemplatesManager.could_not_delete_reporttemplate")));
        }
        super.requestDataDeletePermission(data, transactionController);
    }

    @Override
    public Collection<IClientFunctionLicenseType> getNeededLicenseTypesForAdd() {
        return Collections.singleton(ClientFunctionLicenseTypeModifyReportTemplates.getInstance());
    }

    @Override
    public Collection<IClientFunctionLicenseType> getNeededLicenseTypesForDelete() {
        return this.getNeededLicenseTypesForAdd();
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return this.getProjectAgent().getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE);
    }

    public static FrameDataAttributeModificationManager createModificationManager(IFrameProjectAgent projectAgent) {
        FrameDataAttributeModificationManager modManager = new FrameDataAttributeModificationManager(projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE), projectAgent);
        return modManager;
    }

    @Override
    public void checkAttributeOnCreation(IAttribute attribute, ILocksAndPermissionsTransactionController transactionController) {
        FileID fd;
        if (attribute.getAttributeTypeID().equals(ReportOutputtemplateAttributeTypesProvider.ATTRID_FILE) && (fd = (FileID)attribute.getAttributeValue()).equals(FileID.NO_FILE)) {
            ModificationProblem modProblem = new ModificationProblem(com.arcway.cockpit.frame.client.global.Messages.getString("ReportTemplateAttributeModificationManager.reportoutputtemplate_must_be_specified"), com.arcway.cockpit.frame.client.global.Messages.getString("ReportTemplateAttributeModificationManager.cannot_set_properties"));
            transactionController.addLockModificationProblem(modProblem);
        }
    }
}

