/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionTemplate;
import com.arcway.cockpit.frame.shared.Messages;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class FramePermissionDefinitions {
    private static List<CockpitPermissionTemplate> templates = null;
    private static Map<String, List<CockpitPermissionTemplate>> templatesForOperandTypes = new HashMap<String, List<CockpitPermissionTemplate>>();
    public static final FramePermissionTemplate OPEN_PROJECT_PERMISSION_TEMPLATE = new FramePermissionTemplate("openProject", "project");
    public static final CockpitPermissionTemplate MODIFY_PROJECT_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("frame.project"), "project", false);
    public static final FramePermissionTemplate MODIFY_FOLDERS_PERMISSION_TEMPLATE = new FramePermissionTemplate("modifyFolders", "section");
    public static final CockpitPermissionTemplate MODIFY_FOLDERS_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("com.arcway.cockpit.section"), "section");
    public static final FramePermissionTemplate DELETE_PROJECT_ON_SERVER_TEMPLATE = new FramePermissionTemplate("deleteProjectOnServer", "project", false);
    public static final FramePermissionTemplate ADMIN_PERMISSIONS_TEMPLATE = new FramePermissionTemplate("adminPermissions", "project", false);
    public static final FramePermissionTemplate DUMP_TEMPLATE = new FramePermissionTemplate("dump", "project", false);
    public static final FramePermissionTemplate EXPORT_PROJECT_TEMPLATE = new FramePermissionTemplate("exportProjectTemplate", "project", false);
    public static final FramePermissionTemplate SNAPSHOT_TEMPLATE = new FramePermissionTemplate("snapshotProject", "project", false);
    public static final FramePermissionTemplate OPEN_PUBLISHED_TEMPLATE = new FramePermissionTemplate("openPublishedProject", "project", false);
    public static final FramePermissionTemplate EDIT_PLANS_TEMPLATE = new FramePermissionTemplate("editPlan", "section");
    public static final CockpitPermissionTemplate MODIFY_PLANS_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("com.arcway.cockpit.plan"), "section");
    public static final FramePermissionTemplate DELETE_PLANS_TEMPLATE = new FramePermissionTemplate("deletePlan", "section");
    public static final FramePermissionTemplate ADMINISTRATE_STAKEHOLDERS_TEMPLATE = new FramePermissionTemplate("editStakeholders", "project", false);
    public static final CockpitPermissionTemplate MODIFY_STAKEHOLDERS_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder"), "project", false);
    public static final CockpitPermissionTemplate MODIFY_STAKEHOLDER_ROLES_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole"), "project", false);
    public static final FramePermissionTemplate DEFINE_ATTRIBUTE_TYPES = new FramePermissionTemplate("defineAttributeTypes", "project", false);
    public static final CockpitPermissionTemplate MODIFY_UNIQUE_ELEMENTS_ALL_ATTR_PERMISSION_TEMPLATE = AllAttributeModificationPermissionTemplate.getAllAttrTemplate(FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement"), "project");
    public static final FramePermissionTemplate CHECK_OUT_PROJECT_FOR_OFFLINE_MODE = new FramePermissionTemplate("checkOutProjectForOfflineMode", "project", false);
    public static final FramePermissionTemplate MODIFY_MODEL_ELEMENT_CATEGORY_TEMPLATE = new FramePermissionTemplate("modify-category", "com.arcway.cockpit.uniqueelement", "project", true);

    public static synchronized List<CockpitPermissionTemplate> getPermissionTemplates() {
        if (templates == null) {
            templates = new ArrayList<CockpitPermissionTemplate>();
            templates.add(OPEN_PROJECT_PERMISSION_TEMPLATE);
            templates.add(MODIFY_FOLDERS_PERMISSION_TEMPLATE);
            templates.add(DELETE_PROJECT_ON_SERVER_TEMPLATE);
            templates.add(ADMIN_PERMISSIONS_TEMPLATE);
            templates.add(DUMP_TEMPLATE);
            templates.add(SNAPSHOT_TEMPLATE);
            templates.add(OPEN_PUBLISHED_TEMPLATE);
            templates.add(EXPORT_PROJECT_TEMPLATE);
            templates.add(EDIT_PLANS_TEMPLATE);
            templates.add(DELETE_PLANS_TEMPLATE);
            templates.add(ADMINISTRATE_STAKEHOLDERS_TEMPLATE);
            templates.add(DEFINE_ATTRIBUTE_TYPES);
            templates.add(MODIFY_PROJECT_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(MODIFY_FOLDERS_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(MODIFY_PLANS_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(MODIFY_MODEL_ELEMENT_CATEGORY_TEMPLATE);
            templates.add(MODIFY_UNIQUE_ELEMENTS_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(MODIFY_STAKEHOLDERS_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(MODIFY_STAKEHOLDER_ROLES_ALL_ATTR_PERMISSION_TEMPLATE);
            templates.add(CHECK_OUT_PROJECT_FOR_OFFLINE_MODE);
            FramePermissionTemplate templateAddFolderToProject = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, "project", true);
            FramePermissionTemplate templateAddFolderToFolder = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            FramePermissionTemplate templateAddTemplateToProject = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, "project", true);
            FramePermissionTemplate templateAddTemplateToFolder = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            FramePermissionTemplate templateAddOutputTemplateToProject = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, "project", true);
            FramePermissionTemplate templateAddOutputTemplateToFolder = new FramePermissionTemplate("addChild", FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            FramePermissionTemplate templateDeleteFolderFromProject = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, "project", true);
            FramePermissionTemplate templateDeleteFolderFromFolder = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            FramePermissionTemplate templateDeleteTemplateFromProject = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, "project", true);
            FramePermissionTemplate templateDeleteTemplateFromFolder = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            FramePermissionTemplate templateDeleteOutputTemplateFromProject = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, "project", true);
            FramePermissionTemplate templateDeleteOutputTemplateFromFolder = new FramePermissionTemplate("deleteChild", FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, true);
            templates.add(templateAddFolderToProject);
            templates.add(templateAddFolderToFolder);
            templates.add(templateAddTemplateToProject);
            templates.add(templateAddTemplateToFolder);
            templates.add(templateAddOutputTemplateToProject);
            templates.add(templateAddOutputTemplateToFolder);
            templates.add(templateDeleteFolderFromProject);
            templates.add(templateDeleteFolderFromFolder);
            templates.add(templateDeleteTemplateFromProject);
            templates.add(templateDeleteTemplateFromFolder);
            templates.add(templateDeleteOutputTemplateFromProject);
            templates.add(templateDeleteOutputTemplateFromFolder);
        }
        return templates;
    }

    public static synchronized List<CockpitPermissionTemplate> getPermissionTemplates(String operandType) {
        ArrayList<CockpitPermissionTemplate> newTemplates;
        if (!templatesForOperandTypes.containsKey(operandType)) {
            newTemplates = new ArrayList();
            for (CockpitPermissionTemplate t : FramePermissionDefinitions.getPermissionTemplates()) {
                if (!t.getOperandType().equals(operandType)) continue;
                newTemplates.add(t);
            }
            templatesForOperandTypes.put(operandType, newTemplates);
        }
        newTemplates = templatesForOperandTypes.get(operandType);
        return newTemplates;
    }

    public static CockpitPermissionTemplate getPermissionTemplate(String operandType, String operation) {
        for (CockpitPermissionTemplate template : FramePermissionDefinitions.getPermissionTemplates(operandType)) {
            if (!template.getOperation().equals(operation)) continue;
            return template;
        }
        return null;
    }

    static String getPermissionName(CockpitPermissionTemplate template) {
        if ("PROJECT".equals(template.getSubSetType())) {
            if ("openProject".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Open_project_12");
            }
            if ("editPlan".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Edit_plans_13");
            }
            if ("modifyFolders".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Modify_folders_14");
            }
            if ("deletePlan".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Delete_plans_15");
            }
            if ("deleteProjectOnServer".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Delete_project_on_server_16");
            }
            if ("adminPermissions".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Admin_project__s_permissions_17");
            }
            if ("dump".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Dump_project_18");
            }
            if ("snapshotProject".equals(template.getOperation())) {
                return Messages.getString((String)"ProjectPermissionTemplate.Create_project_snapshot");
            }
            if ("openPublishedProject".equals(template.getOperation())) {
                return Messages.getString((String)"ProjectPermissionTemplate.Open_published_project");
            }
            if ("exportProjectTemplate".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Export_Project_Template");
            }
            if ("editStakeholders".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.Administrate_Stakeholders_19");
            }
            if ("defineAttributeTypes".equals(template.getOperation())) {
                return Messages.getString((String)"ProjectPermissionTemplate.define_custom_properties");
            }
            if ("addChild".equals(template.getOperation())) {
                ICockpitDataType dataType = FrameDataTypes.getDataType(template.getOperation2());
                return String.valueOf(Messages.getString((String)"ProjectPermissionTemplate.add1")) + dataType.getDisplayName() + Messages.getString((String)"ProjectPermissionTemplate.add2");
            }
            if ("deleteChild".equals(template.getOperation())) {
                ICockpitDataType dataType = FrameDataTypes.getDataType(template.getOperation2());
                return String.valueOf(Messages.getString((String)"ProjectPermissionTemplate.delete1")) + dataType.getDisplayName() + Messages.getString((String)"ProjectPermissionTemplate.delete2");
            }
            if ("checkOutProjectForOfflineMode".equals(template.getOperation())) {
                return Messages.getString((String)"FramePermissionConstants.CheckOutForOfflineMode");
            }
            if ("modify-category".equals(template.getOperation())) {
                return NLS.bind((String)Messages.getString((String)"FramePermissionConstants.ModifyCategory"), (Object)FrameDataTypes.getDataType(template.getOperation2()).getDisplayName());
            }
        }
        return null;
    }
}

