/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.ILockAllocator;
import com.arcway.cockpit.frame.client.project.core.locking.ILockRequestSupressor;
import com.arcway.cockpit.frame.client.project.core.locking.IProjectLockFetcher;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.locking.lockhasher.LockHasherByUID;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LockRequestSupressor
implements ILockRequestSupressor,
ILockAllocator {
    private static final ILogger logger = Logger.getLogger(LockRequestSupressor.class);
    private static final String LOCK_SUPRESSOR_GRANTED_LOCKS_FILE_NAME = "grantedlocks.data";
    private static final String LOCK_SUPRESSOR_PROJECT_LOCK_FILE_NAME = "projectlock.data";
    private static final String LOCK_SUPRESSOR_INVALID_PROJECT_LOCK_FILE_NAME = "invalidprojectlock.data";
    private final ILockAllocator lockAllocator;
    private final IProjectLockFetcher projectLockFetcher;
    private ISetRW_<EOLock> grantedLocks;
    private final XMLFileAccessor<EOList<EOLock>> grantedLocksFileAccessor;
    private final XMLFileAccessor<EOLock> blockingProjectLockFileAccessor;
    private EOLock blockingProjectLock;

    private static XMLFileAccessor<EOLock> createBlockingProjectLockFileAccessor(File projectRootDirectory) {
        File projectLockFile = OfflineModeManager.getOfflineDataRelatedFile(LOCK_SUPRESSOR_PROJECT_LOCK_FILE_NAME, projectRootDirectory);
        XMLFileAccessor xmlFileAccessor = new XMLFileAccessor(projectLockFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        return xmlFileAccessor;
    }

    private static XMLFileAccessor<EOLock> createInvalidBlockingProjectLockFileAccessor(File projectRootDirectory) {
        File invalidProjectLockFile = OfflineModeManager.getOfflineDataRelatedFile(LOCK_SUPRESSOR_INVALID_PROJECT_LOCK_FILE_NAME, projectRootDirectory);
        XMLFileAccessor xmlFileAccessor = new XMLFileAccessor(invalidProjectLockFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        return xmlFileAccessor;
    }

    public static void markBlockingProjectLockAsInvalid(File projectRootDirectory) throws IOException, EXDecoderException {
        XMLFileAccessor<EOLock> xmlFileAccessorBlockingProjectLock = LockRequestSupressor.createBlockingProjectLockFileAccessor(projectRootDirectory);
        EOLock invalidBlockingProjectLock = (EOLock)xmlFileAccessorBlockingProjectLock.read();
        XMLFileAccessor<EOLock> xmlFileAccessorInvalidBlockingProjectLock = LockRequestSupressor.createInvalidBlockingProjectLockFileAccessor(projectRootDirectory);
        xmlFileAccessorInvalidBlockingProjectLock.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)invalidBlockingProjectLock));
    }

    public LockRequestSupressor(IFrameProjectAgent projectAgent, ILockAllocator lockAllocater, IProjectLockFetcher projectLockFetcher) {
        this.lockAllocator = lockAllocater;
        this.projectLockFetcher = projectLockFetcher;
        File grantedLocksFile = OfflineModeManager.getOfflineDataRelatedFile(LOCK_SUPRESSOR_GRANTED_LOCKS_FILE_NAME, projectAgent.getProjectRoot());
        this.grantedLocksFileAccessor = new XMLFileAccessor(grantedLocksFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        this.blockingProjectLockFileAccessor = LockRequestSupressor.createBlockingProjectLockFileAccessor(projectAgent.getProjectRoot());
        try {
            this.checkForInvalidProjectLock(projectAgent.getProjectRoot());
            this.blockingProjectLock = this.readProjectLock();
            this.readGrantedLocks();
        }
        catch (Exception e) {
            logger.error("Unable to read lock data from file.", (Throwable)e);
        }
    }

    @Override
    public List<Collection<EOLock>> atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> clientLocksNeededByServer, Collection<EOLock> locksToBeSet) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        ArrayList<Collection<EOLock>> response = new ArrayList<EOList>();
        if (this.blockingProjectLock != null) {
            this.grantedLocks.addAll(locksToBeSet);
            response.add((Collection<EOLock>)new EOList());
            response.add(locksToBeSet);
            this.writeGrantedLocks();
        } else {
            response = this.lockAllocator.atomicCheckAndSetLocks(locksToBeChecked, clientLocksNeededByServer, locksToBeSet);
        }
        return response;
    }

    @Override
    public void releaseLocks(Collection<EOLock> locksToBeReleased) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        if (this.blockingProjectLock != null) {
            ArrayList_ locksNotInGrantedLocks = new ArrayList_();
            for (EOLock eoLock : locksToBeReleased) {
                EOLock result = (EOLock)this.grantedLocks.remove((Object)eoLock);
                if (result != null) continue;
                locksNotInGrantedLocks.add((Object)eoLock);
            }
            assert (locksNotInGrantedLocks.isEmpty()) : "should no longer happen see bugfixes #2612/#2657";
            this.writeGrantedLocks();
        } else {
            this.lockAllocator.releaseLocks(locksToBeReleased);
        }
    }

    @Override
    public List<EOLock> getForeignLocks(Collection<EOLock> clientLocksNeededByServer, boolean considerCommitVersion) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        return this.lockAllocator.getForeignLocks(clientLocksNeededByServer, considerCommitVersion);
    }

    private void readGrantedLocks() throws Exception {
        EOList initialLocks = (EOList)this.grantedLocksFileAccessor.read();
        this.grantedLocks = new HashSet_(LockHasherByUID.INSTANCE);
        if (initialLocks != null) {
            this.grantedLocks.addAll((Collection)initialLocks);
        }
    }

    private void writeGrantedLocks() {
        this.grantedLocksFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOLock>>(){

            public EOList<EOLock> getFileContent() {
                EOList fileContent;
                if (LockRequestSupressor.this.grantedLocks.isEmpty()) {
                    fileContent = null;
                } else {
                    EOList locksToWrite = new EOList();
                    locksToWrite.addAll((Collection)LockRequestSupressor.this.grantedLocks.asJavaSet());
                    fileContent = locksToWrite;
                }
                return fileContent;
            }
        });
    }

    @Override
    public LockResult setBlockingProjectLock(Collection<EOLock> projectLocksClientAlreadyOwns) {
        boolean wasSuccessful = true;
        EOLock blockingProjectLockToFetch = this.projectLockFetcher.generateProjectLock("project_lock_exclusive");
        EOLock blockOfflineModeProjectLock = this.projectLockFetcher.generateProjectLock("project_lock_block_offline");
        EOList locksToBeChecked = new EOList();
        EOList locksToBeSet = new EOList();
        locksToBeChecked.add(blockOfflineModeProjectLock);
        locksToBeChecked.add(blockingProjectLockToFetch);
        locksToBeSet.add(blockingProjectLockToFetch);
        Throwable serverException = null;
        Object conflictingLocks = new EOList();
        Object addedLocks = new EOList();
        try {
            List<Collection<EOLock>> response = this.lockAllocator.atomicCheckAndSetLocks((Collection<EOLock>)locksToBeChecked, projectLocksClientAlreadyOwns, (Collection<EOLock>)locksToBeSet);
            conflictingLocks = response.get(0);
            addedLocks = response.get(1);
            if (conflictingLocks.size() > 0) {
                wasSuccessful = false;
            }
            if (addedLocks.size() == 1) {
                this.blockingProjectLock = (EOLock)addedLocks.iterator().next();
            } else {
                wasSuccessful = false;
            }
            this.writeProjectLock(this.blockingProjectLock);
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
            wasSuccessful = false;
            logger.error("Cannot fetch blocking project lock.", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            serverException = e;
            wasSuccessful = false;
            logger.error("Cannot fetch blocking project lock.", (Throwable)e);
        }
        catch (EXServerException e) {
            serverException = e;
            wasSuccessful = false;
            logger.error("Cannot fetch blocking project lock.", (Throwable)e);
        }
        catch (UnknownServerException e) {
            serverException = e;
            wasSuccessful = false;
            logger.error("Cannot fetch blocking project lock.", (Throwable)e);
        }
        return new LockResult(wasSuccessful, (Collection<EOLock>)conflictingLocks, (Collection<EOLock>)addedLocks, projectLocksClientAlreadyOwns, (Exception)serverException);
    }

    @Override
    public void releaseBlockingProjectLock() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        if (this.grantedLocks.size() > 0) {
            List<Collection<EOLock>> projectLocksValidationResponse = this.lockAllocator.atomicCheckAndSetLocks(Collections.singletonList(this.blockingProjectLock), Collections.emptyList(), Collections.emptyList());
            HashSet_ allBlockingProjectLocksAllocatedOnServer = new HashSet_(LockHasherByUID.INSTANCE);
            allBlockingProjectLocksAllocatedOnServer.addAll(projectLocksValidationResponse.get(0));
            if (!allBlockingProjectLocksAllocatedOnServer.contains((Object)this.blockingProjectLock)) {
                throw new EXServerException("frame.locks", "NotFound", "The Offline lock was removed meanwhile. Can not switch back to online mode, because the projct data may be corrupted be doing so.");
            }
            this.lockAllocator.atomicCheckAndSetLocks((Collection<EOLock>)new EOList(), (Collection<EOLock>)new EOList(), this.grantedLocks.asJavaSet());
        }
        this.grantedLocks.clear();
        this.writeGrantedLocks();
        this.lockAllocator.releaseLocks(Collections.singletonList(this.blockingProjectLock));
        this.blockingProjectLock = null;
        this.writeProjectLock(this.blockingProjectLock);
    }

    @Override
    public ISet_<EOLock> getSupressedLocks() {
        return this.grantedLocks;
    }

    @Override
    public EOLock getBlockingProjectLock() {
        return this.blockingProjectLock;
    }

    private void checkForInvalidProjectLock(File projectRootDirectory) throws Exception {
        XMLFileAccessor<EOLock> invalidBlockingProjectLockFileAccessor = LockRequestSupressor.createInvalidBlockingProjectLockFileAccessor(projectRootDirectory);
        EOLock invalidBlockingProjectLock = (EOLock)invalidBlockingProjectLockFileAccessor.read();
        if (invalidBlockingProjectLock != null) {
            EOList locksToBeReleased = new EOList();
            locksToBeReleased.add(invalidBlockingProjectLock);
            this.lockAllocator.releaseLocks((Collection<EOLock>)locksToBeReleased);
            invalidBlockingProjectLockFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
            this.blockingProjectLock = null;
            this.writeProjectLock(this.blockingProjectLock);
        }
    }

    private EOLock readProjectLock() throws Exception {
        return (EOLock)this.blockingProjectLockFileAccessor.read();
    }

    private void writeProjectLock(EOLock blockingProjectLockToStore) {
        this.blockingProjectLockFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)blockingProjectLockToStore));
    }
}

