/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.LinkStore;
import com.arcway.cockpit.frame.client.project.core.links.LinkTypeRegistry;
import com.arcway.cockpit.frame.client.project.core.links.ModificationLogMgr;
import com.arcway.cockpit.frame.client.project.core.links.VersionedLinkStore;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.exceptions.LinkModificationException;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkLog;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import com.arcway.cockpit.frame.shared.message.EOLinkedItemDeletion;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LinkAccessAgent {
    private static final ILogger logger = Logger.getLogger(LinkAccessAgent.class);
    private final LinkManager linkManager;
    private final ProjectAgent projectAgent;
    private final ModificationLogMgr modLogMgr;
    private final AtomicModificationDataAccessor atomicModificationDataAccessor;
    private final Map<String, LinkStore> mapLinkTypeUID_linkCategoryStore;
    private final Map<String, VersionedLinkStore> mapLinkTypeUID_versionedStore;
    private boolean errorsWhileProjectDownload = false;
    private final LinkTypeRegistry linkTypeRegistry;

    public LinkAccessAgent(LinkManager manager, LinkTypeRegistry linkTypeRegistry, ProjectAgent projectAgent) {
        assert (manager != null) : "manager must not be null";
        assert (linkTypeRegistry != null) : "linkTypeRegistry must not be null";
        assert (projectAgent != null);
        this.linkManager = manager;
        this.projectAgent = projectAgent;
        this.linkTypeRegistry = linkTypeRegistry;
        this.atomicModificationDataAccessor = projectAgent.getAtomicModificationDataAccessor();
        this.modLogMgr = new ModificationLogMgr(this, this.linkTypeRegistry);
        this.mapLinkTypeUID_linkCategoryStore = new HashMap<String, LinkStore>();
        this.mapLinkTypeUID_versionedStore = new HashMap<String, VersionedLinkStore>();
    }

    public void initialize() {
    }

    public void clearLocalModifications() {
        this.modLogMgr.cleanupCommitModifications();
        this.modLogMgr.resetDirtyFlag();
        this.saveModificationsIfSavingIsEnabled();
    }

    public void createLinkStoreForLinkType(ILinkType type) {
        LinkStore store = new LinkStore(type);
        this.mapLinkTypeUID_linkCategoryStore.put(type.getUID(), store);
        VersionedLinkStore versionStore = new VersionedLinkStore(type);
        this.mapLinkTypeUID_versionedStore.put(type.getUID(), versionStore);
    }

    public void addLinkVersion(EOLinkLog link) throws LinkModificationException {
        this.checkAddition((EOLink)link, false, true);
        VersionedLinkStore store = this.mapLinkTypeUID_versionedStore.get(link.getLinkTypeID());
        store.addLink(link);
    }

    public Collection<EOLink> addLinks(Collection<EOLink> links) {
        final HashSet<EOLink> addedLinks = new HashSet<EOLink>(links);
        assert (this.projectAgent.getModelTransactionManager().isInTransaction());
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                Iterator i = addedLinks.iterator();
                while (i.hasNext()) {
                    EOLink link = (EOLink)i.next();
                    try {
                        LinkAccessAgent.this.addLink(link);
                    }
                    catch (LinkModificationException e) {
                        i.remove();
                    }
                }
            }
        });
        return addedLinks;
    }

    public void addLink(EOLink link) throws LinkModificationException {
        this.addToMaps(link, false, false);
        this.modLogMgr.addLink(link);
        this.saveModificationsIfSavingIsEnabled();
    }

    private void addToMaps(EOLink link, boolean checkOnServerState, boolean force) throws LinkModificationException {
        this.checkAddition(link, checkOnServerState, force);
        ILinkType type = this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID());
        if (type != null) {
            LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(type.getUID());
            store.addLink(link);
        }
    }

    protected boolean checkAdditionCardinality(EOLink link) {
        assert (link != null) : "link must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(link.getLinkTypeID());
        if (store != null) {
            Set<EOLink> moduleDataSet = store.getLinksForModuleDataItem(link.getModuleDataUID());
            int moduleDataSize = moduleDataSet.size();
            Set<EOLink> linkableObjectSet = store.getLinksForLinkableObject(link.getLinkableObjectUID());
            int linkableObjectSize = linkableObjectSet.size();
            if (!moduleDataSet.contains(link) && !linkableObjectSet.contains(link)) {
                ++moduleDataSize;
                ++linkableObjectSize;
            }
            return this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()).getCardinality().checkCardinality(moduleDataSize, linkableObjectSize);
        }
        logger.warn("checkAddition: unknown link type");
        return false;
    }

    public void deleteLink(EOLink link) throws LinkModificationException {
        assert (link != null) : "link must not be null";
        this.deleteLink_internal(link);
        this.saveModificationsIfSavingIsEnabled();
    }

    private void deleteLink_internal(EOLink link) throws LinkModificationException {
        assert (link != null) : "link must not be null";
        boolean success = this.removeFromMaps(link, false);
        if (success) {
            this.modLogMgr.deleteLink(link);
        }
    }

    public void deleteLinkVersion(EOLinkLog link) {
        VersionedLinkStore store = this.mapLinkTypeUID_versionedStore.get(link.getLinkTypeID());
        store.removeLink(link);
    }

    private boolean removeFromMaps(EOLink link, boolean force) throws LinkModificationException {
        boolean success = false;
        this.checkDeletion(link, force);
        ILinkType type = this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID());
        if (type != null) {
            LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(type.getUID());
            success = store.removeLink(link);
        }
        return success;
    }

    protected boolean checkDeletionCardinality(EOLink link) {
        assert (link != null) : "link must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(link.getLinkTypeID());
        Set<EOLink> moduleDataSet = store.getLinksForModuleDataItem(link.getModuleDataUID());
        int moduleDataSize = moduleDataSet.size();
        Set<EOLink> linkableObjectSet = store.getLinksForLinkableObject(link.getLinkableObjectUID());
        int linkableObjectSize = linkableObjectSet.size();
        if (moduleDataSet.contains(link) || linkableObjectSet.contains(link)) {
            --moduleDataSize;
            --linkableObjectSize;
        }
        return this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()).getCardinality().checkCardinality(moduleDataSize, linkableObjectSize);
    }

    protected void checkAddition(EOLink link, boolean checkOnServerState, boolean force) throws LinkModificationException {
        assert (link != null) : "link must not be null";
        int failureReason = -1;
        int runLevel = this.linkManager.getRunLevel();
        if (runLevel == 0) {
            failureReason = 6;
        } else if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
            if (!force) {
                if (!this.linkManager.linkableObjectExists(link, checkOnServerState)) {
                    failureReason = 2;
                } else if (!this.linkManager.moduleDataItemExists(link, checkOnServerState)) {
                    failureReason = 1;
                } else if (!this.checkAdditionCardinality(link)) {
                    failureReason = 4;
                }
            }
        } else {
            failureReason = 5;
        }
        if (failureReason != -1) {
            LinkModificationException lmE = new LinkModificationException(link, 1, failureReason, this.linkManager.getRunLevel());
            logger.warn((Throwable)lmE);
            throw lmE;
        }
    }

    protected void checkDeletion(EOLink link, boolean force) throws LinkModificationException {
        assert (link != null) : "link must not be null";
        int failureReason = -1;
        int runLevel = this.linkManager.getRunLevel();
        if (runLevel == 0) {
            failureReason = 6;
        } else if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
            if (!force && !this.checkDeletionCardinality(link)) {
                failureReason = 4;
            }
        } else {
            failureReason = 5;
        }
        if (failureReason != -1) {
            LinkModificationException lmE = new LinkModificationException(link, 2, failureReason, this.linkManager.getRunLevel());
            logger.warn((Throwable)lmE);
            throw lmE;
        }
    }

    protected boolean checkOnExistence(EOLink link) {
        assert (link != null) : "link must not be null";
        return this.linkManager.moduleDataItemExists(link, false) && this.linkManager.linkableObjectExists(link, false);
    }

    protected void loadLinksFromServer(ServerDataContainer serverDataContainer) {
        Collection<EOLink> serverLinks = serverDataContainer.getLinks();
        HashSet<String> ignoredLinkTypes = new HashSet<String>();
        Iterator<EOLink> linkIterator = serverLinks.iterator();
        while (linkIterator.hasNext()) {
            EOLink serverLink = linkIterator.next();
            if (this.linkTypeRegistry.getLinkTypeByUID(serverLink.getLinkTypeID()) != null) continue;
            linkIterator.remove();
            if (ignoredLinkTypes.contains(serverLink.getLinkTypeID())) continue;
            logger.info("Ignored links of type \"" + serverLink.getLinkTypeID() + "\" while loading server state.");
            ignoredLinkTypes.add(serverLink.getLinkTypeID());
        }
        for (EOLink link : serverLinks) {
            try {
                this.addToMaps(link, true, false);
            }
            catch (LinkModificationException e1) {
                this.modLogMgr.deleteLink(link);
                this.errorsWhileProjectDownload = true;
            }
        }
    }

    protected void loadSavedModifications() throws EXCorruptProjectData {
        try {
            EOLinkModificationContainer container = this.modLogMgr.readSavedModifications((IEncodableObjectFactory)MessageDataFactory.getInstance());
            this.modLogMgr.deleteSavedModifications();
            if (container != null) {
                this.applyModifications(container);
                this.modLogMgr.setSavedModifications(container);
            } else if (this.errorsWhileProjectDownload) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("LinkAccessAgent.Inconsistencies_repaired_WindowTitle"), (String)(String.valueOf(Messages.getString("LinkAccessAgent.Inconsistencies_repaired_Description_1")) + Messages.getString("LinkAccessAgent.Inconsistencies_repaired_Description_2")));
                    }
                });
                this.saveModificationsIfSavingIsEnabled();
                this.errorsWhileProjectDownload = false;
            }
        }
        catch (Exception e) {
            logger.error("Could not load link modifications.", (Throwable)e);
            throw new EXCorruptProjectData("Could not load link modifications.", e);
        }
    }

    private void saveModificationsIfSavingIsEnabled() {
        this.atomicModificationDataAccessor.saveModificationsIfSavingIsEnabled();
        this.projectAgent.fireCommitStateChange();
    }

    public void discardSavedModifications() {
        EOLinkModificationContainer modifications = this.modLogMgr.cleanupCommitModifications();
        HashSet<String> leftOverLinkTypes = new HashSet<String>();
        leftOverLinkTypes.addAll(this.rollBackModifications(modifications));
        for (String linkTypeID : leftOverLinkTypes) {
            logger.warn("Left-over link modifications for link type " + linkTypeID + " have been discarded.");
        }
    }

    public Set<EOLink> deleteLinksForLinkedItem(String linkedItemUID, String dataTypeID) {
        assert (linkedItemUID != null) : "linkableObjectUID must not be null";
        assert (dataTypeID != null) : "data type id must not be null";
        HashSet<EOLink> deletedLinks = new HashSet<EOLink>();
        Set<ILinkType> LOLinkTypes = this.linkTypeRegistry.getLinkTypesByLinkableObjectTypeID(dataTypeID);
        ArrayList<String> LOLinkTypeIDs = new ArrayList<String>();
        for (ILinkType type : LOLinkTypes) {
            LOLinkTypeIDs.add(type.getUID());
            LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(type.getUID());
            deletedLinks.addAll(store.removeLinksForLinkableObject(linkedItemUID));
        }
        Set<ILinkType> MDLinkTypes = this.linkTypeRegistry.getLinkTypesByModuleDataTypeID(dataTypeID);
        ArrayList<String> MDLinkTypeIDs = new ArrayList<String>();
        for (ILinkType type : MDLinkTypes) {
            MDLinkTypeIDs.add(type.getUID());
            LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(type.getUID());
            deletedLinks.addAll(store.removeLinksForModuleDataItem(linkedItemUID));
        }
        this.modLogMgr.linkedItemDeleted(linkedItemUID, dataTypeID, LOLinkTypeIDs, MDLinkTypeIDs);
        for (EOLink link : deletedLinks) {
            this.modLogMgr.deleteLink(link);
        }
        this.saveModificationsIfSavingIsEnabled();
        return deletedLinks;
    }

    private Collection<EOLink> retraceLODeletion(String linkableObjectUID, String linkTypeID) {
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        HashSet<EOLink> deletedLinks = new HashSet<EOLink>();
        ILinkType type = this.linkTypeRegistry.getLinkTypeByUID(linkTypeID);
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(type.getUID());
        deletedLinks.addAll(store.removeLinksForLinkableObject(linkableObjectUID));
        for (EOLink link : deletedLinks) {
            this.modLogMgr.removeAdditionLog(link);
        }
        this.saveModificationsIfSavingIsEnabled();
        return deletedLinks;
    }

    private Collection<EOLink> retraceMDDeletion(String moduleDataItemID, String linkTypeID) {
        assert (moduleDataItemID != null) : "moduleDataItemID must not be null";
        assert (linkTypeID != null) : "linkTypeID must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(linkTypeID);
        Set<EOLink> deletedLinks = store.removeLinksForModuleDataItem(moduleDataItemID);
        for (EOLink link : deletedLinks) {
            this.modLogMgr.removeAdditionLog(link);
        }
        this.saveModificationsIfSavingIsEnabled();
        return deletedLinks;
    }

    private Set<String> rollBackModifications(EOLinkModificationContainer container) {
        return this.applyModifications(container, true, true);
    }

    private void applyModifications(EOLinkModificationContainer container) {
        this.applyModifications(container, false, false);
    }

    private Set<String> applyModifications(EOLinkModificationContainer container, boolean reverse, boolean force) {
        assert (container != null) : "container must not be null";
        HashSet<String> ignoredLinkTypes = new HashSet<String>();
        EOList additions = container.getInsertLinks();
        EOList deletions = container.getDeleteLinks();
        HashSet<String> linkTypes = new HashSet<String>();
        Iterator toBeDeleted = reverse ? additions.iterator() : deletions.iterator();
        while (toBeDeleted.hasNext()) {
            EOLink link = (EOLink)toBeDeleted.next();
            if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                linkTypes.add(link.getLinkTypeID());
                try {
                    this.removeFromMaps(link, force);
                }
                catch (LinkModificationException e) {
                    toBeDeleted.remove();
                }
                continue;
            }
            toBeDeleted.remove();
            if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
            logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" " + (reverse ? "during synchronous update." : "while loading local modifications."));
            ignoredLinkTypes.add(link.getLinkTypeID());
        }
        Iterator toBeAdded = reverse ? deletions.iterator() : additions.iterator();
        while (toBeAdded.hasNext()) {
            EOLink link = (EOLink)toBeAdded.next();
            if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                linkTypes.add(link.getLinkTypeID());
                try {
                    this.addToMaps(link, false, force);
                }
                catch (LinkModificationException e) {
                    logger.warn("Could not add link addition", (Throwable)e);
                    toBeAdded.remove();
                }
                continue;
            }
            toBeAdded.remove();
            if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
            logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" " + (reverse ? "during synchronous update." : "while loading local modifications."));
            ignoredLinkTypes.add(link.getLinkTypeID());
        }
        return linkTypes;
    }

    public boolean hasUncommitedChangesForProject(String linkTypeID) {
        return this.modLogMgr.hasCommitChangesForProject(linkTypeID);
    }

    public EOList<EOLinkModificationContainer> getChangesForProject(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        EOLinkModificationContainer container = this.modLogMgr.getCommitChangesForProject(linkTypeID);
        EOList modifications = new EOList(1);
        modifications.add((EncodableObjectBase)container);
        return modifications;
    }

    public EOLinkModificationContainer getChangesForProject() {
        return this.modLogMgr.getCommitChanges();
    }

    protected void applySynchronousModificationsFromServer(EOList<EOLinkModificationContainer> modifications) {
        assert (modifications != null) : "modifications must not be null";
        HashSet<String> ignoredLinkTypes = new HashSet<String>();
        for (EOLinkModificationContainer modification : modifications) {
            for (EOLink link : modification.getInsertLinks()) {
                if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                    this.modLogMgr.removeAdditionLog(link);
                    continue;
                }
                if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
                logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" during synchronous update.");
                ignoredLinkTypes.add(link.getLinkTypeID());
            }
            for (EOLink link : modification.getDeleteLinks()) {
                if (this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                    this.modLogMgr.removeDeletion(link);
                    continue;
                }
                if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
                logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" during synchronous update.");
                ignoredLinkTypes.add(link.getLinkTypeID());
            }
            this.discardSavedModifications();
        }
        this.modLogMgr.resetDirtyFlag();
    }

    public synchronized boolean applyAsynchronousModificationsFromServer(final EOList<EOLinkModificationContainer> modifications, final Collection<EOLink> linksAddedDuringUpdate, final Collection<EOLink> linksDeletedDuringUpdate) {
        assert (modifications != null) : "modifications must not be null";
        final HashSet ignoredLinkTypes = new HashSet();
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (EOLinkModificationContainer container : modifications) {
                    for (EOLink link : container.getDeleteLinks()) {
                        if (LinkAccessAgent.this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                            try {
                                LinkAccessAgent.this.removeFromMaps(link, false);
                                LinkAccessAgent.this.modLogMgr.removeDeletion(link);
                                linksDeletedDuringUpdate.add(link);
                            }
                            catch (LinkModificationException e) {
                                LinkAccessAgent.this.modLogMgr.addLink(link);
                                logger.debug("async update: could not delete link: ", (Throwable)e);
                            }
                            continue;
                        }
                        if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
                        logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" during asynchronous update.");
                        ignoredLinkTypes.add(link.getLinkTypeID());
                    }
                    for (EOLinkedItemDeletion deletion : container.getDeletedLinkedItems()) {
                        Collection deletedLinks;
                        String linkTypeID;
                        for (ILinkType loLinkType : LinkAccessAgent.this.linkTypeRegistry.getLinkTypesByLinkableObjectTypeID(deletion.getLinkedItemTypeID())) {
                            linkTypeID = loLinkType.getUID();
                            if (LinkAccessAgent.this.linkTypeRegistry.getLinkTypeByUID(linkTypeID) != null) {
                                deletedLinks = LinkAccessAgent.this.retraceLODeletion(deletion.getLinkedItemUID(), linkTypeID);
                                linksDeletedDuringUpdate.addAll(deletedLinks);
                                continue;
                            }
                            if (ignoredLinkTypes.contains(linkTypeID)) continue;
                            logger.info("Ignored links of type \"" + linkTypeID + "\" during asynchronous update.");
                            ignoredLinkTypes.add(linkTypeID);
                        }
                        for (ILinkType mdLinkType : LinkAccessAgent.this.linkTypeRegistry.getLinkTypesByModuleDataTypeID(deletion.getLinkedItemTypeID())) {
                            linkTypeID = mdLinkType.getUID();
                            if (LinkAccessAgent.this.linkTypeRegistry.getLinkTypeByUID(linkTypeID) != null) {
                                deletedLinks = LinkAccessAgent.this.retraceMDDeletion(deletion.getLinkedItemUID(), linkTypeID);
                                linksDeletedDuringUpdate.addAll(deletedLinks);
                                continue;
                            }
                            if (ignoredLinkTypes.contains(linkTypeID)) continue;
                            logger.info("Ignored links of type \"" + linkTypeID + "\" during asynchronous update.");
                            ignoredLinkTypes.add(linkTypeID);
                        }
                    }
                    for (EOLink link : container.getInsertLinks()) {
                        if (LinkAccessAgent.this.linkTypeRegistry.getLinkTypeByUID(link.getLinkTypeID()) != null) {
                            try {
                                LinkAccessAgent.this.addToMaps(link, false, false);
                                LinkAccessAgent.this.modLogMgr.removeAdditionLog(link);
                                linksAddedDuringUpdate.add(link);
                            }
                            catch (LinkModificationException e) {
                                LinkAccessAgent.this.modLogMgr.deleteLink(link);
                                logger.debug("async update: could not add link: ", (Throwable)e);
                            }
                            continue;
                        }
                        if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
                        logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" during asynchronous update.");
                        ignoredLinkTypes.add(link.getLinkTypeID());
                    }
                    PropertyChanges changes = new PropertyChanges((Collection)container.getInsertLinks(), null, (Collection)container.getDeleteLinks(), true);
                    LinkAccessAgent.this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, EOLink.class);
                }
            }
        });
        return this.modLogMgr.hasCommitChanges();
    }

    public boolean hasCommitChanges() {
        return this.modLogMgr.isDirty();
    }

    protected String getProjectUID() {
        return this.projectAgent.getProjectUID();
    }

    public Set<EOLink> getLinksOfLinkTypeForModuleDataItem(ILinkType linkType, String moduleDataUID) {
        assert (linkType != null) : "linkType must not be null";
        assert (moduleDataUID != null) : "moduleDataUID must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(linkType.getUID());
        return store.getLinksForModuleDataItem(moduleDataUID);
    }

    public Set<EOLinkLog> getVersionedLinksOfLinkTypeForModuleDataItem(ILinkType linkType, String moduleDataUID, int modCount) {
        assert (linkType != null) : "linkType must not be null";
        assert (moduleDataUID != null) : "moduleDataUID must not be null";
        VersionedLinkStore store = this.mapLinkTypeUID_versionedStore.get(linkType.getUID());
        return store.getLinksForModuleDataItem(moduleDataUID, modCount);
    }

    public Set<EOLink> getLinksOfLinkTypeForLinkableObject(ILinkType linkType, String linkableObjectUID) {
        assert (linkType != null) : "linkType must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(linkType.getUID());
        return store.getLinksForLinkableObject(linkableObjectUID);
    }

    public Set<EOLinkLog> getVersionedLinksOfLinkTypeForLinkableObject(ILinkType linkType, String linkableObjectUID, int modCount) {
        assert (linkType != null) : "linkType must not be null";
        assert (linkableObjectUID != null) : "linkableObjectID must not be null";
        VersionedLinkStore store = this.mapLinkTypeUID_versionedStore.get(linkType.getUID());
        return store.getLinksForLinkableObject(linkableObjectUID, modCount);
    }

    public ISetMapWithFixReturnSetsRO<String, EOLink> getLinksForLinkTypeMappedByLinkableObjectUID(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(linkTypeID);
        return store.getLinkableObjectMapping();
    }

    protected boolean linkExists(EOLink link) {
        assert (link != null) : "link must not be null";
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(link.getLinkTypeID());
        return store.linkExists(link);
    }

    public boolean isLinkedItemDeleted(String linkedItemUID) {
        return this.modLogMgr.isLinkedItemDeleted(linkedItemUID);
    }

    public Set<EOLink> getAllLinks(ILinkType linkType) {
        LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(linkType.getUID());
        return store.getAllStoredLinks();
    }

    public Set<EOLinkLog> getVersionedLinksForLinkableObject(String dataTypeID, String objectUID, int modCount) {
        HashSet<EOLinkLog> links = new HashSet<EOLinkLog>();
        Set<ILinkType> linkTypes = this.linkTypeRegistry.getLinkTypesByLinkableObjectTypeID(dataTypeID);
        for (ILinkType linkType : linkTypes) {
            VersionedLinkStore store = this.mapLinkTypeUID_versionedStore.get(linkType.getUID());
            links.addAll(store.getLinksForLinkableObject(objectUID, modCount));
        }
        return links;
    }

    public Set<EOLink> getLinksForLinkableObject(String dataTypeID, String linkableObjectUID) {
        assert (dataTypeID != null) : "loProviderID must not be null";
        assert (linkableObjectUID != null) : "linkableObjectUID must not be null";
        HashSet<EOLink> links = new HashSet<EOLink>();
        for (ILinkType lt : this.linkTypeRegistry.getLinkTypesByLinkableObjectTypeID(dataTypeID)) {
            LinkStore store = this.mapLinkTypeUID_linkCategoryStore.get(lt.getUID());
            links.addAll(store.getLinksForLinkableObject(linkableObjectUID));
        }
        return links;
    }

    public Collection<EOLink> deleteLinks(Collection<EOLink> links) {
        ArrayList<EOLink> successfullyDeletedLinks = new ArrayList<EOLink>(links.size());
        for (EOLink link : links) {
            try {
                this.deleteLink_internal(link);
                successfullyDeletedLinks.add(link);
            }
            catch (LinkModificationException linkModificationException) {
                // empty catch block
            }
        }
        this.saveModificationsIfSavingIsEnabled();
        return successfullyDeletedLinks;
    }

    public boolean hasModifiedLink(String dataUID) {
        return this.modLogMgr.hasModifiedLink(dataUID);
    }

    public boolean hasModifiedLinks(String linkTypeID) {
        return this.modLogMgr.hasModifiedLinks(linkTypeID);
    }

    public AtomicModificationDataAccessor getAtomicModificationDataAccessor() {
        return this.atomicModificationDataAccessor;
    }
}

