/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.objecttypes;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportOutputtemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;

public class ObjectTypeReportOutputtemplate
implements IFrameDataTypeDescription {
    private static final ILogger logger = Logger.getLogger(ObjectTypeReportOutputtemplate.class);

    public String getCockpitDataTypeID() {
        return FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE;
    }

    public String getDisplayName() {
        return Messages.getString("FrameDataTypes.outputtemplate");
    }

    @Override
    public String getDisplayName(Locale locale) {
        return Messages.getString("FrameDataTypes.outputtemplate", locale);
    }

    public Image getIcon() {
        return Icons.getImageForReportOutputtemplate();
    }

    public Collection<IAttributeType> getAttributeTypes(IProjectAgent projectAgent) {
        IAttributeTypesProvider planAttributeTypesProv = ((IFrameProjectAgent)projectAgent).getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE);
        return planAttributeTypesProv.getAttributeTypes();
    }

    public Image getImage(ICockpitProjectData data) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
        IReportOutputtemplateRW reportOutputtemplate = (IReportOutputtemplateRW)data;
        String reportOutputTemplateTypeID = reportOutputtemplate.getReportOutputTemplateTypeID();
        IReportOutputTemplateType reportOutputTemplateType = projectAgent.getDocGeneratorManager().getReportOutputTemplateType(reportOutputTemplateTypeID);
        Image image = null;
        if (reportOutputTemplateType != null) {
            String extension = null;
            File outputTemplateFile = reportOutputtemplate.getFile();
            if (outputTemplateFile != null) {
                extension = FileHelper.getFileExtension((File)outputTemplateFile).toLowerCase();
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)outputTemplateFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.warn("Could not delete output template file.", (Throwable)e);
                }
            }
            if (extension == null || !reportOutputTemplateType.getPossibleFileExtensions().contains(extension)) {
                extension = reportOutputTemplateType.getPossibleFileExtensions().iterator().next();
            }
            String dummyFileName = "file." + extension;
            image = Icons.getFileImage(dummyFileName);
        } else {
            image = Icons.getUnknownImage();
        }
        return image;
    }

    public String getDisplayName(ICockpitProjectData data) {
        IReportOutputtemplateRW template = (IReportOutputtemplateRW)data;
        return template.getName();
    }

    public boolean isSupportingCategories() {
        return false;
    }
}

