/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IAttributeFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.AbstractDataType;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.AttributeSubstringFilterItem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.StringAttributeFilter;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DataTypeString
extends AbstractDataType
implements IEncodableObjectFactory {
    private static final DataTypeString INSTANCE = new DataTypeString();
    public static final String DATA_TYPE_ID = "string";

    public static DataTypeString getInstanceString() {
        return INSTANCE;
    }

    protected DataTypeString() {
    }

    public boolean supportsValue(Object value, IValueRange valueRange) {
        return value instanceof String;
    }

    public Object getCopy(Object originalValue, IValueRange valueRange) {
        if (!this.supportsValue(originalValue, valueRange)) {
            throw new ExInvalidDataType(originalValue.getClass().toString(), String.class.toString());
        }
        return originalValue;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return Messages.getString("DataTypeString.string", locale);
    }

    public EOEncodableObject getValueAsEO(Object value, IValueRange baseValueRange) throws ExInvalidDataType {
        if (!(value instanceof String)) {
            throw new ExInvalidDataType(value.getClass().toString(), this.getDisplayName());
        }
        String string = (String)value;
        if (this instanceof DataTypeText) {
            string = StringUtil.replaceLineBreaksWithWindowsLineBreaks((String)string);
        }
        return new EOString(string);
    }

    public Object getEOAsValue(EOEncodableObject eo) throws ExInvalidDataType {
        if (!(eo instanceof EOString)) {
            throw new ExInvalidDataType(eo.getClass().toString(), EOString.class.toString());
        }
        EOString eoString = (EOString)eo;
        return this.getAttributeValueFromString(eoString.getString(), null, null);
    }

    public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
        if (name.equals("frame.datatype.string")) {
            return new EOString();
        }
        return null;
    }

    public String getID() {
        return DATA_TYPE_ID;
    }

    @Override
    protected final AbstractDataType.SWTControlForModification createSWTControlForModifying_internal(Composite parent, Object initialValue, IValueRange valueRange) {
        final Text text = this.createTextControlForModifying(parent);
        text.setText(this.getValueAsString(initialValue));
        final AbstractDataType.SWTControlForModification wrapper = new AbstractDataType.SWTControlForModification(this, (Control)text, null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataTypeString.this.informSWTModifyListeners(wrapper, DataTypeString.this.getAttributeValueFromSWTControl(text), null);
            }
        });
        return wrapper;
    }

    protected Text createTextControlForModifying(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Object getAttributeValueFromSWTControl(Text text) throws ExInvalidDataType {
        String str = text.getText();
        if (str == null) {
            str = "";
        }
        return this.getAttributeValueFromString(str, null, null);
    }

    public Control createSWTControlForViewing(Composite parent, Object value, IValueRange valueRange) throws ExInvalidDataType {
        if (!(value instanceof String)) {
            throw new ExInvalidDataType(value.getClass().toString(), String.class.toString());
        }
        StyledText text = new StyledText(parent, 66);
        text.setText(this.getValueAsString(value));
        text.setEditable(false);
        return text;
    }

    public String getValueAsSingleLineString(Object value, IValueRange valueRange, String separator, Locale locale) {
        return StringUtil.removeNewlines((String)((String)value));
    }

    protected String getValueAsString(Object value) {
        return (String)value;
    }

    public Object getDefaultValue() {
        return "";
    }

    public IValueRangeDefiner getValueRangeHelper() {
        return null;
    }

    @Override
    public IAttributeFilter getFilter() {
        return StringAttributeFilter.getInstance();
    }

    @Override
    public IFilterItem createFilterItem(String filterName, AbstractFilter filter, IValueRange vaueRange) {
        return new AttributeSubstringFilterItem(filterName, filter, this);
    }

    public int getSWTHeightHint() {
        return -1;
    }

    public Comparator getComparator(IValueRange valueRange) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return s1.compareToIgnoreCase(s2);
                }
                catch (ClassCastException e) {
                    return 0;
                }
            }
        };
    }

    public Object getAttributeValueFromString(String valueAsString, IValueRange valueRange, String separator) {
        return valueAsString;
    }
}

