/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.locking.LockTypeDescriptionProvider;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class ModificationProblem
implements IModificationProblem {
    private String humanReadableDescriptionOfCause;
    private String humanReadableDescriptionOfConsequence;
    private int severity = 2;
    private EOLock conflictingLock = null;
    private String noPermissionText = null;

    public static void interpretateAsPlatformProblem(IModificationProblem modificationProblems) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        ModificationProblem.interpretateAsPlatformProblem(Collections.singleton(modificationProblems));
    }

    public static void interpretateAsPlatformProblem(Collection<? extends IModificationProblem> modificationProblems) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        ArrayList<EOLock> conflictingEOLocks = new ArrayList<EOLock>();
        ArrayList<String> detailedLockReasons = new ArrayList<String>();
        ArrayList<String> noPermissionTexts = new ArrayList<String>();
        for (IModificationProblem iModificationProblem : modificationProblems) {
            IModificationProblem currentModificationProblem;
            if (iModificationProblem instanceof ModificationProblem) {
                currentModificationProblem = (ModificationProblem)iModificationProblem;
                if (currentModificationProblem.conflictingLock != null) {
                    if (currentModificationProblem.humanReadableDescriptionOfConsequence == null || currentModificationProblem.humanReadableDescriptionOfConsequence.trim().length() == 0) {
                        detailedLockReasons.add(null);
                    } else {
                        detailedLockReasons.add(currentModificationProblem.humanReadableDescriptionOfConsequence.trim());
                    }
                    conflictingEOLocks.add(currentModificationProblem.conflictingLock);
                    continue;
                }
                if (currentModificationProblem.noPermissionText != null) {
                    noPermissionTexts.add(currentModificationProblem.noPermissionText);
                    continue;
                }
                noPermissionTexts.add(String.valueOf(currentModificationProblem.humanReadableDescriptionOfCause) + ": " + currentModificationProblem.humanReadableDescriptionOfConsequence);
                continue;
            }
            currentModificationProblem = iModificationProblem;
            noPermissionTexts.add(String.valueOf(currentModificationProblem.getHumanReadableDescriptionOfCause()) + ": " + currentModificationProblem.getHumanReadableDescriptionOfConsequence());
        }
        if (!noPermissionTexts.isEmpty()) {
            throw new EXCockpitPermissionDenied(noPermissionTexts.toArray(new String[0]));
        }
        if (!conflictingEOLocks.isEmpty()) {
            throw new EXCockpitLockDenied(conflictingEOLocks.toArray(new EOLock[0]), detailedLockReasons.toArray(new String[0]));
        }
    }

    public ModificationProblem(EOLock conflictingLock, String humanReadableDescriptionOfConsequence) {
        if (conflictingLock != null) {
            this.conflictingLock = conflictingLock;
            this.humanReadableDescriptionOfCause = String.valueOf(Messages.getString("LockMgr.Operation_can__t_be_performed._The_item_is_locked_by_n_15")) + Messages.getString("LockMgr._nUser___16") + conflictingLock.getUserName() + Messages.getString("LockMgr._nClient___17") + conflictingLock.getClientName() + Messages.getString("LockMgr._nLockType") + LockTypeDescriptionProvider.getLocalizedLockTypeDescription(conflictingLock.getLockTypeID());
        } else {
            this.conflictingLock = new EOLock("unknown", "unknown", "unknown", "unknown", "unknown", "unknown", "unknown", new Timestamp(new Date().getTime()));
            this.humanReadableDescriptionOfCause = Messages.getString("ModificationProblem.locked_by_another_client");
        }
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
        this.severity = 4;
    }

    public ModificationProblem(CockpitPermissionTemplate template, String humanReadableDescriptionOfConsequence, IFrameProjectAgent projectAgent) {
        this.setup(template, humanReadableDescriptionOfConsequence, projectAgent);
    }

    public ModificationProblem(IAttributeType attributeType, IParentOperandTree operandTree, IFrameProjectAgent projectAgent) {
        IPermissionOperand operand = operandTree.getBaseOperand();
        String operandType = operand == null ? null : operand.getPermissionOperandType();
        AttributeModificationPermissionTemplate template = projectAgent.getFrameUserDefinedAttributeTypesManager().getPermissionsTemplate(attributeType, operandType);
        String strProblem = String.valueOf(Messages.getString("ModificationProblem.the_attribute")) + attributeType.getDisplayName() + Messages.getString("ModificationProblem.may_not_be_modified");
        this.setup(template, strProblem, projectAgent);
    }

    public ModificationProblem(IAttributeType attributeType, IParentOperandTree operandTree, String projectUID) {
        this(attributeType, operandTree, (IFrameProjectAgent)ProjectMgr.getProjectMgr().getProjectAgent(projectUID));
    }

    private void setup(CockpitPermissionTemplate template, String humanReadableDescriptionOfConsequence, IFrameProjectAgent projectAgent) {
        String permissionLabel = projectAgent.getFramePermissionManager().getLabel(template);
        this.humanReadableDescriptionOfCause = String.valueOf(Messages.getString("ModificationProblem.permission")) + permissionLabel + Messages.getString("ModificationProblem.is_missing");
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
        this.noPermissionText = this.humanReadableDescriptionOfCause;
        this.severity = 4;
    }

    public ModificationProblem(String humanReadableDescriptionOfCause, String humanReadableDescriptionOfConsequence) {
        this.humanReadableDescriptionOfCause = humanReadableDescriptionOfCause;
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
    }

    public ModificationProblem(String humanReadableDescriptionOfCause, String humanReadableDescriptionOfConsequence, int severity) {
        this.humanReadableDescriptionOfCause = humanReadableDescriptionOfCause;
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
        this.severity = severity;
    }

    public ModificationProblem(Exception exception, String humanReadableDescriptionOfConsequence) {
        this(exception.getLocalizedMessage(), humanReadableDescriptionOfConsequence);
    }

    public ModificationProblem(Exception exception, int exceptionLevel, String humanReadableDescriptionOfConsequence) {
        this(exception.getLocalizedMessage(), humanReadableDescriptionOfConsequence, exceptionLevel);
    }

    public ModificationProblem(IClientFunctionLicenseType missingClientLicenseType, String humanReadableDescriptionOfConsequence) {
        this.humanReadableDescriptionOfCause = Messages.getString("ModificationProblem.license_is_missing");
        this.humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
        this.noPermissionText = this.humanReadableDescriptionOfCause;
        this.severity = 4;
    }

    public String getHumanReadableDescriptionOfCause() {
        return this.humanReadableDescriptionOfCause;
    }

    public String getHumanReadableDescriptionOfConsequence() {
        return this.humanReadableDescriptionOfConsequence;
    }

    public int getSeverity() {
        return this.severity;
    }
}

