/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FrameDataTypes {
    private static Map<String, ICockpitDataType> allTypes;
    private static Collection<ICockpitDataType> frameTypes;
    private static Collection<ICockpitDataType> customPropertyDataTypes;
    private static Collection<ICockpitDataType> naturalOrderDataTypes;
    private static Collection<ICockpitDataType> objectTypeCategoryTypes;

    public static final Collection<ICockpitDataType> getFrameDataTypes() {
        if (frameTypes == null) {
            frameTypes = new ArrayList<ICockpitDataType>();
            frameTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.plan"));
            frameTypes.add(FrameDataTypes.getDataType("frame.project"));
            frameTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.section"));
            frameTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement"));
            frameTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder"));
            frameTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole"));
            frameTypes.add(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
            frameTypes.add(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE));
            frameTypes.add(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE));
        }
        return frameTypes;
    }

    public static final Collection<ICockpitDataType> getAllDataTypes() {
        FrameDataTypes.retrieveDataTypes_internal();
        return allTypes.values();
    }

    public static ICockpitDataType getDataType(String dataTypeID) {
        FrameDataTypes.retrieveDataTypes_internal();
        return allTypes.get(dataTypeID);
    }

    public static Collection<ICockpitDataType> getDataTypesWithCustomProperties() {
        FrameDataTypes.retrieveDataTypes_internal();
        return customPropertyDataTypes;
    }

    public static Collection<ICockpitDataType> getDataTypesWithNaturalOrder() {
        FrameDataTypes.retrieveDataTypes_internal();
        return naturalOrderDataTypes;
    }

    public static Collection<ICockpitDataType> getDataTypesWithObjectTypeCategories() {
        FrameDataTypes.retrieveDataTypes_internal();
        return objectTypeCategoryTypes;
    }

    private static void retrieveDataTypes_internal() {
        if (allTypes == null) {
            allTypes = new HashMap<String, ICockpitDataType>();
            customPropertyDataTypes = new ArrayList<ICockpitDataType>();
            naturalOrderDataTypes = new HashSet<ICockpitDataType>();
            objectTypeCategoryTypes = new ArrayList<ICockpitDataType>();
            List<ICockpitDataType> dataTypes = ExtensionMgr.getDefault().getExtension("datatype", "datatype", "datatype", ICockpitDataType.class);
            for (ICockpitDataType dataType : dataTypes) {
                allTypes.put(dataType.getCockpitDataTypeID(), dataType);
                if (!(dataType instanceof IModuleDataTypeDescriptionForFrame) || ((IModuleDataTypeDescriptionForFrame)dataType).allowsUserDefinedAttributeTypes()) {
                    customPropertyDataTypes.add(dataType);
                }
                if (!(dataType instanceof IModuleDataTypeDescriptionForFrame) || ((IModuleDataTypeDescriptionForFrame)dataType).hasNaturalOrder()) {
                    naturalOrderDataTypes.add(dataType);
                }
                if (!dataType.isSupportingCategories()) continue;
                objectTypeCategoryTypes.add(dataType);
            }
        }
    }
}

