/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeOwner;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ICustomPropertiesForModuleDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModuleDataAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import java.util.Collection;
import java.util.Collections;

public class CustomPropertiesForModuleData
extends AbstractAttributeOwner
implements ICustomPropertiesForModuleDataRW {
    private final IAttributeOwner moduleData;

    public CustomPropertiesForModuleData(IAttributeOwner moduleData, IAttributeModificationManager attributeModificationManager) {
        super(moduleData.getUID(), moduleData.getProjectUID(), moduleData.getTypeID(), Collections.emptyList(), new ModuleDataAttributeTypesProvider(moduleData), attributeModificationManager);
        this.moduleData = moduleData;
    }

    @Override
    public Collection<IAttribute> getAllAttributes() {
        return this.moduleData.getAllAttributes();
    }

    @Override
    public IAttribute simplyGetAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        return this.moduleData.getAttribute(attributeTypeID);
    }

    @Override
    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        return this.moduleData.getAttributeType(attributeTypeID);
    }

    public ObjectTypeCategoryID getCategoryID() {
        return this.moduleData.getCategoryID();
    }

    @Override
    public void setCategoryID(ObjectTypeCategoryID newCategoryID) throws EXNoPermission, EXNoLock {
        if (this.moduleData instanceof IAttributeOwnerRW) {
            ((IAttributeOwnerRW)this.moduleData).setCategoryID(newCategoryID);
        } else assert (false) : "Cannot set Object Type Category ID on non-IAttributeOwnerRW object.";
    }
}

