/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Project
extends AbstractFrameData
implements ICockpitProject,
IPermissionOperand {
    private static final ILogger logger = Logger.getLogger(Project.class);
    public static final String DEFAULT_COPYRIGHT = Messages.getString("Project.copyright");
    private Collection<EOAttribute> additionalAttributes = new ArrayList<EOAttribute>();
    private static final String ATTR_TAG_PROJECT_NAME = "projectname";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private static final String ATTR_TAG_COPYRIGHT = "copyrightNotice";

    public static String getProjectName(EOProject eoProject) {
        for (EOAttribute attribute : eoProject.getAttributes()) {
            if (!attribute.getAttributeTypeUID().getEOAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME.getUID())) continue;
            EOString eoString = (EOString)attribute.getValueAsEO();
            return eoString.getString();
        }
        String projectName = eoProject.getOldAttributeValue(ATTR_TAG_PROJECT_NAME);
        if (projectName != null) {
            return projectName;
        }
        return "unknown name";
    }

    public static String getDescription(EOProject project) {
        EOAttribute attribute = Project.getAttribute(project, ProjectAttributeTypeProvider.ATTRID_DESCRIPTION.getUID());
        if (attribute != null) {
            EOString string = (EOString)attribute.getValueAsEO();
            return string.getString();
        }
        String description = project.getOldAttributeValue(ATTR_TAG_DESCRIPTION);
        if (description != null) {
            return description;
        }
        return "";
    }

    public static String getCopyright(EOProject project) {
        EOAttribute attribute = Project.getAttribute(project, ProjectAttributeTypeProvider.ATTRID_COPYRIGHT.getUID());
        if (attribute != null) {
            EOString string = (EOString)attribute.getValueAsEO();
            return string.getString();
        }
        String copyRight = project.getOldAttributeValue(ATTR_TAG_COPYRIGHT);
        if (copyRight != null) {
            return copyRight;
        }
        return "";
    }

    public static String getLanguage(EOProject project) {
        EOAttribute attribute = Project.getAttribute(project, ProjectAttributeTypeProvider.ATTRID_LANGUAGE.getUID());
        if (attribute != null) {
            EOString string = (EOString)attribute.getValueAsEO();
            return string.getString();
        }
        return null;
    }

    public static FileID getLogoFileID(EOProject project) {
        EOAttribute attribute = Project.getAttribute(project, ProjectAttributeTypeProvider.ATTRID_LOGO.getUID());
        if (attribute != null) {
            EOFileID eo = (EOFileID)attribute.getValueAsEO();
            String fileID = eo.getFileID();
            return new FileID(fileID);
        }
        return null;
    }

    private static EOAttribute getAttribute(EOProject eoProject, String attrID) {
        for (EOAttribute attribute : eoProject.getAttributes()) {
            if (!attribute.getAttributeTypeUID().getEOAttributeTypeID().equals(attrID)) continue;
            return attribute;
        }
        return null;
    }

    public Project(IFrameProjectAgent projectAgent, String name, IAttributeModificationManager modManager) {
        super(projectAgent.getUID(), projectAgent.getUID(), "frame.project", Collections.emptyList(), modManager, projectAgent);
        Attribute nameAttribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(nameAttribute);
    }

    public Project(IFrameProjectAgent projectAgent, Collection<IAttribute> attributes, IAttributeModificationManager modificationManager) {
        super(projectAgent.getUID(), projectAgent.getUID(), FrameDataTypes.getDataType("frame.project").getCockpitDataTypeID(), attributes, modificationManager, projectAgent);
    }

    public Project(IFrameProjectAgent projectAgent, EOProject eoProject, IAttributeModificationManager modManager) {
        super((EOFrameData)eoProject, "frame.project", modManager, projectAgent);
        String copyRight;
        String description;
        this.setProjectUID(projectAgent.getUID());
        this.setUID(projectAgent.getUID());
        for (EOAttribute eoAttribute : eoProject.getAttributes()) {
            AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eoAttribute.getAttributeTypeUID());
            try {
                this.getAttributeType(attributeTypeID);
            }
            catch (ExInvalidAttributeType e) {
                this.additionalAttributes.add(eoAttribute);
            }
        }
        String projectName = eoProject.getOldAttributeValue(ATTR_TAG_PROJECT_NAME);
        if (projectName != null) {
            Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(projectName, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((description = eoProject.getOldAttributeValue(ATTR_TAG_DESCRIPTION)) != null) {
            Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((copyRight = eoProject.getOldAttributeValue(ATTR_TAG_COPYRIGHT)) != null) {
            Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT, DataTypeString.getInstanceString().getAttributeValueFromString(copyRight, null, null));
            this.simplySetAttribute(attribute);
        }
    }

    @Override
    public Collection<IAttribute> getAllAttributes() {
        this.readUserDefinedAttributes();
        return super.getAllAttributes();
    }

    @Override
    public IAttribute getAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
        this.readUserDefinedAttributes();
        return super.getAttribute(attributeTypeID);
    }

    private void readUserDefinedAttributes() {
        if (this.additionalAttributes != null) {
            for (EOAttribute eoAttribute : this.additionalAttributes) {
                AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eoAttribute.getAttributeTypeUID());
                IAttributeType attributeType = null;
                try {
                    attributeType = this.getAttributeType(attributeTypeID);
                }
                catch (ExInvalidAttributeType exInvalidAttributeType) {
                    // empty catch block
                }
                if (attributeType == null) continue;
                Object attributeValue = attributeType.getDataType().getEOAsValue(eoAttribute.getValueAsEO());
                if (!attributeType.getDataType().supportsValue(attributeValue, attributeType.getValueRange())) continue;
                Attribute attribute = new Attribute(attributeTypeID, attributeValue);
                this.simplySetAttribute(attribute);
            }
            this.additionalAttributes = null;
        }
    }

    @Override
    public String getName() {
        IAttribute attribute = this.simplyGetAttribute(ProjectAttributeTypeProvider.ATTRID_NAME);
        return DataTypeString.getInstanceString().getValueAsSingleLineString(attribute.getAttributeValue(), null, null, null);
    }

    public void setName(String newName) throws EXNoLock, EXNoPermission {
        Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(newName, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    public void setDescription(String newDescription) throws EXNoLock, EXNoPermission {
        Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(newDescription, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        IAttribute attribute = this.simplyGetAttribute(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION);
        return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
    }

    @Override
    public String getUID() {
        return this.getProjectUID();
    }

    public void setCopyRight(String newCopyright) throws EXNoLock, EXNoPermission {
        Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT, DataTypeString.getInstanceString().getAttributeValueFromString(newCopyright, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public String getCopyRight() {
        IAttribute attribute = this.simplyGetAttribute(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT);
        return DataTypeString.getInstanceString().getValueAsSingleLineString(attribute.getAttributeValue(), null, null, null);
    }

    public void setMetaDataAttributeOnImport(IAttribute attribute) {
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("Could not import project meta data attribute on import.", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("Could not import project meta data attribute on import.", (Throwable)e);
        }
        catch (EXNoPermission e) {
            logger.error("Could not import project meta data attribute on import.", (Throwable)e);
        }
        catch (EXNoLock e) {
            logger.error("Could not import project meta data attribute on import.", (Throwable)e);
        }
    }

    public EOProject createEncodableObject() {
        EOProject eoProject = new EOProject(super.createEncodableObject());
        if (this.additionalAttributes != null) {
            for (EOAttribute attribute : this.additionalAttributes) {
                eoProject.addAttribute(attribute);
            }
        }
        return eoProject;
    }

    public String getPermissionOperandDisplayName() {
        return this.getName();
    }

    public String getPermissionOperandType() {
        return "project";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    @Override
    public String getLanguage() {
        try {
            IAttribute attribute = this.getAttribute(ProjectAttributeTypeProvider.ATTRID_LANGUAGE);
            return (String)attribute.getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            throw new RuntimeException();
        }
    }
}

