/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IGlobalPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.shared.message.FrameMessageIDs;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.EXConnectionLost;
import com.arcway.lib.java.IntegerComparator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.IRepositoryPlatformController;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterFileArchive;
import com.arcway.repository.clientadapter.implementation.adapter.locks.EXConcurrentCommit;
import com.arcway.repository.clientadapter.implementation.adapter.locks.EXConcurrentLocks;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.EOUserInformation;
import com.arcway.repository.cockpitadapter.EOWorkspaceInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchiveRW;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;

public class CockpitController
implements IFrameCockpitController,
IGlobalPropertyChangesListener,
INotificationBusListener {
    private static final ILogger logger = Logger.getLogger(CockpitController.class);
    private static final String FILE_NAME_USER_INFORMATION = "userinformation.data";
    private final IFrameProjectAgent projectAgent;
    private PlatformAdapterFileArchive fileArchive;
    private LockManager lockManager;
    private SortedMap<Integer, EOCommitCountAndCommitInformation> serverSideSnapshotInformations;
    private final Map<String, EOWorkspaceInformation> workspaceUID_workspaceInformation = new HashMap<String, EOWorkspaceInformation>();
    private PlatformAdapterModuleManager adapterModuleManager;
    private EOUserInformation storedUserInformationForOfflineMode;
    private int nrOfCurrentGlobalPropertyChangeListenerRegistrations = 0;

    private static XMLFileAccessor<EOUserInformation> createUserInformationFileAccessor(File projectRootDirectory) {
        File offlineDataFile = OfflineModeManager.getOfflineDataRelatedFile(FILE_NAME_USER_INFORMATION, projectRootDirectory);
        XMLFileAccessor xmlFileAccessor = new XMLFileAccessor(offlineDataFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        return xmlFileAccessor;
    }

    public static void enterOfflineMode(File projectRootDirectory, EOUserInformation userInformation) {
        XMLFileAccessor<EOUserInformation> xmlFileAccessor = CockpitController.createUserInformationFileAccessor(projectRootDirectory);
        xmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)userInformation));
    }

    public static void leaveOfflineModeWithoutBackup(File projectRootDirectory) {
        XMLFileAccessor<EOUserInformation> xmlFileAccessor = CockpitController.createUserInformationFileAccessor(projectRootDirectory);
        xmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
    }

    public CockpitController(IFrameProjectAgent projectAgent) throws EXOfflineDataNotAvailable {
        Assert.checkArgumentBeeingNotNull((Object)projectAgent);
        this.projectAgent = projectAgent;
        if (projectAgent.getOfflineModeManager().isInOfflineMode()) {
            try {
                XMLFileAccessor<EOUserInformation> xmlFileAccessor = CockpitController.createUserInformationFileAccessor(this.projectAgent.getProjectRoot());
                this.storedUserInformationForOfflineMode = (EOUserInformation)xmlFileAccessor.read();
            }
            catch (IOException e) {
                logger.error("Error while reading offline user data.", (Throwable)e);
                throw new EXOfflineDataNotAvailable(e);
            }
            catch (EXDecoderException e) {
                logger.error("Error while reading offline user data.", (Throwable)e);
                throw new EXOfflineDataNotAvailable(e);
            }
            if (this.storedUserInformationForOfflineMode == null) {
                FileNotFoundException fnfE = new FileNotFoundException(NLS.bind((String)Messages.getString("CockpitController.OfflineDataFileNotFound"), (Object)FILE_NAME_USER_INFORMATION));
                logger.error("Offline data file for user informations not found.", (Throwable)fnfE);
                throw new EXOfflineDataNotAvailable(fnfE);
            }
        } else {
            this.storedUserInformationForOfflineMode = null;
        }
    }

    public void install(ServerDataContainer serverDataContainer) {
        this.fileArchive = new PlatformAdapterFileArchive(this);
        this.lockManager = new LockManager();
        this.finishInitialization(serverDataContainer);
        this.registerForNotifications();
    }

    public void activateBegin() {
        this.adapterModuleManager = new PlatformAdapterModuleManager(this.projectAgent);
    }

    @Override
    public void activatePropertyChangesListening() {
        if (this.nrOfCurrentGlobalPropertyChangeListenerRegistrations == 0) {
            this.projectAgent.getPropertyChangesListenerManager().registerGlobalPropertyChangeListener((IGlobalPropertyChangesListener)this);
        }
        ++this.nrOfCurrentGlobalPropertyChangeListenerRegistrations;
    }

    @Override
    public void deactivatePropertyChangesListening() {
        --this.nrOfCurrentGlobalPropertyChangeListenerRegistrations;
        if (this.nrOfCurrentGlobalPropertyChangeListenerRegistrations == 0) {
            this.projectAgent.getPropertyChangesListenerManager().deregisterGlobalPropertyChangeListener((IGlobalPropertyChangesListener)this);
        }
    }

    public void activateEnd() {
        this.adapterModuleManager.setup();
        this.activatePropertyChangesListening();
    }

    private void registerForNotifications() {
        try {
            String notificationID = FrameMessageIDs.getProjectSpecificNotificationID((String)"cockpit.platform.locks.changed", (String)this.projectAgent.getProjectUID());
            this.getProjectAgent().getFrameServerProxy().subscribeListenerOnServer(this, notificationID);
        }
        catch (ServerNotAvailableException e) {
            throw new RuntimeException("could not register for lock notifications", e);
        }
        catch (EXServerException e) {
            throw new RuntimeException("could not register for lock notifications", e);
        }
        catch (LoginCanceledException e) {
            throw new RuntimeException("could not register for lock notifications", e);
        }
        catch (UnknownServerException e) {
            throw new RuntimeException("could not register for lock notifications", e);
        }
    }

    public void deactivate() {
        this.deactivatePropertyChangesListening();
    }

    public void uninstall() {
        this.unregisterForNotifications();
    }

    private void allLocksReleased(String workspaceUID) {
        if (!workspaceUID.equals(this.getWorkspaceInformation().getWorkspaceUID())) {
            this.workspaceUID_workspaceInformation.remove(workspaceUID);
        }
    }

    private void locksAllocated(EOWorkspaceInformation workspaceInformation) {
        if (!workspaceInformation.getWorkspaceUID().equals(this.getWorkspaceInformation().getWorkspaceUID())) {
            this.workspaceUID_workspaceInformation.put(workspaceInformation.getWorkspaceUID(), workspaceInformation);
        }
    }

    private void unregisterForNotifications() {
        try {
            String notificationID = FrameMessageIDs.getProjectSpecificNotificationID((String)"cockpit.platform.locks.changed", (String)this.projectAgent.getProjectUID());
            this.getProjectAgent().getFrameServerProxy().unsubscribeListenerOnServer(this, notificationID);
        }
        catch (ServerNotAvailableException notificationID) {
        }
        catch (EXServerException e) {
            throw new RuntimeException("could not unregister for lock notifications", e);
        }
        catch (LoginCanceledException loginCanceledException) {
        }
        catch (UnknownServerException unknownServerException) {
            // empty catch block
        }
    }

    @Override
    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public IRepositoryFileArchiveRW getFileArchiveImplementation() {
        return this.fileArchive;
    }

    private void setupWorkspaceInformations(Collection<EOWorkspaceInformation> workspaceInformations) {
        EOWorkspaceInformation workspaceInformation2;
        this.workspaceUID_workspaceInformation.clear();
        for (EOWorkspaceInformation workspaceInformation2 : workspaceInformations) {
            this.workspaceUID_workspaceInformation.put(workspaceInformation2.getWorkspaceUID(), workspaceInformation2);
        }
        workspaceInformation2 = this.getWorkspaceInformation();
        this.workspaceUID_workspaceInformation.put(workspaceInformation2.getWorkspaceUID(), workspaceInformation2);
    }

    @Override
    public ILockManager getLockManager() {
        return this.lockManager;
    }

    private static ProjectMgr getProjectMgr() {
        return ProjectMgr.getProjectMgr();
    }

    private void finishInitialization(ServerDataContainer serverDataContainer) {
        EOList<EOCommitCountAndCommitInformation> commitInformations = serverDataContainer.getCommitInformations();
        this.serverSideSnapshotInformations = new TreeMap<Integer, EOCommitCountAndCommitInformation>((Comparator<Integer>)IntegerComparator.getInstance());
        for (EOCommitCountAndCommitInformation commitInformation : commitInformations) {
            this.serverSideSnapshotInformations.put(commitInformation.getCommitCount(), commitInformation);
        }
        this.setupWorkspaceInformations(serverDataContainer.getWorkspaceInformations());
        this.lockManager.setupLocks(serverDataContainer.getLockLog(), serverDataContainer.getWorkspaceUID_locks());
    }

    @Override
    public void applyAsynchronousModifications(EOCommitCountAndCommitInformation commitInformation, EOWorkspaceInformation commitingWorkspaceInformation, EOList<EOPlatformLock> platformLockLogs) {
        this.lockManager.allLocksReleased(commitingWorkspaceInformation.getWorkspaceUID());
        this.lockManager.applyModifications(platformLockLogs);
        this.allLocksReleased(commitingWorkspaceInformation.getWorkspaceUID());
        this.serverSideSnapshotInformations.put(commitInformation.getCommitCount(), commitInformation);
        this.getPlatformController().workspaceCommited(commitingWorkspaceInformation, commitInformation.getCommitInformation());
        this.getPlatformController().workspaceListChanged();
    }

    @Override
    public void applySynchronousModification(EOCommitCountAndCommitInformation commitInformation, EOList<EOPlatformLock> platformLockLogs) {
        this.lockManager.allLocksReleased(this.getWorkspaceInformation().getWorkspaceUID());
        this.lockManager.applyModifications(platformLockLogs);
        this.allLocksReleased(this.getWorkspaceInformation().getWorkspaceUID());
        this.serverSideSnapshotInformations.put(commitInformation.getCommitCount(), commitInformation);
        this.getPlatformController().workspaceCommited(this.getWorkspaceInformation(), commitInformation.getCommitInformation());
    }

    @Override
    public void discardLocalModifications() {
        this.getPlatformController().workspaceDiscarded();
    }

    @Override
    public boolean isOnline() {
        return !this.projectAgent.getOfflineModeManager().isInOfflineMode();
    }

    @Override
    public EOWorkspaceInformation getWorkspaceInformation() {
        String serverID = this.getProjectAgent().getServerID();
        ProjectMgr projectMgr = CockpitController.getProjectMgr();
        String workspaceUID = projectMgr.getWorkspaceUID();
        ServerConnection serverConnection = projectMgr.getServerConnectionByServerID(serverID);
        String clientLocation = serverConnection.getClientLocation();
        EOWorkspaceInformation workspaceInformation = new EOWorkspaceInformation(workspaceUID, clientLocation, this.getCurrentUserInformation());
        return workspaceInformation;
    }

    private EOUserInformation getCurrentUserInformation() {
        if (this.storedUserInformationForOfflineMode == null) {
            ProjectMgr projectMgr = CockpitController.getProjectMgr();
            String serverID = this.projectAgent.getServerID();
            ServerConnection serverConnection = projectMgr.getServerConnectionByServerID(serverID);
            String directoryType = serverConnection.getDirectoryType();
            String directoryNameOrURL = serverConnection.getDirectoryNameOrURL();
            String distinguishedName = serverConnection.getDistinguishedName();
            String loginID = serverConnection.getLoginID();
            String realName = serverConnection.getRealName();
            return new EOUserInformation(directoryType, directoryNameOrURL, distinguishedName, loginID, realName);
        }
        return this.storedUserInformationForOfflineMode;
    }

    @Override
    public Collection<EOWorkspaceInformation> getAvailableWorkspaceInformations() {
        return this.workspaceUID_workspaceInformation.values();
    }

    @Override
    public EOWorkspaceInformation getWorkspaceInformation(String workspaceUID) {
        return this.workspaceUID_workspaceInformation.get(workspaceUID);
    }

    @Override
    public List<EOCommitCountAndCommitInformation> getCommitInformations() {
        return new ArrayList<EOCommitCountAndCommitInformation>(this.serverSideSnapshotInformations.values());
    }

    @Override
    public EOCommitInformation getCommitInformation(int commitCount) {
        return ((EOCommitCountAndCommitInformation)this.serverSideSnapshotInformations.get(commitCount)).getCommitInformation();
    }

    private IRepositoryPlatformController getPlatformController() {
        return this.projectAgent.getRepositoryPlattformController();
    }

    @Override
    public PlatformAdapterModuleManager getPlatformAdapterModuleManager() {
        return this.adapterModuleManager;
    }

    public void modelRefreshed(Collection<Class<?>> clazzes) {
        assert (clazzes != null && !clazzes.isEmpty());
        boolean modelRefreshForRefreshingPurposesOnly = true;
        for (Class<?> clazz : clazzes) {
            if (clazz == null || IFilterItem.class.isAssignableFrom(clazz)) continue;
            modelRefreshForRefreshingPurposesOnly = false;
            break;
        }
        if (!modelRefreshForRefreshingPurposesOnly) {
            this.getPlatformController().concurrentLocalModifications();
        }
    }

    public void receiveNotification(Notification notification) {
        EOList parameter = (EOList)notification.getParameter();
        if (parameter.getRole().equals(this.getProjectAgent().getUID())) {
            EOWorkspaceInformation workspaceInformation = (EOWorkspaceInformation)parameter.get(0);
            EOList allocatedLocks = (EOList)parameter.get(1);
            EOList releasedLocks = (EOList)parameter.get(2);
            this.locksAllocated(workspaceInformation);
            this.lockManager.locksAllocated(workspaceInformation.getWorkspaceUID(), (Collection)allocatedLocks);
            this.lockManager.locksReleased(workspaceInformation.getWorkspaceUID(), (Collection)releasedLocks);
            if (this.lockManager.getLocks(workspaceInformation.getWorkspaceUID()).isEmpty()) {
                this.allLocksReleased(workspaceInformation.getWorkspaceUID());
            }
            this.getPlatformController().workspaceLocksChanged(workspaceInformation);
            this.getPlatformController().workspaceListChanged();
        }
    }

    @Override
    public void enterOfflineMode() {
        CockpitController.enterOfflineMode(this.projectAgent.getProjectRoot(), this.getCurrentUserInformation());
    }

    @Override
    public EOUserInformation leaveOfflineModeWithBackup() throws IOException, EXDecoderException {
        return this.cleanUpWithBackup();
    }

    private EOUserInformation cleanUpWithBackup() throws IOException, EXDecoderException {
        XMLFileAccessor<EOUserInformation> xmlFileAccessor = CockpitController.createUserInformationFileAccessor(this.projectAgent.getProjectRoot());
        EOUserInformation userInformationBackup = (EOUserInformation)xmlFileAccessor.read();
        xmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
        return userInformationBackup;
    }

    @Override
    public boolean hasLocalModifications() {
        return this.projectAgent.getCommitMgr().areModificationsPresent();
    }

    private class LockManager
    implements ILockManager {
        private final Map<EOPlatformLock, Set<String>> lock_workspaceUIDs = new HashMap<EOPlatformLock, Set<String>>();
        private final Map<String, Set<EOPlatformLock>> workspaceUID_locks = new HashMap<String, Set<EOPlatformLock>>();
        private final Map<EOPlatformLock, String> lock_commitUID = new HashMap<EOPlatformLock, String>();

        private LockManager() {
        }

        @Override
        public String getCommitUID(EOPlatformLock lock) {
            return this.lock_commitUID.get(lock);
        }

        @Override
        public Collection<String> getLockingWorkspaceUIDs(EOPlatformLock lock) {
            List<String> lockingWorkspaceUIDs = (List<String>)((Object)this.lock_workspaceUIDs.get(lock));
            if (lockingWorkspaceUIDs == null) {
                lockingWorkspaceUIDs = Collections.emptyList();
            }
            return lockingWorkspaceUIDs;
        }

        @Override
        public Collection<EOPlatformLock> getLocks(String workspaceUID) {
            List<EOPlatformLock> locks = (List<EOPlatformLock>)((Object)this.workspaceUID_locks.get(workspaceUID));
            if (locks == null) {
                locks = Collections.emptyList();
            }
            return locks;
        }

        @Override
        public void allocateLocks(Collection<EOPlatformLock> locksToCheck, Collection<EOPlatformLock> locksToRelease, Collection<EOPlatformLock> locksToAllocate) throws EXConnectionLost, EXConcurrentCommit, EXConcurrentLocks {
            try {
                EOList<EOPlatformLock> conflictingLocks = CockpitController.this.getProjectAgent().getFrameServerProxy().allocateLocks(locksToCheck, locksToRelease, locksToAllocate);
                if (conflictingLocks == null) {
                    throw new EXConcurrentCommit();
                }
                if (!conflictingLocks.isEmpty()) {
                    throw new EXConcurrentLocks((Collection<EOPlatformLock>)conflictingLocks);
                }
            }
            catch (ServerNotAvailableException e) {
                throw new EXConnectionLost();
            }
            catch (EXServerException e) {
                throw new EXConnectionLost();
            }
            catch (LoginCanceledException e) {
                throw new EXConnectionLost();
            }
            catch (UnknownServerException e) {
                throw new EXConnectionLost();
            }
        }

        private void setupLocks(Collection<EOPlatformLock> lockLog, Map<String, Collection<EOPlatformLock>> workspaceUID_locks) {
            this.lock_workspaceUIDs.clear();
            this.workspaceUID_locks.clear();
            for (Map.Entry<String, Collection<EOPlatformLock>> entry : workspaceUID_locks.entrySet()) {
                String workspaceUID = entry.getKey();
                Collection<EOPlatformLock> locks = entry.getValue();
                this.locksAllocated(workspaceUID, locks);
            }
            this.lock_commitUID.clear();
            this.applyModifications(lockLog);
        }

        private void locksAllocated(String workspaceUID, Collection<EOPlatformLock> locks) {
            for (EOPlatformLock lock : locks) {
                Set<String> workspacesUIDsOfLock = this.lock_workspaceUIDs.get(lock);
                if (workspacesUIDsOfLock == null) {
                    workspacesUIDsOfLock = new HashSet<String>();
                    this.lock_workspaceUIDs.put(lock, workspacesUIDsOfLock);
                }
                workspacesUIDsOfLock.add(workspaceUID);
            }
            Set<EOPlatformLock> locksOfWorkspace = this.workspaceUID_locks.get(workspaceUID);
            if (locksOfWorkspace == null) {
                locksOfWorkspace = new HashSet<EOPlatformLock>();
                this.workspaceUID_locks.put(workspaceUID, locksOfWorkspace);
            }
            locksOfWorkspace.addAll(locks);
        }

        private void locksReleased(String workspaceUID, Collection<EOPlatformLock> locks) {
            for (EOPlatformLock lock : locks) {
                Set<String> workspacesUIDsOfLock = this.lock_workspaceUIDs.get(lock);
                assert (workspacesUIDsOfLock != null) : "How can an unknown lock be released?";
                workspacesUIDsOfLock.remove(workspaceUID);
                if (!workspacesUIDsOfLock.isEmpty()) continue;
                this.lock_workspaceUIDs.remove(lock);
            }
            Set<EOPlatformLock> locksOfWorkspace = this.workspaceUID_locks.get(workspaceUID);
            assert (locksOfWorkspace != null) : "How can an unknown lock be released?";
            locksOfWorkspace.removeAll(locks);
            if (locksOfWorkspace.isEmpty()) {
                this.workspaceUID_locks.remove(workspaceUID);
            }
        }

        private void allLocksReleased(String workspaceUID) {
            Collection<EOPlatformLock> locks = this.getLocks(workspaceUID);
            for (EOPlatformLock lock : locks) {
                Set<String> workspaceUIDsOfLock = this.lock_workspaceUIDs.get(lock);
                assert (workspaceUIDsOfLock != null) : "How can an unknown lock be released?";
                workspaceUIDsOfLock.remove(workspaceUID);
            }
            Set<EOPlatformLock> locksOfWorkspace = this.workspaceUID_locks.get(workspaceUID);
            if (locksOfWorkspace != null) {
                locksOfWorkspace.removeAll(locks);
            }
        }

        private void applyModifications(Collection<EOPlatformLock> platformLocks) {
            for (EOPlatformLock lock : platformLocks) {
                this.lock_commitUID.put(lock, lock.getCommitUID());
            }
        }
    }
}

