/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportProjectAsFileWizard
extends Wizard {
    public static final String wizardID = "com.arcway.cockpit.frame.client.global.gui.wizards.newproject.ExportProjectAsFileWizard";
    private static final ILogger logger = Logger.getLogger(ExportProjectAsFileWizard.class);
    private final String windowTitle = Messages.getString("ExportProjectAsFileWizard.window_title");
    private final String pageTitle;
    private final String pageMessage;
    private final String fileExtension;
    private Page page;
    private IFrameProjectAgent projectAgent;

    public ExportProjectAsFileWizard(String pageTitle, String pageMessage, String fileExtension) {
        this.pageTitle = pageTitle;
        this.pageMessage = pageMessage;
        this.fileExtension = fileExtension;
    }

    public void initialise(IFrameProjectAgent p_projectAgent) {
        this.projectAgent = p_projectAgent;
        this.setWindowTitle(this.windowTitle);
        if (this.page == null) {
            this.addPages();
        }
        IArcwayMemento wizardMemento = ExportProjectAsFileWizard.getOrCreateMementoChild(this.projectAgent.getFrameLocalSettings(), wizardID);
        IArcwayMemento pageMemento = ExportProjectAsFileWizard.getOrCreateMementoChild(wizardMemento, this.page.getPageId());
        this.page.readSettings(pageMemento);
        this.page.setProjectName(this.projectAgent.getProjectName());
    }

    public boolean canFinish() {
        return this.page.getPathAndFile().length() > 0;
    }

    public void addPages() {
        this.page = new Page(this.pageTitle, this.pageMessage, this.fileExtension);
        this.addPage((IWizardPage)this.page);
    }

    private static IArcwayMemento getOrCreateMementoChild(IArcwayMemento memento, String child) {
        IArcwayMemento mementoChild = memento.getChild(child);
        if (mementoChild == null) {
            mementoChild = memento.createChild(child);
        }
        return mementoChild;
    }

    public boolean performFinish() {
        boolean execute = true;
        final File saveFile = new File(this.page.getPathAndFile());
        if (saveFile.exists()) {
            execute = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("SaveProjectAsTemplateAction.file_exists"), (String)(String.valueOf(Messages.getString("SaveProjectAsTemplateAction.the_file")) + saveFile.getName() + Messages.getString("SaveProjectAsTemplateAction.exists_already")));
        }
        if (execute) {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Throwable exception = null;
                    try {
                        JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                        ExportProjectAsFileWizard.this.projectAgent.getFrameExportDataProvider().exportData(saveFile, (IProgressDisplay)pDisplay);
                        IArcwayMemento wizardMemento = ExportProjectAsFileWizard.getOrCreateMementoChild(ExportProjectAsFileWizard.this.projectAgent.getFrameLocalSettings(), ExportProjectAsFileWizard.wizardID);
                        IArcwayMemento pageMemento = ExportProjectAsFileWizard.getOrCreateMementoChild(wizardMemento, ExportProjectAsFileWizard.this.page.getPageId());
                        ExportProjectAsFileWizard.this.page.saveSettings(pageMemento);
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    catch (JvmExternalResourceInteractionException jeriE) {
                        Throwable throwable = exception = jeriE.getCause() != null ? jeriE.getCause() : jeriE;
                    }
                    if (exception != null) {
                        MessageDialog.openError((Shell)ExportProjectAsFileWizard.this.getShell(), (String)Messages.getString("ExportProjectAsFileWizard.error"), (String)(String.valueOf(Messages.getString("ExportProjectAsFileWizard.cannot_export")) + exception.getLocalizedMessage()));
                        throw new InvocationTargetException(exception);
                    }
                }
            };
            pmd.setOpenOnRun(true);
            try {
                pmd.run(false, false, rwp);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IOException) {
                    execute = false;
                } else {
                    logger.error("could not save project " + this.projectAgent.getProjectName() + " as (template) file", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                logger.error("could not save project " + this.projectAgent.getProjectName() + " as (template) file", (Throwable)e);
            }
        }
        return execute;
    }

    private static class Page
    extends WizardPage {
        public static final String pageId = "com.arcway.cockpit.frame.client.global.gui.wizards.newproject.ExportProjectAsFileWizard.Page";
        private final String pageTitle;
        private final String pageMessage;
        private final String fileExtension;
        private String projectName;
        private Text txtFileName;
        private String previouslySelectedPath;
        private static final String SETTING_PREVIOUS_PATH = "previouslySelectedPath";

        protected Page(String pageTitle, String pageMessage, String fileExtension) {
            super("main page");
            this.pageTitle = pageTitle;
            this.pageMessage = pageMessage;
            this.fileExtension = fileExtension;
        }

        public void createControl(Composite parent) {
            this.setTitle(this.pageTitle);
            this.setMessage(this.pageMessage);
            this.setImageDescriptor(Icons.getImageDescriptorForBigExportLogo());
            Composite base = new Composite(parent, 0);
            base.setLayoutData((Object)new GridData(1808));
            base.setLayout((Layout)new GridLayout(2, false));
            this.txtFileName = new Text(base, 2048);
            this.txtFileName.setLayoutData((Object)new GridData(768));
            if (this.previouslySelectedPath != null && !ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled")) {
                this.txtFileName.setText(this.previouslySelectedPath);
            } else {
                String path = ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getString("defaultFileSystemPath.Path");
                path = String.valueOf(path) + File.separatorChar + FileHelper.convertStringToPortableFileName((String)this.projectName) + "." + this.fileExtension;
                this.txtFileName.setText(path);
            }
            this.txtFileName.setEditable(false);
            this.txtFileName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getContainer().updateButtons();
                }
            });
            Button btnChooseFile = new Button(base, 8);
            btnChooseFile.setLayoutData((Object)new GridData());
            btnChooseFile.setImage(Icons.getImageForFileFolder());
            btnChooseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.selectFile();
                }
            });
            this.setControl((Control)base);
        }

        private void selectFile() {
            FileChooserDialog dialog;
            File file;
            String startPath = this.getPathAndFile();
            File startPathFile = null;
            if (startPath.length() > 0) {
                startPathFile = new File(startPath).getParentFile();
            }
            if ((file = (dialog = new FileChooserDialog(new String[]{this.fileExtension}, startPathFile, this.getShell())).openForSave()) != null) {
                this.txtFileName.setText(file.getAbsolutePath());
            }
        }

        public String getPageId() {
            return pageId;
        }

        public String getPathAndFile() {
            return this.txtFileName.getText().trim();
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        private void readSettings(IArcwayMemento memento) {
            this.previouslySelectedPath = memento.getString(SETTING_PREVIOUS_PATH);
        }

        private void saveSettings(IArcwayMemento memento) {
            memento.putString(SETTING_PREVIOUS_PATH, this.getPathAndFile());
        }
    }
}

