/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataView;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEView2ContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEView2Provider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewHierarchy;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class UniqueElementView2
extends CockpitTreeDataView<Object> {
    private static final String STATEINFORMATIONKEY_HIERARCHYMODE = "hierarchymode";
    private static final String HIERARCHYMODE_FLAT = "flat";
    private static final String HIERARCHYMODE_CONTAINMENTTREE = "containment-tree";
    private UEView2Provider dataViewProvider;
    private UEView2ContentProvider ueViewContentProvider;
    private IAction hierarchyModeAction;

    @Override
    protected CockpitTreeDataViewProvider<Object> createCockpitTreeDataViewProvider() {
        return this.getDataViewProvider();
    }

    private UEView2Provider getDataViewProvider() {
        if (this.dataViewProvider == null) {
            this.dataViewProvider = new UEView2Provider(this, this.getSelectionProvider());
        }
        return this.dataViewProvider;
    }

    @Override
    protected void createPermanentParts() {
        super.createPermanentParts();
        this.hierarchyModeAction = this.dataViewProvider.getHierarchyModeAction();
    }

    @Override
    protected ITreeDataViewHierarchy createTreeDataViewHierarchy() {
        this.ueViewContentProvider = new UEView2ContentProvider(false);
        return new ITreeDataViewHierarchy(){

            @Override
            public List<?> getRootItems(String projectUID) {
                return UniqueElementView2.this.ueViewContentProvider.getElements(ProjectMgr.getProjectMgr().getProjectAgent(projectUID));
            }

            @Override
            public boolean itemExists(Object element, String projectUID) {
                return UniqueElementView2.this.ueViewContentProvider.itemExists(element, projectUID);
            }

            @Override
            public boolean hasChildren(Object item, ViewerFilter[] filters, Viewer viewer, String projectUID) {
                return this.getFilteredChildren(UniqueElementView2.this.ueViewContentProvider.getChildren(item, projectUID), filters, viewer, projectUID).length > 0;
            }

            @Override
            public List<?> getChildren(Object item, ViewerFilter[] filters, Viewer viewer, String projectUID) {
                return UniqueElementView2.this.ueViewContentProvider.getChildren(item, projectUID);
            }

            @Override
            public List<?> getParents(Object item, String projectUID) {
                return UniqueElementView2.this.ueViewContentProvider.getParents(item, projectUID);
            }

            private final Object[] getFilteredChildren(Collection<?> childItems, ViewerFilter[] filters, Viewer viewer, String projectUID) {
                Object[] childItems_asObjects = childItems.toArray();
                if (filters != null) {
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter filter = viewerFilterArray[n2];
                        childItems_asObjects = filter.filter(viewer, null, childItems_asObjects);
                        ++n2;
                    }
                }
                return childItems_asObjects;
            }
        };
    }

    @Override
    public void callbackBeforeRefreshOfViewer() {
        super.callbackBeforeRefreshOfViewer();
        this.dataViewProvider.projectModified();
    }

    @Override
    protected void callbackAfterExchangeOfViewer(String oldProjectUID, String newProjectUID) {
        super.callbackAfterExchangeOfViewer(oldProjectUID, newProjectUID);
        this.dataViewProvider.projectChanged(newProjectUID != null ? ProjectMgr.getProjectMgr().getProjectAgent(newProjectUID) : null);
        this.applyHierarchyMode();
    }

    @Override
    protected Collection<?> postProcessSearchResult(Collection<?> searchResult) {
        return searchResult;
    }

    @Override
    protected Collection<?> getAllRelevantItemsForSearch(String newProjectUID) {
        return this.getUniqueElementManager(newProjectUID).getUniqueElements();
    }

    @Override
    protected String getHelpContextID() {
        return null;
    }

    @Override
    protected IStructuredSelection sortOutSelection(IStructuredSelection selection) {
        ArrayList filteredSelection = new ArrayList(selection.size());
        for (Object selectedItem : selection.toList()) {
            if (!(selectedItem instanceof IUniqueElement)) continue;
            filteredSelection.add(selectedItem);
        }
        return new StructuredSelection(filteredSelection);
    }

    @Override
    protected boolean isPropertyChangeRequiringExchangeOfViewer(IPropertyChanges<?> changes, Class<?> clazz) {
        if (IAttributeType.class.isAssignableFrom(clazz)) {
            HashSet customProperties = new HashSet(changes.getCreatedElements());
            customProperties.addAll(changes.getDeletedElements());
            customProperties.addAll(changes.getModifiedElements());
            for (Object attributeTypeObject : customProperties) {
                IAttributeType attributeType = (IAttributeType)attributeTypeObject;
                if (!attributeType.getCockpitDataType().getCockpitDataTypeID().equals("com.arcway.cockpit.uniqueelement")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPropertyChangeOfDisplayedItems(IPropertyChanges<?> changes, Class<?> clazz) {
        return IUniqueElement.class.isAssignableFrom(clazz);
    }

    private IFrameUniqueElementManager getUniqueElementManager(String projectUID) {
        return ProjectMgr.getProjectMgr().getProjectAgent(projectUID).getFrameUniqueElementMgr();
    }

    protected final void handleHierarchyModeActionSelected() {
        String hierarchyMode = this.getAdditionalStateInformation(STATEINFORMATIONKEY_HIERARCHYMODE);
        if (hierarchyMode != null && hierarchyMode.equals(HIERARCHYMODE_FLAT)) {
            this.setAdditionalStateInformation(STATEINFORMATIONKEY_HIERARCHYMODE, HIERARCHYMODE_CONTAINMENTTREE);
        } else {
            this.setAdditionalStateInformation(STATEINFORMATIONKEY_HIERARCHYMODE, HIERARCHYMODE_FLAT);
        }
        this.applyHierarchyMode();
        this.refreshOfViewerRequired(false, null);
    }

    private void applyHierarchyMode() {
        String hierarchyMode = this.getAdditionalStateInformation(STATEINFORMATIONKEY_HIERARCHYMODE);
        boolean useContainmentHierarchyMode = hierarchyMode == null || hierarchyMode.equals(HIERARCHYMODE_CONTAINMENTTREE);
        this.hierarchyModeAction.setChecked(useContainmentHierarchyMode);
        this.ueViewContentProvider.setViewMode(!useContainmentHierarchyMode);
    }
}

