/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailsElementMulti
extends DetailsElement {
    private final String label;
    private final DetailsValue detailsValue;
    private final boolean showLabel;
    private IDetailsResourceProvider currentRessourceProvider;
    private Composite detailsField;
    private StyledText labelWidget;
    private Text valueWidget;

    public DetailsElementMulti(String id, String label, DetailsValueMulti detailsValue, boolean showLabel) {
        super(id);
        this.label = label;
        this.detailsValue = detailsValue;
        this.showLabel = showLabel;
    }

    public Control createWidget(Composite parent, IWorkbenchPartSite site, IDetailsResourceProvider resourceProvider) {
        GridData gridData;
        this.detailsField = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 8;
        this.detailsField.setLayout((Layout)layout);
        if (this.showLabel && this.label != null) {
            this.labelWidget = new StyledText(this.detailsField, 8);
            this.labelWidget.setText(this.label);
            this.labelWidget.setFont(resourceProvider.getLabelFont());
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.label.length();
            styleRange.fontStyle = 1;
            this.labelWidget.setStyleRange(styleRange);
            gridData = new GridData(4, 1, true, false);
            this.labelWidget.setLayoutData((Object)gridData);
        }
        this.valueWidget = new Text(this.detailsField, 72);
        this.valueWidget.setFont(resourceProvider.getValueFont());
        gridData = new GridData(4, 1, true, false);
        this.valueWidget.setLayoutData((Object)gridData);
        return this.detailsField;
    }

    public void fillWidget(IDetailsResourceProvider resourceProvider) {
        this.currentRessourceProvider = resourceProvider;
        String value = this.detailsValue.getDisplayText();
        Color backgroundColour = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        if (value == null || value.equals("")) {
            value = "-";
        }
        this.valueWidget.setText(value);
        this.detailsField.setBackground(backgroundColour);
        if (this.showLabel) {
            this.labelWidget.setBackground(backgroundColour);
        }
        this.valueWidget.setBackground(backgroundColour);
    }

    public int getMinimumWidth() {
        if (this.showLabel) {
            return this.labelWidget.computeSize((int)-1, (int)-1).x + ((GridLayout)this.detailsField.getLayout()).marginWidth * 2 + ((GridLayout)this.detailsField.getLayout()).marginLeft + ((GridLayout)this.detailsField.getLayout()).marginRight;
        }
        return 1;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.detailsField.setBackground(background);
            if (this.showLabel) {
                this.labelWidget.setBackground(background);
            }
            this.valueWidget.setBackground(background);
        }
    }

    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementMulti)) {
            return false;
        }
        DetailsElementMulti elementToCompare = (DetailsElementMulti)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        return this.detailsValue.getDisplayText().equals(elementToCompare.detailsValue.getDisplayText());
    }
}

