/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import de.plans.lib.localisation.DateFormatHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyPlanHistory
implements IPropertiesListEntry,
ISelectionChangedListener {
    private static final ILogger logger = Logger.getLogger(PropertyPlanHistory.class);
    private static final Integer COLUMNID_FILEVERSION = 0;
    private static final Integer COLUMNID_DATE = 1;
    private static final Integer COLUMNID_AUTHOR = 2;
    private static final Integer COLUMNID_COMMITCOMMENT = 3;
    private static final List<Integer> COLUMNS = new ArrayList<Integer>();
    private IPlan plan;
    private List<? extends IPlan> planHistory;
    private IPropertiesDialog dialog;
    private TableViewer tableViewer;
    private Button openButton;
    private IPlan selectedHistoryItem;
    private Text description;

    static {
        COLUMNS.add(COLUMNID_DATE);
        COLUMNS.add(COLUMNID_AUTHOR);
        COLUMNS.add(COLUMNID_COMMITCOMMENT);
    }

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.plan = (IPlan)elements[0];
        this.dialog = newDialog;
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IPlan) {
            IPlan p = (IPlan)elements[0];
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(p.getProjectUID());
            return projectAgent.isOpened() && projectAgent.getFrameServerProxy().supportsVersioning();
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyPlanHistory.History_1");
    }

    @Override
    public Image getPropertyImage() {
        return null;
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        Composite child = new Composite(parent, 0);
        child.setLayoutData((Object)new GridData(1808));
        child.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer(child, 68356);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        for (Integer columnID : COLUMNS) {
            if (columnID.equals(COLUMNID_FILEVERSION)) {
                TableColumn versionColumn = new TableColumn(this.tableViewer.getTable(), 0);
                versionColumn.setText(Messages.getString("PropertyPlanHistory.Version_2"));
                versionColumn.pack();
                continue;
            }
            if (columnID.equals(COLUMNID_DATE)) {
                TableColumn dateColumn = new TableColumn(this.tableViewer.getTable(), 0);
                dateColumn.setText(Messages.getString("PropertyPlanHistory.Date_4"));
                dateColumn.setWidth(120);
                continue;
            }
            if (columnID.equals(COLUMNID_AUTHOR)) {
                TableColumn authorColumn = new TableColumn(this.tableViewer.getTable(), 0);
                authorColumn.setText(Messages.getString("PropertyPlanHistory.Author_3"));
                authorColumn.setWidth(120);
                continue;
            }
            if (!columnID.equals(COLUMNID_COMMITCOMMENT)) continue;
            TableColumn commentColumn = new TableColumn(this.tableViewer.getTable(), 0);
            commentColumn.setText(Messages.getString("PropertyPlanHistory.0"));
            commentColumn.setWidth(200);
        }
        GridData tableGridData = new GridData(1808);
        tableGridData.horizontalSpan = 2;
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.setContentProvider((IContentProvider)new HistoryTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HistoryTableLabelProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tableViewer.setSorter((ViewerSorter)new HistoryTableSorter());
        try {
            this.planHistory = this.getPlanHistory();
            this.tableViewer.setInput(this.planHistory);
        }
        catch (Exception e) {
            logger.error("getPropertyPage() - The History for the specified plan couldn't be loaded from the server.");
        }
        this.description = new Text(child, 2114);
        this.description.setText("\n\n\n\n\n");
        this.description.setEditable(false);
        GridData descriptionGridData = new GridData(1808);
        descriptionGridData.horizontalSpan = 1;
        this.description.setLayoutData((Object)descriptionGridData);
        this.openButton = new Button(child, 0);
        this.openButton.setText(Messages.getString("PropertyPlanHistory.Show_6"));
        this.openButton.setEnabled(false);
        GridData openGridData = new GridData();
        this.openButton.setLayoutData((Object)openGridData);
        this.openButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectAgent activeProject = ProjectMgr.getProjectMgr().getProjectAgent(PropertyPlanHistory.this.plan.getProjectUID());
                PlanEditorManager planEditorMgr = activeProject.getPlanEditorManager();
                planEditorMgr.openSinglePlanEditorForOldPlanVersion(PropertyPlanHistory.this.dialog.getWorkbenchPage(), PropertyPlanHistory.this.selectedHistoryItem);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dialog.setTitle(Messages.getString("PropertyPlanHistory.Plan_History_8"), this);
        this.dialog.setMessage(Messages.getString("PropertyPlanHistory.Shows_all_versions_of_the_Plan._9"), 0, this);
        return child;
    }

    private List<? extends IPlan> getPlanHistory() {
        List<? extends IPlan> planHistory_ = ProjectMgr.getProjectMgr().getProjectAgent(this.plan.getProjectUID()).getFrameSectionManager().getHistoricPlanVersions(this.plan);
        ArrayList<IPlan> planVersionsForWhichThePlanFileHasChanged = new ArrayList<IPlan>();
        IPlan lastPlanVersion = null;
        for (IPlan iPlan : planHistory_) {
            if (lastPlanVersion == null || !lastPlanVersion.getPlanFileID().equals(iPlan.getPlanFileID())) {
                planVersionsForWhichThePlanFileHasChanged.add(iPlan);
            }
            lastPlanVersion = iPlan;
        }
        return planVersionsForWhichThePlanFileHasChanged;
    }

    private int getOrdinalNumber(IPlan planVersion) {
        int index = 0;
        while (index < this.planHistory.size()) {
            IPlan planHistoryEntry = this.planHistory.get(index);
            if (planHistoryEntry == planVersion) {
                return index + 1;
            }
            ++index;
        }
        assert (false);
        return 0;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selectedHistoryItem = (IPlan)selection.getFirstElement();
        EOCommitInformation commitInformation = ProjectMgr.getProjectMgr().getProjectAgent(this.plan.getProjectUID()).getCockpitController().getCommitInformation(this.selectedHistoryItem.getCommitCount());
        this.description.setText(commitInformation.getCommitComment());
        this.openButton.setEnabled(true);
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return false;
    }

    @Override
    public void commitPropertyChanges1() {
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.emptyList();
    }

    @Override
    public void rollbackCommitRequest() {
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
    }

    @Override
    public int getTypeOfPage() {
        return 40;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    private class HistoryTableContentProvider
    implements IStructuredContentProvider {
        private HistoryTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List history = (List)inputElement;
            return history.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryTableLabelProvider
    implements ITableLabelProvider {
        private HistoryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(PropertyPlanHistory.this.plan.getProjectUID());
            IPlan planVersion = (IPlan)element;
            Integer columnID = (Integer)COLUMNS.get(columnIndex);
            if (columnID.equals(COLUMNID_FILEVERSION)) {
                return String.valueOf(PropertyPlanHistory.this.getOrdinalNumber(planVersion));
            }
            if (columnID.equals(COLUMNID_AUTHOR)) {
                IAttribute author = planVersion.getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
                return planVersion.getAttributeType(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR).getDataType().getValueAsSingleLineString(author.getAttributeValue(), null, null, Locale.getDefault());
            }
            if (columnID.equals(COLUMNID_DATE)) {
                IAttribute creationDate = planVersion.getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
                try {
                    long timestamp = Long.parseLong((String)creationDate.getAttributeValue());
                    return DateFormatHelper.getDefault().getDateTimeFormat(Locale.getDefault()).format(new Date(timestamp));
                }
                catch (NumberFormatException nfE) {
                    return "[unknown]";
                }
            }
            if (columnID.equals(COLUMNID_COMMITCOMMENT)) {
                EOCommitInformation commitInformation = projectAgent.getCockpitController().getCommitInformation(planVersion.getCommitCount());
                return commitInformation.getCommitComment();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class HistoryTableSorter
    extends ViewerSorter {
        private HistoryTableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IPlan && e2 instanceof IPlan) {
                IPlan historyItem1 = (IPlan)e1;
                IPlan historyItem2 = (IPlan)e2;
                return historyItem2.getModificationCount() - historyItem1.getModificationCount();
            }
            logger.error("Invalid Element in the plan history table!");
            return 0;
        }
    }
}

