/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeValueModifiedListener;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralReportTemplates
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralReportTemplates.class);
    private IFrameProjectAgent projectAgent;
    private IReportTemplateRW reportTemplate;
    private IPropertiesDialog propertiesDialog;
    private AttributeTypesComposite composite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog dialog, boolean forCreation) {
        this.reportTemplate = (IReportTemplateRW)elements[0];
        this.setDialog(dialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.propertiesDialog = dialog;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(dialog.getProjectUID());
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IReportTemplateRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE).getIcon();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.propertiesDialog.setTitle(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE).getDisplayName(), this);
        this.propertiesDialog.setMessage(Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.propertiesDialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.propertiesDialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.propertiesDialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.propertiesDialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        ArrayList<IAttributeType> attributetypesToShow = new ArrayList<IAttributeType>();
        IAttributeTypesProvider attributeTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE);
        attributetypesToShow.add(attributeTypesProv.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_NAME));
        attributetypesToShow.add(attributeTypesProv.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_DESCRIPTION));
        attributetypesToShow.add(attributeTypesProv.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_FILE));
        this.composite = new AttributeTypesComposite(this.reportTemplate, parent, attributetypesToShow, false, this.propertiesDialog, this);
        this.composite.create(new GridData(1808));
        IAttributeValueModifiedListener fileModListener = new IAttributeValueModifiedListener(){

            @Override
            public Collection<IModificationProblem> modified(Object newValue, Object additionalInfo) {
                Tuple<IAttribute, Object> fileAttribute = PropertyGeneralReportTemplates.this.composite.getCurrentAttribute(ReportTemplateAttributeTypesProvider.ATTRID_FILE);
                return PropertyGeneralReportTemplates.this.fileModified((Tuple<IAttribute, Object>)fileAttribute);
            }
        };
        this.composite.addModificationListener(ReportTemplateAttributeTypesProvider.ATTRID_FILE, fileModListener);
        return this.composite.getComposite();
    }

    private Collection<IModificationProblem> fileModified(Tuple<IAttribute, Object> attributeAndAdditionalInformation) {
        File file = (File)attributeAndAdditionalInformation.getT2();
        this.projectAgent.getDocGeneratorManager();
        if (DocGeneratorManager.getPossibleReportTypes(file, false).isEmpty()) {
            ModificationProblem problem = new ModificationProblem(Messages.getString("PropertiesGeneralReportTemplate.InvalidReportTemplate.Cause"), Messages.getString("PropertiesGeneralReportTemplate.InvalidReportTemplate.Consequence"), 2);
            return Collections.singleton(problem);
        }
        return Collections.emptyList();
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.composite.isModified();
    }

    public Collection<IModificationProblem> requestCommit() {
        this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.newAttributes = this.composite.getNewAttributes();
        for (IAttribute attribute : this.newAttributes) {
            this.reportTemplate.requestAttributeModificationPermission(attribute, this.transactionController);
        }
        return this.transactionController.execute();
    }

    @Override
    public void commitPropertyChanges1() {
        for (IAttribute attribute : this.newAttributes) {
            try {
                this.reportTemplate.setAttribute(attribute);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    @Override
    public void rollbackCommitRequest() {
        this.transactionController.rollback();
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 0;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        if (this.composite != null) {
            return this.composite.getModificationProblems(true);
        }
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyReportTemplates.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

