/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyFilterReportTemplates
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyFilterReportTemplates.class);
    private IFrameProjectAgent projectAgent;
    private IReportTemplateRW reportTemplate;
    private IPropertiesDialog propertiesDialog;
    private AttributeTypesComposite composite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog dialog, boolean forCreation) {
        this.transactionController = null;
        this.setDialog(dialog);
        this.reportTemplate = (IReportTemplateRW)elements[0];
        if (forCreation) {
            try {
                Attribute filterAttributeFrameSelected = new Attribute(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_FRAME, Boolean.FALSE);
                this.reportTemplate.setAttribute(filterAttributeFrameSelected);
            }
            catch (EXNoPermission filterAttributeFrameSelected) {
            }
            catch (EXNoLock filterAttributeFrameSelected) {
                // empty catch block
            }
            try {
                IAttributeType filterAttributeType = this.reportTemplate.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_MODULES);
                Attribute filterAttributeAllSelected = new Attribute(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_MODULES, filterAttributeType.getValueRange().getValueRange());
                this.reportTemplate.setAttribute(filterAttributeAllSelected);
            }
            catch (EXNoPermission eXNoPermission) {
            }
            catch (EXNoLock eXNoLock) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.propertiesDialog = dialog;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(dialog.getProjectUID());
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IReportTemplateRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertiesFilterReportTemplates.filter");
    }

    @Override
    public Image getPropertyImage() {
        return Icons.getImageForFilter();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.propertiesDialog.setTitle(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE).getDisplayName(), this);
        this.propertiesDialog.setMessage(Messages.getString("PropertiesFilterReportTemplates.define_modules"), 0, this);
        this.propertiesDialog.setIsCommitable(true, this);
        IWorkbenchHelpSystem helpSystem = this.propertiesDialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.propertiesDialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.propertiesDialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.propertiesDialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        ArrayList<IAttributeType> attributetypesToShow = new ArrayList<IAttributeType>();
        IAttributeTypesProvider attributeTypesProv = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE);
        attributetypesToShow.add(attributeTypesProv.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_FRAME));
        attributetypesToShow.add(attributeTypesProv.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_MODULES));
        this.composite = new AttributeTypesComposite(this.reportTemplate, parent, attributetypesToShow, false, this.propertiesDialog, this);
        this.composite.create(new GridData(1808));
        return this.composite.getComposite();
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.composite.isModified();
    }

    @Override
    public void commitPropertyChanges1() {
        for (IAttribute attribute : this.newAttributes) {
            try {
                this.reportTemplate.setAttribute(attribute);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.newAttributes = this.composite.getNewAttributes();
        for (IAttribute attribute : this.newAttributes) {
            this.reportTemplate.requestAttributeModificationPermission(attribute, this.transactionController);
        }
        return this.transactionController.execute();
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
            this.transactionController = null;
        }
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 20;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        if (this.composite != null) {
            return this.composite.getModificationProblems(true);
        }
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyReportTemplates.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

