/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.PropertyAdminUserDefinedAttributeTypesDataType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeCustomProperties;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeCustomPropertiesAdministrate;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.ModuleDataTypeContainer;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.ui.IModificationProblem;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyAdminUserDefinedAttributeTypesModule
implements IPropertiesListEntry {
    private final ModuleDataTypeContainer moduleDataTypeContainer;
    private IPropertiesDialog dialog;
    private IPropertiesListEntry[] childEntries;

    public PropertyAdminUserDefinedAttributeTypesModule(ModuleDataTypeContainer container) {
        this.moduleDataTypeContainer = container;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IFrameProjectAgent) {
            IFrameProjectAgent pa = (IFrameProjectAgent)elements[0];
            return pa.isOpened();
        }
        return false;
    }

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.setDialog(newDialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public String getPropertyName() {
        return this.getPropertyName(this.dialog.getProjectUID());
    }

    public String getPropertyName(String projectUID) {
        ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IFMCAModule module = projectAgent_.getModuleController().getModule(this.moduleDataTypeContainer.getModuleID());
        return module.getDisplayName();
    }

    @Override
    public Image getPropertyImage() {
        ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(this.dialog.getProjectUID());
        IFMCAModule module = projectAgent_.getModuleController().getModule(this.moduleDataTypeContainer.getModuleID());
        return module.getImage();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.dialog.setTitle(Messages.getString("PropertyAdminUserDefinedAttributeTypes.admin_custom_properties"), this);
        this.dialog.setMessage(Messages.getString("PropertyAdminUserDefinedAttributeTypes.plz_sel_sub_entry_for_admin"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setLayoutData((Object)new GridData(1808));
        parentComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(parentComposite, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(Messages.getString("PropertyAdminUserDefinedAttributeTypes.plz_sel_sub_entry"));
        return parentComposite;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        if (this.childEntries == null) {
            IModuleDataTypeDescriptionForFrame[] allDatatypes = this.moduleDataTypeContainer.getDataTypes();
            IPropertiesListEntry[] directChildren = new IPropertiesListEntry[allDatatypes.length];
            int i = 0;
            while (i < allDatatypes.length) {
                IModuleDataTypeDescriptionForFrame dataType = allDatatypes[i];
                PropertyAdminUserDefinedAttributeTypesDataType le = new PropertyAdminUserDefinedAttributeTypesDataType(dataType);
                directChildren[i] = le;
                ++i;
            }
            this.childEntries = directChildren;
        }
        return this.childEntries;
    }

    @Override
    public boolean hasChanges() {
        return false;
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.emptyList();
    }

    @Override
    public void rollbackCommitRequest() {
    }

    @Override
    public void commitPropertyChanges1() {
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
    }

    @Override
    public int getTypeOfPage() {
        return 30;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeCustomProperties.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeCustomPropertiesAdministrate.getInstance();
    }
}

