/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.preferencePages.AbstractLicensesPreferencePage;
import com.arcway.cockpit.frame.client.global.gui.properties.IFramePropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeProvider;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayTitleAreaDialog;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertiesDialog
extends ArcwayTitleAreaDialog
implements IFramePropertiesDialog,
ISelectionChangedListener {
    private static final ILogger logger = Logger.getLogger(PropertiesDialog.class);
    public static final int DEFAULT_PROPERTIES_PAGE_MINIMUM_WITH = 600;
    private static final int HEIGHT = 500;
    private static final int WIDTH = 850;
    private boolean informedAboutClosing = false;
    private List<IPropertiesListEntry> propertiesList = null;
    private TreeViewer treeViewer;
    private Composite propertiesPage;
    private StackLayout stackLayout;
    private IPropertiesListEntry currentProperty;
    private final IWorkbenchPage workbenchPage;
    private final IFrameProjectAgent projectAgent;
    private boolean mayEditProperties = true;
    private final Map<IPropertiesListEntry, TitleMessage> messages = new HashMap<IPropertiesListEntry, TitleMessage>();
    private final Map<IPropertiesListEntry, String> titles = new HashMap<IPropertiesListEntry, String>();
    private final Collection<IPropertiesListEntry> notCommittableEntries = new ArrayList<IPropertiesListEntry>();
    private final Collection<IPropertiesListEntry> notCancelableEntries = new ArrayList<IPropertiesListEntry>();
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private final Map<IPropertiesListEntry, Control> entries_controls_map = new HashMap<IPropertiesListEntry, Control>();
    private final Comparator<IPropertiesListEntry> entriesComparator = new Comparator<IPropertiesListEntry>(){

        @Override
        public int compare(IPropertiesListEntry e0, IPropertiesListEntry e1) {
            Integer i1;
            Integer i0 = e0.getTypeOfPage();
            if (!i0.equals(i1 = Integer.valueOf(e1.getTypeOfPage()))) {
                return i0.compareTo(i1);
            }
            return e0.getPropertyName().compareToIgnoreCase(e1.getPropertyName());
        }
    };
    private final HashSet<Image> storeOfImagesWithNoLicenseLabel = new HashSet();
    private ArrayList<ICockpitProjectData> currentlySelectedData = null;
    private final Set<IObjectTypeCategoryChangeListener> objectTypeCategoryChangeListener = new HashSet<IObjectTypeCategoryChangeListener>();
    private final Set<IObjectTypeCategoryChangeProvider> objectTypeCategoryChangeProvider = new HashSet<IObjectTypeCategoryChangeProvider>();

    public PropertiesDialog(IWorkbenchPage page, IFrameProjectAgent projectAgent, ICockpitProjectData[] selectedData) {
        super(page.getWorkbenchWindow().getShell(), true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.setHelpAvailable(true);
        this.workbenchPage = page;
        this.projectAgent = projectAgent;
        this.currentlySelectedData = new ArrayList<ICockpitProjectData>(Arrays.asList(selectedData));
        ICockpitProjectData[] iCockpitProjectDataArray = selectedData;
        int n = selectedData.length;
        int n2 = 0;
        while (n2 < n) {
            ICockpitProjectData element = iCockpitProjectDataArray[n2];
            if (element instanceof IAttributeOwnerRW) {
                IAttributeOwnerRW rw = (IAttributeOwnerRW)element;
                IModificationProblem modProblem = rw.checkLocks();
                if (modProblem != null) {
                    this.addModificationProblem(modProblem);
                    this.mayEditProperties = false;
                }
            } else {
                this.mayEditProperties = false;
            }
            ++n2;
        }
    }

    @Override
    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public String getProjectUID() {
        return this.projectAgent.getProjectUID();
    }

    public void addRootProperty(IPropertiesListEntry property) {
        if (this.propertiesList == null) {
            this.propertiesList = new ArrayList<IPropertiesListEntry>();
        }
        this.propertiesList.add(property);
    }

    public Collection<IPropertiesListEntry> getRootProperties() {
        if (this.propertiesList != null) {
            return new ArrayList<IPropertiesListEntry>(this.propertiesList);
        }
        return Collections.emptyList();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(com.arcway.cockpit.frame.client.global.Messages.getString("PropertiesDialog.Properties_1"));
        IWorkbenchHelpSystem helpSystem = this.workbenchPage.getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
        this.getTitleImageLabel().setText("\n\n\n\n\n");
        SashForm area = new SashForm(parent, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 850;
        gd.heightHint = 500;
        area.setLayout((Layout)new GridLayout(2, false));
        this.createTreeViewer((Composite)area);
        this.propertiesPage = this.createPropPage((Composite)area);
        area.setLayoutData((Object)gd);
        this.treeViewer.getTree().setFocus();
        area.setWeights(new int[]{1, 3});
        return area;
    }

    protected void dialogConstructed() {
        Tree tree = this.treeViewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            StructuredSelection selection = new StructuredSelection(item.getData());
            this.treeViewer.setSelection((ISelection)selection);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.setErrorMessage(null);
        return bar;
    }

    private void createTreeViewer(Composite parent) {
        Collections.sort(this.propertiesList, this.entriesComparator);
        this.treeViewer = new TreeViewer(parent, 2820);
        GridData data = new GridData(1040);
        this.treeViewer.getTree().setLayoutData((Object)data);
        TreeViewerContentProvider cp = new TreeViewerContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)cp);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setInput((Object)"start");
    }

    private Composite createPropPage(Composite parent) {
        Composite c = new Composite(parent, 2048);
        GridData data = new GridData(4, 4, true, true);
        c.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        c.setLayout((Layout)this.stackLayout);
        return c;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IPropertiesListEntry newProperty;
        IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
        if (sel.size() > 0 && (newProperty = (IPropertiesListEntry)sel.getFirstElement()) != this.currentProperty) {
            String title;
            Control control;
            this.currentProperty = newProperty;
            this.setErrorMessage(null);
            this.setTitle(null);
            this.setMessage(null);
            if (this.hasLicense(newProperty)) {
                control = this.entries_controls_map.get(this.currentProperty);
                if (control == null) {
                    control = this.currentProperty.getPropertyPage(this.propertiesPage);
                    this.entries_controls_map.put(this.currentProperty, control);
                    if (this.currentProperty instanceof IObjectTypeCategoryChangeProvider) {
                        IObjectTypeCategoryChangeProvider provider = (IObjectTypeCategoryChangeProvider)((Object)this.currentProperty);
                        this.objectTypeCategoryChangeProvider.add(provider);
                        for (IObjectTypeCategoryChangeListener listener : this.objectTypeCategoryChangeListener) {
                            provider.addCategoryChangeListener(listener, true);
                        }
                    }
                    if (this.currentProperty instanceof IObjectTypeCategoryChangeListener) {
                        IObjectTypeCategoryChangeListener listener = (IObjectTypeCategoryChangeListener)((Object)this.currentProperty);
                        this.objectTypeCategoryChangeListener.add(listener);
                        for (IObjectTypeCategoryChangeProvider provider : this.objectTypeCategoryChangeProvider) {
                            provider.addCategoryChangeListener(listener, true);
                        }
                    }
                }
            } else {
                control = this.entries_controls_map.get(this.currentProperty);
                if (control == null) {
                    control = PropertiesDialog.getPropertyPageForUnlicensedEntries(this.propertiesPage);
                    this.entries_controls_map.put(this.currentProperty, control);
                }
            }
            this.stackLayout.topControl = control;
            TitleMessage messageToShow = this.messages.get(this.currentProperty);
            if (messageToShow != null) {
                this.setMessage(messageToShow.getNewMessage(), messageToShow.getNewSeverity());
            }
            if ((title = this.titles.get(this.currentProperty)) == null) {
                title = "";
            }
            this.setTitle(title);
            this.propertiesPage.layout();
            this.updateModificationProblems();
            this.updateDialogMessage();
        }
    }

    public void updateModificationProblems() {
        ArrayList<IModificationProblem> currentModificationProblems = new ArrayList<IModificationProblem>();
        if (this.currentProperty != null) {
            currentModificationProblems.addAll(this.currentProperty.getModificationProblems());
        }
        currentModificationProblems.addAll(this.modificationProblems);
        this.setModificationProblems(currentModificationProblems);
    }

    private static Control getPropertyPageForUnlicensedEntries(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)base, (int)0);
        browser.setHtml(AbstractLicensesPreferencePage.getHTMLTextForLimitedVersion(Display.getDefault().getSystemColor(29), 2));
        Control browserControl = browser.getSWTControl();
        browserControl.setLayoutData((Object)new GridData(1808));
        return base;
    }

    @Override
    public boolean mayModify() {
        return this.mayEditProperties;
    }

    public int open() {
        if (this.propertiesList != null && !this.propertiesList.isEmpty()) {
            return super.open();
        }
        return 1;
    }

    protected void okPressed() {
        boolean exclusiveProjectLockIsConflicting;
        final ArrayList<ModificationProblem> modProblems = new ArrayList<ModificationProblem>();
        final ArrayList<IPropertiesListEntry> entries = new ArrayList<IPropertiesListEntry>(this.entries_controls_map.keySet());
        Collections.sort(entries, this.entriesComparator);
        boolean bl = exclusiveProjectLockIsConflicting = !this.projectAgent.getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

            @Override
            public void run() {
                for (IPropertiesListEntry entry : entries) {
                    if (!PropertiesDialog.this.hasLicense(entry)) continue;
                    modProblems.addAll(entry.requestCommit());
                }
                if (modProblems.isEmpty()) {
                    PropertiesDialog.this.informedAboutClosing = true;
                    for (IPropertiesListEntry entry : entries) {
                        try {
                            if (PropertiesDialog.this.hasLicense(entry)) {
                                entry.commitPropertyChanges1();
                            } else {
                                entry.cancelPropertyChanges1();
                            }
                            entry.disposeResources();
                        }
                        catch (Exception e) {
                            logger.error("error while excuting property changes", (Throwable)e);
                        }
                    }
                    PropertiesDialog.super.okPressed();
                } else {
                    for (IPropertiesListEntry entry : entries) {
                        if (PropertiesDialog.this.hasLicense(entry)) {
                            entry.rollbackCommitRequest();
                            continue;
                        }
                        entry.cancelPropertyChanges1();
                    }
                }
            }
        });
        if (exclusiveProjectLockIsConflicting) {
            modProblems.add(new ModificationProblem(Messages.getString("PropertiesDialogue.ExclusiveProjectLockMessage.Cause"), Messages.getString("PropertiesDialogue.ExclusiveProjectLockMessage.Problem")));
        }
        if (!modProblems.isEmpty()) {
            ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modProblems, this.getShell());
            modificationProblemsDialog.open();
        }
    }

    protected void cancelPressed() {
        if (this.cancelChanges()) {
            this.informedAboutClosing = true;
            super.cancelPressed();
        }
    }

    public boolean close() {
        if (!this.informedAboutClosing) {
            if (this.cancelChanges()) {
                this.informedAboutClosing = true;
            } else {
                return false;
            }
        }
        for (IObjectTypeCategoryChangeProvider provider : this.objectTypeCategoryChangeProvider) {
            for (IObjectTypeCategoryChangeListener listener : this.objectTypeCategoryChangeListener) {
                provider.removeCategoryChangeListener(listener);
            }
        }
        return super.close();
    }

    @Override
    public void setIsCommitable(boolean isCommitable, IPropertiesListEntry entry) {
        if (isCommitable) {
            this.notCommittableEntries.remove(entry);
        } else if (!this.notCommittableEntries.contains(entry)) {
            this.notCommittableEntries.add(entry);
        }
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(this.notCommittableEntries.isEmpty());
        }
    }

    @Override
    public void setIsCancelable(boolean isCancelable, IPropertiesListEntry entry) {
        if (isCancelable) {
            this.notCancelableEntries.remove(entry);
        } else if (!this.notCancelableEntries.contains(entry)) {
            this.notCancelableEntries.add(entry);
        }
        Button btn = this.getButton(1);
        if (btn != null) {
            btn.setEnabled(this.notCancelableEntries.isEmpty());
        }
    }

    private boolean cancelChanges() {
        boolean execute = true;
        for (IPropertiesListEntry entry : this.entries_controls_map.keySet()) {
            boolean discard;
            if (!this.hasLicense(entry) || !entry.hasChanges()) continue;
            execute = discard = MessageDialog.openQuestion((Shell)this.getShell(), (String)com.arcway.cockpit.frame.client.global.Messages.getString("PropertiesDialog.discard_changes"), (String)com.arcway.cockpit.frame.client.global.Messages.getString("PropertiesDialog.do_you_want_discard"));
            break;
        }
        if (execute) {
            for (IPropertiesListEntry entry : this.entries_controls_map.keySet()) {
                entry.cancelPropertyChanges1();
                entry.disposeResources();
            }
        }
        return execute;
    }

    protected void dispose() {
        for (Control control : this.entries_controls_map.values()) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        for (Image image : this.storeOfImagesWithNoLicenseLabel) {
            image.dispose();
        }
        this.storeOfImagesWithNoLicenseLabel.clear();
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    private void addModificationProblem(IModificationProblem modificationProblem) {
        this.modificationProblems.add(modificationProblem);
        this.updateModificationProblems();
    }

    @Override
    public void setMessage(String message, int severity, IPropertiesListEntry entry) {
        TitleMessage titleMessage = message != null ? new TitleMessage(message, severity, null) : new TitleMessage("", 0, null);
        this.messages.put(entry, titleMessage);
        this.updateDialogMessage();
    }

    private void updateDialogMessage() {
        TitleMessage mostSevereMessage = this.messages.get(this.currentProperty);
        if (mostSevereMessage != null) {
            IPropertiesListEntry mostSevereEntry = this.currentProperty;
            for (Map.Entry<IPropertiesListEntry, TitleMessage> singleMessageEntry : this.messages.entrySet()) {
                IPropertiesListEntry entry = singleMessageEntry.getKey();
                TitleMessage message = singleMessageEntry.getValue();
                if (message.getNewSeverity() <= mostSevereMessage.getNewSeverity()) continue;
                mostSevereMessage = message;
                mostSevereEntry = entry;
            }
            StringBuilder message = new StringBuilder(128);
            if (mostSevereEntry != null && !mostSevereEntry.equals(this.currentProperty)) {
                message.append(mostSevereEntry.getPropertyName()).append(": ");
            }
            message.append(mostSevereMessage.getNewMessage());
            this.setMessage(message.toString(), mostSevereMessage.getNewSeverity());
        } else {
            this.setMessage(null, 0);
        }
    }

    @Override
    public void setTitle(String title, IPropertiesListEntry entry) {
        this.titles.put(entry, title);
        this.setTitle(title);
    }

    private boolean hasLicense(IPropertiesListEntry entry) {
        boolean hasLicense = true;
        if (this.currentlySelectedData != null) {
            for (ICockpitProjectData element : this.currentlySelectedData) {
                IClientFunctionLicenseType2 licenseType = entry.getRequiredLicenseTypeForModifying(element);
                if (licenseType == null) continue;
                boolean bl = hasLicense = hasLicense && this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(licenseType);
            }
        }
        return hasLicense;
    }

    protected void handleShellCloseEvent() {
        if (!this.notCancelableEntries.isEmpty()) {
            this.helpPressed();
        } else {
            super.handleShellCloseEvent();
        }
    }

    private static class TitleMessage {
        private final String message;
        private final int severity;
        private final TitleMessage oldMessage;

        public TitleMessage(String newMessage, int newSeverity, TitleMessage oldMessage) {
            this.message = newMessage;
            this.severity = newSeverity;
            this.oldMessage = oldMessage;
        }

        public String getNewMessage() {
            return this.message;
        }

        public int getNewSeverity() {
            return this.severity;
        }

        public TitleMessage getOldMessage() {
            return this.oldMessage;
        }
    }

    private class TreeViewerContentProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private TreeViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PropertiesDialog.this.propertiesList.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            IPropertiesListEntry entry = (IPropertiesListEntry)parentElement;
            return entry.getPropertyChildren1();
        }

        public boolean hasChildren(Object element) {
            IPropertiesListEntry entry = (IPropertiesListEntry)element;
            return entry.getPropertyChildren1() != null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public String getText(Object element) {
            IPropertiesListEntry entry = (IPropertiesListEntry)element;
            return entry.getPropertyName();
        }

        public Image getImage(Object element) {
            IPropertiesListEntry entry = (IPropertiesListEntry)element;
            Image image = entry.getPropertyImage();
            if (image == null) {
                image = this.hasChildren(element) ? Icons.getImageForObjectsWithChildren() : Icons.getImageForObjectsWithoutChildren();
            }
            if (!PropertiesDialog.this.hasLicense(entry)) {
                image = this.addNoLicenseDecorator(image);
                PropertiesDialog.this.storeOfImagesWithNoLicenseLabel.add(image);
            }
            return image;
        }

        private Image addNoLicenseDecorator(Image image) {
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(image);
            decoratedImage.addDecorator(FramePlugin.getImageDescriptor("license_restriction.gif"), 3);
            return decoratedImage.createImage();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

