/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.actions;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOpenPlanAction
extends Action {
    private static final ILogger logger = Logger.getLogger(AbstractOpenPlanAction.class);
    private IWorkbenchPage page;
    private PlanDisplayParameters planDisplayParameters;
    private int mode;
    private Shell parentShell;
    private ISelectionProvider selectionProvider;

    public AbstractOpenPlanAction(ISelectionProvider selectionProvider, IWorkbenchPage page, Shell parentShell, int mode) {
        this.setup(selectionProvider, page, parentShell, mode, new PlanDisplayParameters());
    }

    public AbstractOpenPlanAction(ISelectionProvider selectionProvider, IWorkbenchPage page, Shell parentShell, PlanDisplayParameters planDisplayParameters) {
        this.setup(selectionProvider, page, parentShell, 3, planDisplayParameters);
    }

    private void setup(ISelectionProvider sp, IWorkbenchPage workbenchPage, Shell shell, int workingMode, PlanDisplayParameters planDisplayParameters) {
        assert (sp != null);
        assert (workbenchPage != null);
        assert (shell != null);
        this.selectionProvider = sp;
        this.page = workbenchPage;
        this.parentShell = shell;
        this.mode = workingMode;
        if (planDisplayParameters == null) {
            logger.error("planDisplayParameters is null");
        }
        this.planDisplayParameters = planDisplayParameters;
    }

    protected Shell getParentShell() {
        return this.parentShell;
    }

    public PlanDisplayParameters getPlanDisplayParameters() {
        return this.planDisplayParameters;
    }

    protected List<IPlan> getSelectedPlans(String projectUID) {
        return this.getSelectedPlans(projectUID, true);
    }

    protected List<IPlan> getSelectedPlans(boolean forceSameProjectID) {
        return this.getSelectedPlans(null, forceSameProjectID);
    }

    protected List<IPlan> getSelectedPlans(String projectUIDToCheck, boolean forceSameProjectID) {
        ArrayList<IPlan> selectedPlans = new ArrayList<IPlan>();
        if (this.selectionProvider.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            boolean areSelectionProjectUIDsValid = false;
            if (forceSameProjectID) {
                String projectIDOfSelectedObjects = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
                if (projectUIDToCheck == null && projectIDOfSelectedObjects != null || projectUIDToCheck != null && projectUIDToCheck.equals(projectIDOfSelectedObjects)) {
                    areSelectionProjectUIDsValid = true;
                }
            } else {
                areSelectionProjectUIDsValid = true;
            }
            if (areSelectionProjectUIDsValid) {
                for (Object selectedElement : selection.toList()) {
                    if (!(selectedElement instanceof IPlan)) continue;
                    selectedPlans.add((IPlan)selectedElement);
                }
            }
        }
        return selectedPlans;
    }

    protected IExternalPlanEditorControllerExtension getPlanEditorControllerExtensions(IPlan plan) {
        ProjectAgent agent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
        assert (agent != null);
        Collection<IExternalPlanEditorControllerExtension> ctrls = agent.getPlanEditorManager().getPlanEditorControllerExtensions(plan, this.page, this.planDisplayParameters);
        IExternalPlanEditorControllerExtension ctrl = ctrls.isEmpty() ? null : ctrls.iterator().next();
        return ctrl;
    }

    protected void setEmptySelection(IExternalPlanEditorControllerExtension ctrl) {
        ctrl.selectElements(Collections.EMPTY_LIST);
    }

    protected void launchPlan(IPlan plan) {
        ProjectAgent agent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
        assert (agent != null);
        if (this.planDisplayParameters == null) {
            if (this.mode == 1) {
                agent.getPlanEditorManager().openSinglePlanEditorInEditmode(this.page, plan, true);
            } else {
                agent.getPlanEditorManager().openSinglePlanEditorInProjectorMode(this.page, plan, true);
            }
        } else {
            agent.getPlanEditorManager().openSinglePlanEditorWithPlanDisplayParameters(this.page, plan, this.planDisplayParameters);
        }
    }

    protected int updatePerspective() {
        IWorkbenchPage workbenchPage;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPerspective = registry.findPerspectiveWithId(this.getPreferredPerspectiveID());
        if (finalPerspective == null) {
            logger.warn("Unable to find perspective" + FramePlugin.getResourceString(String.valueOf(this.getPreferredPerspectiveID()) + "in CreateNewProjectWizard.updatePerspective()"));
            return 3;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (workbenchPage = window.getActivePage()) != null) {
            IPerspectiveDescriptor currentPerspective = workbenchPage.getPerspective();
            if (currentPerspective != null && currentPerspective.getId().equals(finalPerspective.getId())) {
                return 3;
            }
            int _switch = this.confirmPerspectiveSwitch(window, finalPerspective);
            if (_switch == 3 || _switch == 1) {
                return _switch;
            }
        }
        if (window == null) {
            return 3;
        }
        workbenchPage = window.getActivePage();
        if (workbenchPage == null) {
            return 3;
        }
        workbenchPage.setPerspective(finalPerspective);
        return 2;
    }

    protected abstract String getPreferredPerspectiveID();

    protected abstract String getSwitchPreferenceKey();

    private int confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPerspective) {
        IPreferenceStore store = FramePlugin.getDefault().getPreferenceStore();
        String switchPref = store.getString(this.getSwitchPreferenceKey());
        if (switchPref.equals("always")) {
            return 2;
        }
        if (switchPref.equals("never")) {
            return 3;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)window.getShell(), (String)Messages.getString("AbstractOpenPlanAction.SwitchDialogTitle"), (String)(String.valueOf(Messages.getString("AbstractOpenPlanAction.SwitchDialogText_1")) + finalPerspective.getLabel() + Messages.getString("AbstractOpenPlanAction.SwitchDialogText_2")), (String)Messages.getString("AbstractOpenPlanAction.SwitchDialogToggle"), (boolean)false, (IPreferenceStore)store, (String)this.getSwitchPreferenceKey());
        return dialog.getReturnCode();
    }
}

