/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.consoleui.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.AbstractStringParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.CockpitConsoleActionParameterSpecifications;
import com.arcway.cockpit.frame.client.global.consoleui.ConsoleActionParameterBindings;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleAction;
import com.arcway.cockpit.frame.client.global.consoleui.ICockpitConsoleActionParameterSpecification;
import com.arcway.cockpit.frame.client.global.consoleui.IParameterLog;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptAuthenticator;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptExecutionException;
import com.arcway.cockpit.frame.client.global.consoleui.parameterspecifications.ServerParameterSpecification;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.net.PasswordAuthentication;
import java.util.Arrays;

public class LoginAction
implements ICockpitConsoleAction {
    private static final String COMMAND_NAME = "login";
    private static final ICockpitConsoleActionParameterSpecification<String> USERNAME_PARAM_SPEC = new AbstractStringParameterSpecification(){

        @Override
        public String getParameterName() {
            return "username";
        }
    };
    private static final ICockpitConsoleActionParameterSpecification<String> PASSWORD_PARAM_SPEC = new AbstractStringParameterSpecification(){

        @Override
        public String getParameterName() {
            return "password";
        }
    };
    private static final CockpitConsoleActionParameterSpecifications parameterSpecifications = new CockpitConsoleActionParameterSpecifications(Arrays.asList(ServerParameterSpecification.getSingleton(), USERNAME_PARAM_SPEC, PASSWORD_PARAM_SPEC));

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public CockpitConsoleActionParameterSpecifications getParametersSpecifications() {
        return parameterSpecifications;
    }

    @Override
    public void execute(ConsoleActionParameterBindings parameters, IParameterLog parameterLog, ScriptCommandContext uiContext) throws ScriptExecutionException {
        String serverName = parameters.getValue(ServerParameterSpecification.getSingleton());
        String username = parameters.getValue(USERNAME_PARAM_SPEC);
        String password = parameters.getValue(PASSWORD_PARAM_SPEC);
        ScriptAuthenticator.memorizePasswordAuthentication(new PasswordAuthentication(username, password.toCharArray()));
        IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxyByServerName(serverName);
        if (sp != null) {
            parameterLog.logParameters(String.valueOf(serverName) + " / " + username);
            try {
                sp.login(username, password);
            }
            catch (ServerNotAvailableException e) {
                throw new ScriptExecutionException("Login failed. Cause: " + e.getLocalizedMessage(), e);
            }
            catch (EXServerException e) {
                throw new ScriptExecutionException("Login failed. Cause: " + e.getLocalizedMessage(), e);
            }
            catch (LoginCanceledException e) {
                throw new ScriptExecutionException("Login failed. Cause: " + e.getLocalizedMessage(), e);
            }
        } else {
            throw new ScriptExecutionException("Login failed. None of the configured servers was labeled with the name: " + serverName);
        }
    }
}

